/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.accessmanager.impl;

import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObjectBuilder;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.Principal;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.security.Privilege;
import org.apache.sling.jcr.jackrabbit.accessmanager.LocalPrivilege;
import org.apache.sling.jcr.jackrabbit.accessmanager.LocalRestriction;
import org.apache.sling.jcr.jackrabbit.accessmanager.post.DeclarationType;

public class JsonConvert {
    public static final String KEY_PRINCIPAL = "principal";
    public static final String KEY_ORDER = "order";
    public static final String KEY_PRIVILEGES = "privileges";
    public static final String KEY_ALLOW = "allow";
    public static final String KEY_DENY = "deny";
    public static final String KEY_DECLARED_AT = "declaredAt";

    private JsonConvert() {
    }

    public static JsonObjectBuilder convertToJson(Principal principal, Map<Privilege, LocalPrivilege> entry, int order) {
        Collection<LocalPrivilege> privileges;
        JsonObjectBuilder principalObj = Json.createObjectBuilder();
        principalObj.add(KEY_PRINCIPAL, principal.getName());
        if (order != -1) {
            principalObj.add(KEY_ORDER, order);
        }
        if (!(privileges = entry.values()).isEmpty()) {
            JsonObjectBuilder privilegesObj = Json.createObjectBuilder();
            for (LocalPrivilege pi : privileges) {
                if (pi.isNone()) continue;
                JsonObjectBuilder privilegeObj = Json.createObjectBuilder();
                if (pi.isAllow()) {
                    JsonConvert.addRestrictions(privilegeObj, KEY_ALLOW, pi.getAllowRestrictions());
                }
                if (pi.isDeny()) {
                    JsonConvert.addRestrictions(privilegeObj, KEY_DENY, pi.getDenyRestrictions());
                }
                privilegesObj.add(pi.getName(), privilegeObj);
            }
            principalObj.add(KEY_PRIVILEGES, privilegesObj);
        }
        return principalObj;
    }

    public static void addDeclaredAt(JsonObjectBuilder principalObj, Map<DeclarationType, Set<String>> declaredAt) {
        JsonObjectBuilder declaredAtBuilder = Json.createObjectBuilder();
        for (Map.Entry<DeclarationType, Set<String>> daentry : declaredAt.entrySet()) {
            DeclarationType type = daentry.getKey();
            if (type == null) continue;
            Set<String> value = daentry.getValue();
            if (value.size() == 1) {
                declaredAtBuilder.add(type.getJsonKey(), value.iterator().next());
                continue;
            }
            JsonArrayBuilder typeBuilder = Json.createArrayBuilder();
            for (String at : value) {
                typeBuilder.add(at);
            }
            declaredAtBuilder.add(type.getJsonKey(), typeBuilder);
        }
        principalObj.add(KEY_DECLARED_AT, declaredAtBuilder);
    }

    public static void addRestrictions(JsonObjectBuilder privilegeObj, String key, Set<LocalRestriction> restrictions) {
        if (restrictions.isEmpty()) {
            privilegeObj.add(key, true);
        } else {
            JsonObjectBuilder allowObj = Json.createObjectBuilder();
            for (LocalRestriction ri : restrictions) {
                if (ri.isMultiValue()) {
                    JsonArrayBuilder rvalues = Json.createArrayBuilder();
                    for (Value value : ri.getValues()) {
                        JsonConvert.addTo(rvalues, value);
                    }
                    allowObj.add(ri.getName(), rvalues);
                    continue;
                }
                JsonConvert.addTo(allowObj, ri.getName(), ri.getValue());
            }
            privilegeObj.add(key, allowObj);
        }
    }

    public static JsonObjectBuilder addTo(JsonObjectBuilder builder, String key, Object value) {
        if ((value = JsonConvert.convertJcrValue(value)) instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            builder.add(key, ((Number)value).longValue());
        } else if (value instanceof BigDecimal) {
            builder.add(key, (BigDecimal)value);
        } else if (value instanceof BigInteger) {
            builder.add(key, (BigInteger)value);
        } else if (value instanceof Boolean) {
            builder.add(key, ((Boolean)value).booleanValue());
        } else if (value instanceof Float || value instanceof Double) {
            builder.add(key, ((Number)value).doubleValue());
        } else if (value instanceof Privilege) {
            JsonObjectBuilder privilegeBuilder = Json.createObjectBuilder();
            privilegeBuilder.add("name", ((Privilege)value).getName());
            builder.add(key, privilegeBuilder);
        } else if (value instanceof String) {
            builder.add(key, (String)value);
        } else {
            builder.add(key, value.toString());
        }
        return builder;
    }

    public static JsonArrayBuilder addTo(JsonArrayBuilder builder, Object value) {
        if ((value = JsonConvert.convertJcrValue(value)) instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            builder.add(((Number)value).longValue());
        } else if (value instanceof BigDecimal) {
            builder.add((BigDecimal)value);
        } else if (value instanceof BigInteger) {
            builder.add((BigInteger)value);
        } else if (value instanceof Boolean) {
            builder.add(((Boolean)value).booleanValue());
        } else if (value instanceof Float || value instanceof Double) {
            builder.add(((Number)value).doubleValue());
        } else if (value instanceof String) {
            builder.add((String)value);
        } else {
            builder.add(value.toString());
        }
        return builder;
    }

    private static Object convertJcrValue(Object value) {
        if (value instanceof Value) {
            try {
                Value jcrValue = (Value)value;
                int valueType = jcrValue.getType();
                value = valueType == 4 ? Double.valueOf(jcrValue.getDouble()) : (valueType == 12 ? jcrValue.getDecimal() : (valueType == 3 ? Long.valueOf(jcrValue.getLong()) : (valueType == 6 ? Boolean.valueOf(jcrValue.getBoolean()) : jcrValue.getString())));
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return value;
    }
}

