/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.obj;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.jackrabbit.core.fs.BasedFileSystem;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.fs.local.LocalFileSystem;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.persistence.AbstractPersistenceManager;
import org.apache.jackrabbit.core.persistence.PMContext;
import org.apache.jackrabbit.core.persistence.util.BLOBStore;
import org.apache.jackrabbit.core.persistence.util.FileSystemBLOBStore;
import org.apache.jackrabbit.core.persistence.util.Serializer;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ObjectPersistenceManager
extends AbstractPersistenceManager {
    private static Logger log = LoggerFactory.getLogger(ObjectPersistenceManager.class);
    private static final char[] HEXDIGITS = "0123456789abcdef".toCharArray();
    private static final String NODEFILENAME = ".node";
    private static final String NODEREFSFILENAME = ".references";
    private boolean initialized = false;
    private FileSystem itemStateFS;
    private FileSystem blobFS;
    private BLOBStore blobStore;

    private static String buildNodeFolderPath(NodeId id) {
        StringBuilder sb = new StringBuilder();
        char[] chars = id.toString().toCharArray();
        int cnt = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '-') continue;
            if (cnt == 2 || cnt == 4) {
                sb.append('/');
            }
            sb.append(chars[i]);
            ++cnt;
        }
        return sb.toString();
    }

    private static String buildPropFilePath(PropertyId id) {
        String fileName;
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(id.getName().getNamespaceURI().getBytes());
            md5.update(id.getName().getLocalName().getBytes());
            byte[] bytes = md5.digest();
            char[] chars = new char[32];
            int j = 0;
            for (int i = 0; i < 16; ++i) {
                chars[j++] = HEXDIGITS[bytes[i] >> 4 & 0xF];
                chars[j++] = HEXDIGITS[bytes[i] & 0xF];
            }
            fileName = new String(chars);
        }
        catch (NoSuchAlgorithmException nsae) {
            String msg = "MD5 not available: ";
            log.error(msg, (Throwable)nsae);
            throw new InternalError(msg + nsae);
        }
        return ObjectPersistenceManager.buildNodeFolderPath(id.getParentId()) + "/" + fileName;
    }

    private static String buildNodeFilePath(NodeId id) {
        return ObjectPersistenceManager.buildNodeFolderPath(id) + "/" + NODEFILENAME;
    }

    private static String buildNodeReferencesFilePath(NodeId id) {
        return ObjectPersistenceManager.buildNodeFolderPath(id) + "/" + NODEREFSFILENAME;
    }

    @Override
    public void init(PMContext context) throws Exception {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        FileSystem wspFS = context.getFileSystem();
        this.itemStateFS = new BasedFileSystem(wspFS, "/data");
        LocalFileSystem blobFS = new LocalFileSystem();
        blobFS.setRoot(new File(context.getHomeDir(), "blobs"));
        blobFS.init();
        this.blobFS = blobFS;
        this.blobStore = new FileSystemBLOBStore(blobFS);
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws Exception {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        try {
            this.blobFS.close();
            this.blobFS = null;
            this.blobStore = null;
        }
        finally {
            this.initialized = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized NodeState load(NodeId id) throws NoSuchItemStateException, ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        String nodeFilePath = ObjectPersistenceManager.buildNodeFilePath(id);
        try {
            if (!this.itemStateFS.isFile(nodeFilePath)) {
                throw new NoSuchItemStateException(nodeFilePath);
            }
        }
        catch (FileSystemException fse) {
            String msg = "failed to read node state: " + nodeFilePath;
            log.debug(msg);
            throw new ItemStateException(msg, fse);
        }
        try {
            BufferedInputStream in = new BufferedInputStream(this.itemStateFS.getInputStream(nodeFilePath));
            try {
                NodeState state = this.createNew(id);
                Serializer.deserialize(state, (InputStream)in);
                NodeState nodeState = state;
                return nodeState;
            }
            catch (Exception e) {
                String msg = "failed to read node state: " + id;
                log.debug(msg);
                throw new ItemStateException(msg, e);
            }
            finally {
                in.close();
            }
        }
        catch (Exception e) {
            String msg = "failed to read node state: " + nodeFilePath;
            log.debug(msg);
            throw new ItemStateException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized PropertyState load(PropertyId id) throws NoSuchItemStateException, ItemStateException {
        PropertyState propertyState;
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        String propFilePath = ObjectPersistenceManager.buildPropFilePath(id);
        try {
            if (!this.itemStateFS.isFile(propFilePath)) {
                throw new NoSuchItemStateException(propFilePath);
            }
        }
        catch (FileSystemException fse) {
            String msg = "failed to read property state: " + propFilePath;
            log.debug(msg);
            throw new ItemStateException(msg, fse);
        }
        BufferedInputStream in = new BufferedInputStream(this.itemStateFS.getInputStream(propFilePath));
        try {
            PropertyState state = this.createNew(id);
            Serializer.deserialize(state, in, this.blobStore);
            propertyState = state;
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (Exception e) {
                String msg = "failed to read property state: " + propFilePath;
                log.debug(msg);
                throw new ItemStateException(msg, e);
            }
        }
        in.close();
        return propertyState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized NodeReferences loadReferencesTo(NodeId id) throws NoSuchItemStateException, ItemStateException {
        NodeReferences nodeReferences;
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        String refsFilePath = ObjectPersistenceManager.buildNodeReferencesFilePath(id);
        try {
            if (!this.itemStateFS.isFile(refsFilePath)) {
                throw new NoSuchItemStateException(id.toString());
            }
        }
        catch (FileSystemException fse) {
            String msg = "failed to load references: " + id;
            log.debug(msg);
            throw new ItemStateException(msg, fse);
        }
        BufferedInputStream in = new BufferedInputStream(this.itemStateFS.getInputStream(refsFilePath));
        try {
            NodeReferences refs = new NodeReferences(id);
            Serializer.deserialize(refs, (InputStream)in);
            nodeReferences = refs;
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (Exception e) {
                String msg = "failed to load references: " + id;
                log.debug(msg);
                throw new ItemStateException(msg, e);
            }
        }
        in.close();
        return nodeReferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void store(NodeState state) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        String nodeFilePath = ObjectPersistenceManager.buildNodeFilePath(state.getNodeId());
        FileSystemResource nodeFile = new FileSystemResource(this.itemStateFS, nodeFilePath);
        try {
            nodeFile.makeParentDirs();
            BufferedOutputStream out = new BufferedOutputStream(nodeFile.getOutputStream());
            try {
                Serializer.serialize(state, (OutputStream)out);
            }
            finally {
                out.close();
            }
        }
        catch (Exception e) {
            String msg = "failed to write node state: " + state.getNodeId();
            log.debug(msg);
            throw new ItemStateException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void store(PropertyState state) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        String propFilePath = ObjectPersistenceManager.buildPropFilePath(state.getPropertyId());
        FileSystemResource propFile = new FileSystemResource(this.itemStateFS, propFilePath);
        try {
            propFile.makeParentDirs();
            BufferedOutputStream out = new BufferedOutputStream(propFile.getOutputStream());
            try {
                Serializer.serialize(state, out, this.blobStore);
            }
            finally {
                out.close();
            }
        }
        catch (Exception e) {
            String msg = "failed to store property state: " + state.getParentId() + "/" + state.getName();
            log.debug(msg);
            throw new ItemStateException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void store(NodeReferences refs) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        String refsFilePath = ObjectPersistenceManager.buildNodeReferencesFilePath(refs.getTargetId());
        FileSystemResource refsFile = new FileSystemResource(this.itemStateFS, refsFilePath);
        try {
            refsFile.makeParentDirs();
            BufferedOutputStream out = new BufferedOutputStream(refsFile.getOutputStream());
            try {
                Serializer.serialize(refs, (OutputStream)out);
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        catch (Exception e) {
            String msg = "failed to store " + refs;
            log.debug(msg);
            throw new ItemStateException(msg, e);
        }
    }

    @Override
    protected void destroy(NodeState state) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        String nodeFilePath = ObjectPersistenceManager.buildNodeFilePath(state.getNodeId());
        FileSystemResource nodeFile = new FileSystemResource(this.itemStateFS, nodeFilePath);
        try {
            if (nodeFile.exists()) {
                nodeFile.delete(true);
            }
        }
        catch (FileSystemException fse) {
            String msg = "failed to delete node state: " + state.getNodeId();
            log.debug(msg);
            throw new ItemStateException(msg, fse);
        }
    }

    @Override
    protected void destroy(PropertyState state) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        InternalValue[] values = state.getValues();
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                InternalValue val = values[i];
                if (val == null) continue;
                val.deleteBinaryResource();
            }
        }
        String propFilePath = ObjectPersistenceManager.buildPropFilePath(state.getPropertyId());
        FileSystemResource propFile = new FileSystemResource(this.itemStateFS, propFilePath);
        try {
            if (propFile.exists()) {
                propFile.delete(true);
            }
        }
        catch (FileSystemException fse) {
            String msg = "failed to delete property state: " + state.getParentId() + "/" + state.getName();
            log.debug(msg);
            throw new ItemStateException(msg, fse);
        }
    }

    @Override
    protected void destroy(NodeReferences refs) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        String refsFilePath = ObjectPersistenceManager.buildNodeReferencesFilePath(refs.getTargetId());
        FileSystemResource refsFile = new FileSystemResource(this.itemStateFS, refsFilePath);
        try {
            if (refsFile.exists()) {
                refsFile.delete(true);
            }
        }
        catch (FileSystemException fse) {
            String msg = "failed to delete " + refs;
            log.debug(msg);
            throw new ItemStateException(msg, fse);
        }
    }

    @Override
    public synchronized boolean exists(PropertyId id) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        try {
            String propFilePath = ObjectPersistenceManager.buildPropFilePath(id);
            FileSystemResource propFile = new FileSystemResource(this.itemStateFS, propFilePath);
            return propFile.exists();
        }
        catch (FileSystemException fse) {
            String msg = "failed to check existence of item state: " + id;
            log.debug(msg);
            throw new ItemStateException(msg, fse);
        }
    }

    @Override
    public synchronized boolean exists(NodeId id) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        try {
            String nodeFilePath = ObjectPersistenceManager.buildNodeFilePath(id);
            FileSystemResource nodeFile = new FileSystemResource(this.itemStateFS, nodeFilePath);
            return nodeFile.exists();
        }
        catch (FileSystemException fse) {
            String msg = "failed to check existence of item state: " + id;
            log.error(msg, (Throwable)fse);
            throw new ItemStateException(msg, fse);
        }
    }

    @Override
    public synchronized boolean existsReferencesTo(NodeId id) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        try {
            String refsFilePath = ObjectPersistenceManager.buildNodeReferencesFilePath(id);
            FileSystemResource refsFile = new FileSystemResource(this.itemStateFS, refsFilePath);
            return refsFile.exists();
        }
        catch (FileSystemException fse) {
            String msg = "failed to check existence of references: " + id;
            log.debug(msg);
            throw new ItemStateException(msg, fse);
        }
    }
}

