/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.maintenance.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import javax.management.DynamicMBean;
import org.apache.jackrabbit.oak.commons.jmx.AnnotatedStandardMBean;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.jcr.maintenance.VersionCleanupConfig;
import org.apache.sling.jcr.maintenance.internal.VersionCleanupMBean;
import org.apache.sling.jcr.maintenance.internal.VersionCleanupPath;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={VersionCleanupMBean.class, Runnable.class, DynamicMBean.class}, property={"jmx.objectname=org.apache.sling.jcr.maintenance:type=VersionCleanup", "scheduler.concurrent:Boolean=false"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true)
@Designate(ocd=VersionCleanupConfig.class)
public class VersionCleanup
extends AnnotatedStandardMBean
implements Runnable,
VersionCleanupMBean {
    private static final Logger log = LoggerFactory.getLogger(VersionCleanup.class);
    private Thread cleanupThread;
    private final ResourceResolverFactory factory;
    private long lastCleanedVersions;
    private String lastFailureMessage;
    private final List<VersionCleanupPath> versionCleanupConfigs;

    @Activate
    public VersionCleanup(@Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policyOption=ReferencePolicyOption.GREEDY) List<VersionCleanupPath> versionCleanupConfigs, @Reference ResourceResolverFactory factory) {
        super(VersionCleanupMBean.class);
        this.factory = factory;
        this.versionCleanupConfigs = versionCleanupConfigs;
        versionCleanupConfigs.sort((c1, c2) -> c1.getPath().compareTo(c2.getPath()) * -1);
    }

    private String getPath(Session session, VersionHistory versionHistory) throws RepositoryException {
        String identifier = versionHistory.getVersionableIdentifier();
        try {
            Node versionableNode = session.getNodeByIdentifier(identifier);
            return versionableNode.getPath();
        }
        catch (ItemNotFoundException infe) {
            log.debug("Unable to get versionable node by ID: {}, exception: {}", (Object)identifier, (Object)infe.getMessage());
            return versionHistory.getProperty(session.getWorkspace().getName()).getString();
        }
    }

    private void cleanupVersions(Session session, Resource history) {
        try {
            VersionHistory versionHistory = (VersionHistory)session.getItem(history.getPath());
            String path = this.getPath(session, versionHistory);
            VersionCleanupPath config = VersionCleanupPath.getMatchingConfiguration(this.versionCleanupConfigs, path);
            int limit = config.getLimit();
            if (!this.isMatchingVersion(session, path, versionHistory) && !config.isKeepVersions() && limit > 0) {
                log.debug("Deleted, removing all but last version");
                limit = 1;
            }
            log.debug("Cleaning up versions for: {}", (Object)versionHistory.getPath());
            VersionIterator versionIterator = versionHistory.getAllVersions();
            ArrayList<String> versionNames = new ArrayList<String>();
            while (versionIterator.hasNext()) {
                Version version = versionIterator.nextVersion();
                if (version.getName().equals("jcr:rootVersion")) continue;
                versionNames.add(version.getName());
            }
            if (versionNames.size() > limit) {
                List toCleanup = versionNames.subList(0, versionNames.size() - limit);
                log.info("Cleaning up {} versions from {} at: {}", new Object[]{toCleanup.size(), path, versionHistory.getPath()});
                for (String item : toCleanup) {
                    versionHistory.removeVersion(item);
                    log.trace("Cleaned up: {}", (Object)item);
                    ++this.lastCleanedVersions;
                }
            }
        }
        catch (RepositoryException re) {
            log.warn("Failed to cleanup version history for: {}", (Object)history.getPath(), (Object)re);
        }
    }

    private boolean findVersions(Session session, Resource resource) throws RepositoryException {
        if (Thread.interrupted()) {
            return true;
        }
        log.debug("Finding versions under: {}", (Object)resource.getPath());
        if ("nt:versionHistory".equals(resource.getResourceType())) {
            resource.getResourceResolver().refresh();
            this.cleanupVersions(session, resource);
        } else {
            for (Resource child : resource.getChildren()) {
                if (!this.findVersions(session, child)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isMatchingVersion(Session session, String path, VersionHistory versionHistory) throws RepositoryException {
        try {
            VersionManager versionManager = session.getWorkspace().getVersionManager();
            String baseVersionPath = versionManager.getBaseVersion(path).getParent().getPath();
            String versionHistoryPath = versionHistory.getPath();
            return session.nodeExists(path) && this.isVersionable(session.getNode(path)) && baseVersionPath.equals(versionHistoryPath);
        }
        catch (PathNotFoundException pnfe) {
            log.debug("Path: {} not found: {}", (Object)path, (Object)pnfe.getMessage());
            return false;
        }
    }

    private boolean isVersionable(Node node) throws RepositoryException {
        return node != null && node.isNodeType("{http://www.jcp.org/jcr/mix/1.0}versionable");
    }

    @Override
    public void run() {
        if (this.isRunning()) {
            log.warn("Version cleanup already running!");
        } else {
            this.cleanupThread = new Thread(this::doRun);
            this.cleanupThread.setDaemon(true);
            this.cleanupThread.start();
        }
    }

    private void doRun() {
        log.info("Running version cleanup");
        this.lastCleanedVersions = 0L;
        try (ResourceResolver adminResolver = this.factory.getServiceResourceResolver(Collections.singletonMap("sling.service.subservice", "sling-versionmgr"));){
            Resource versionRoot = adminResolver.getResource("/jcr:system/jcr:versionStorage");
            Session session = Optional.ofNullable((Session)versionRoot.getResourceResolver().adaptTo(Session.class)).orElseThrow(() -> new RepositoryException("Failed to get session"));
            for (Resource folder : versionRoot.getChildren()) {
                log.info("Traversing and cleaning: {}", (Object)folder.getPath());
                if (!this.findVersions(session, folder)) continue;
                break;
            }
            this.lastFailureMessage = null;
        }
        catch (LoginException le) {
            log.error("Failed to run version cleanup, cannot get service user", (Throwable)le);
            this.lastFailureMessage = "Failed to run version cleanup, cannot get service user";
        }
        catch (RepositoryException re) {
            log.error("Failed to run version cleanup", (Throwable)re);
            this.lastFailureMessage = "Failed to run version cleanup";
        }
    }

    @Override
    public boolean isRunning() {
        return this.cleanupThread != null && this.cleanupThread.isAlive();
    }

    @Override
    public boolean isFailed() {
        return this.lastFailureMessage != null;
    }

    @Override
    public String getLastMessage() {
        return this.lastFailureMessage;
    }

    @Override
    public long getLastCleanedVersionsCount() {
        return this.lastCleanedVersions;
    }

    @Override
    public void start() {
        this.run();
    }

    @Override
    public void stop() {
        Optional.ofNullable(this.cleanupThread).ifPresent(Thread::interrupt);
    }
}

