/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.rewriter.impl;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.rewriter.ProcessingComponentConfiguration;

public class ProcessingComponentConfigurationImpl
implements ProcessingComponentConfiguration {
    public static final ValueMap EMPTY_CONFIG = new ValueMapDecorator(new HashMap());
    public static final ProcessingComponentConfiguration EMPTY = new ProcessingComponentConfigurationImpl("<empty>", null);
    private final String type;
    private final ValueMap configuration;
    private final String descText;

    public ProcessingComponentConfigurationImpl(String type, ValueMap config) {
        this.type = type;
        this.configuration = config == null ? EMPTY_CONFIG : new ValueMapDecorator(new HashMap(config));
        this.configuration.remove((Object)"jcr:primaryType");
        this.descText = "Config(type=".concat(this.type).concat(", config=").concat(this.getConfigurationString()).concat(")");
    }

    @Override
    public ValueMap getConfiguration() {
        return this.configuration;
    }

    @Override
    public String getType() {
        return this.type;
    }

    private String getConfigurationString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (Map.Entry entry : this.configuration.entrySet()) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append((String)entry.getKey());
            sb.append('=');
            if (entry.getValue().getClass().isArray()) {
                sb.append(Arrays.toString((Object[])entry.getValue()));
                continue;
            }
            sb.append(entry.getValue());
        }
        sb.append('}');
        return sb.toString();
    }

    public String toString() {
        return this.descText;
    }

    void printConfiguration(PrintWriter pw) {
        pw.print(this.type);
        if (!this.configuration.isEmpty()) {
            pw.print(" : ");
            pw.print(this.getConfigurationString());
        }
        pw.println();
    }
}

