/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.privilege;

import java.util.Objects;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.TreeLocation;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeConstants;
import org.apache.jackrabbit.util.Text;
import org.jetbrains.annotations.NotNull;

final class PrivilegeContext
implements Context,
PrivilegeConstants {
    private static final Context INSTANCE = new PrivilegeContext();

    private PrivilegeContext() {
    }

    static Context getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean definesProperty(@NotNull Tree parent, @NotNull PropertyState property) {
        return PRIVILEGE_PROPERTY_NAMES.contains(property.getName()) && this.definesTree(parent);
    }

    @Override
    public boolean definesContextRoot(@NotNull Tree tree) {
        return "rep:privileges".equals(tree.getName()) && "rep:Privileges".equals(TreeUtil.getPrimaryTypeName(tree));
    }

    @Override
    public boolean definesTree(@NotNull Tree tree) {
        return Objects.nonNull(TreeUtil.getPrimaryTypeName(tree)) && PRIVILEGE_NODETYPE_NAMES.contains(TreeUtil.getPrimaryTypeName(tree));
    }

    @Override
    public boolean definesLocation(@NotNull TreeLocation location) {
        return Text.isDescendantOrEqual("/jcr:system/rep:privileges", location.getPath());
    }

    @Override
    public boolean definesInternal(@NotNull Tree tree) {
        return false;
    }
}

