/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver.ui;

import java.io.Serializable;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.hive.thriftserver.ui.HiveThriftServer2AppStatusStore;
import org.apache.spark.sql.hive.thriftserver.ui.SessionStatsPagedTable;
import org.apache.spark.sql.hive.thriftserver.ui.SqlStatsPagedTable;
import org.apache.spark.sql.hive.thriftserver.ui.ThriftServerTab;
import org.apache.spark.ui.SparkUITab;
import org.apache.spark.ui.UIUtils$;
import org.apache.spark.ui.WebUIPage;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0001-4Qa\u0003\u0007\u0001\u0019iA\u0001B\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\u0006Y\u0001!\t!\f\u0005\ba\u0001\u0011\r\u0011\"\u00032\u0011\u0019)\u0004\u0001)A\u0005e!9a\u0007\u0001b\u0001\n\u00139\u0004B\u0002!\u0001A\u0003%\u0001\bC\u0003B\u0001\u0011\u0005!\tC\u0003d\u0001\u0011%A\rC\u0003f\u0001\u0011%a\rC\u0003i\u0001\u0011%\u0011N\u0001\tUQJLg\r^*feZ,'\u000fU1hK*\u0011QBD\u0001\u0003k&T!a\u0004\t\u0002\u0019QD'/\u001b4ug\u0016\u0014h/\u001a:\u000b\u0005E\u0011\u0012\u0001\u00025jm\u0016T!a\u0005\u000b\u0002\u0007M\fHN\u0003\u0002\u0016-\u0005)1\u000f]1sW*\u0011q\u0003G\u0001\u0007CB\f7\r[3\u000b\u0003e\t1a\u001c:h'\r\u00011\u0004\t\t\u00039yi\u0011!\b\u0006\u0003\u001bQI!aH\u000f\u0003\u0013]+'-V%QC\u001e,\u0007CA\u0011%\u001b\u0005\u0011#BA\u0012\u0015\u0003!Ig\u000e^3s]\u0006d\u0017BA\u0013#\u0005\u001daunZ4j]\u001e\fa\u0001]1sK:$8\u0001\u0001\t\u0003S)j\u0011\u0001D\u0005\u0003W1\u0011q\u0002\u00165sS\u001a$8+\u001a:wKJ$\u0016MY\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00059z\u0003CA\u0015\u0001\u0011\u00151#\u00011\u0001)\u0003\u0015\u0019Ho\u001c:f+\u0005\u0011\u0004CA\u00154\u0013\t!DBA\u0010ISZ,G\u000b\u001b:jMR\u001cVM\u001d<feJ\n\u0005\u000f]*uCR,8o\u0015;pe\u0016\faa\u001d;pe\u0016\u0004\u0013!C:uCJ$H+[7f+\u0005A\u0004CA\u001d?\u001b\u0005Q$BA\u001e=\u0003\u0011)H/\u001b7\u000b\u0003u\nAA[1wC&\u0011qH\u000f\u0002\u0005\t\u0006$X-\u0001\u0006ti\u0006\u0014H\u000fV5nK\u0002\naA]3oI\u0016\u0014HCA\"X!\r!e*\u0015\b\u0003\u000b.s!AR%\u000e\u0003\u001dS!\u0001S\u0014\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0015!B:dC2\f\u0017B\u0001'N\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011AS\u0005\u0003\u001fB\u00131aU3r\u0015\taU\n\u0005\u0002S+6\t1K\u0003\u0002U\u001b\u0006\u0019\u00010\u001c7\n\u0005Y\u001b&\u0001\u0002(pI\u0016DQ\u0001W\u0004A\u0002e\u000bqA]3rk\u0016\u001cH\u000f\u0005\u0002[C6\t1L\u0003\u0002];\u0006!\u0001\u000e\u001e;q\u0015\tqv,A\u0004tKJ4H.\u001a;\u000b\u0003\u0001\fQA[1wCbL!AY.\u0003%!#H\u000f]*feZdW\r\u001e*fcV,7\u000f^\u0001\u0013O\u0016tWM]1uK\n\u000b7/[2Ti\u0006$8\u000fF\u0001D\u0003U9WM\\3sCR,7+\u0015'Ti\u0006$8\u000fV1cY\u0016$\"aQ4\t\u000baK\u0001\u0019A-\u00023\u001d,g.\u001a:bi\u0016\u001cVm]:j_:\u001cF/\u0019;t)\u0006\u0014G.\u001a\u000b\u0003\u0007*DQ\u0001\u0017\u0006A\u0002e\u0003")
public class ThriftServerPage
extends WebUIPage
implements Logging {
    private final ThriftServerTab parent;
    private final HiveThriftServer2AppStatusStore store;
    private final Date startTime;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private HiveThriftServer2AppStatusStore store() {
        return this.store;
    }

    private Date startTime() {
        return this.startTime;
    }

    public Seq<Node> render(HttpServletRequest request) {
        Seq seq;
        HiveThriftServer2AppStatusStore hiveThriftServer2AppStatusStore = this.store();
        synchronized (hiveThriftServer2AppStatusStore) {
            TraversableLike traversableLike = (TraversableLike)this.generateBasicStats().$plus$plus((GenTraversableOnce)new Elem(null, "br", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])), Seq$.MODULE$.canBuildFrom());
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n          "));
            $buf.$amp$plus((Object)BoxesRunTime.boxToInteger((int)this.store().getOnlineSessionNum()));
            $buf.$amp$plus((Object)new Text("\n          session(s) are online,\n          running\n          "));
            $buf.$amp$plus((Object)BoxesRunTime.boxToInteger((int)this.store().getTotalRunning()));
            $buf.$amp$plus((Object)new Text("\n          SQL statement(s)\n        "));
            seq = (Seq)((TraversableLike)((TraversableLike)traversableLike.$plus$plus((GenTraversableOnce)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf), Seq$.MODULE$.canBuildFrom())).$plus$plus(this.generateSessionStatsTable(request), Seq$.MODULE$.canBuildFrom())).$plus$plus(this.generateSQLStatsTable(request), Seq$.MODULE$.canBuildFrom());
        }
        Seq content = seq;
        return UIUtils$.MODULE$.headerSparkPage(request, "JDBC/ODBC Server", (Function0 & Serializable & scala.Serializable)() -> content, (SparkUITab)this.parent, UIUtils$.MODULE$.headerSparkPage$default$5(), UIUtils$.MODULE$.headerSparkPage$default$6(), UIUtils$.MODULE$.headerSparkPage$default$7());
    }

    private Seq<Node> generateBasicStats() {
        long timeSinceStart = System.currentTimeMillis() - this.startTime().getTime();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("list-unstyled"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("Started at: "));
        $buf2.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text(" "));
        $buf2.$amp$plus((Object)UIUtils$.MODULE$.formatDate(this.startTime()));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("Time since start: "));
        $buf4.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf4.$amp$plus((Object)UIUtils$.MODULE$.formatDurationVerbose(timeSinceStart));
        $buf4.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "ul", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
    }

    private Seq<Node> generateSQLStatsTable(HttpServletRequest request) {
        None$ none$;
        int numStatement = this.store().getExecutionList().size();
        if (numStatement > 0) {
            String sqlTableTag = "sqlstat";
            int sqlTablePage = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)request.getParameter(new StringBuilder(5).append(sqlTableTag).append(".page").toString())).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)ThriftServerPage.$anonfun$generateSQLStatsTable$1(x$1))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1));
            try {
                none$ = new Some(new SqlStatsPagedTable(request, this.parent, this.store().getExecutionList(), "sqlserver", UIUtils$.MODULE$.prependBaseUri(request, this.parent.basePath(), UIUtils$.MODULE$.prependBaseUri$default$3()), sqlTableTag).table(sqlTablePage));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof IllegalArgumentException ? true : throwable2 instanceof IndexOutOfBoundsException) {
                    Null$ $md = Null$.MODULE$;
                    $md = new UnprefixedAttribute("class", (Seq)new Text("alert alert-error"), (MetaData)$md);
                    NodeBuffer $buf = new NodeBuffer();
                    $buf.$amp$plus((Object)new Text("\n            "));
                    NodeBuffer $buf2 = new NodeBuffer();
                    $buf2.$amp$plus((Object)new Text("Error while rendering job table:"));
                    $buf.$amp$plus((Object)new Elem(null, "p", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
                    $buf.$amp$plus((Object)new Text("\n            "));
                    NodeBuffer $buf3 = new NodeBuffer();
                    $buf3.$amp$plus((Object)new Text("\n              "));
                    $buf3.$amp$plus((Object)Utils$.MODULE$.exceptionString(throwable2));
                    $buf3.$amp$plus((Object)new Text("\n            "));
                    $buf.$amp$plus((Object)new Elem(null, "pre", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
                    $buf.$amp$plus((Object)new Text("\n          "));
                    Some some = new Some((Object)new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf));
                    none$ = some;
                }
                throw throwable;
            }
        } else {
            none$ = None$.MODULE$;
        }
        None$ table = none$;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-sqlstat',\n                'aggregated-sqlstat')"), (MetaData)$md);
        $md = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-sqlstat collapse-table"), (MetaData)$md);
        $md = new UnprefixedAttribute("id", (Seq)new Text("sqlstat"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n          "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md2);
        $buf4.$amp$plus((Object)new Elem(null, "span", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf4.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("SQL Statistics ("));
        $buf5.$amp$plus((Object)BoxesRunTime.boxToInteger((int)numStatement));
        $buf5.$amp$plus((Object)new Text(")"));
        $buf4.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf.$amp$plus((Object)new Text("\n      "));
        Elem elem = new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-sqlstat collapsible-table"), (MetaData)$md3);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n          "));
        $buf6.$amp$plus(table.getOrElse((Function0 & Serializable & scala.Serializable)() -> "No statistics have been generated yet."));
        $buf6.$amp$plus((Object)new Text("\n        "));
        NodeSeq content = (NodeSeq)elem.$plus$plus((GenTraversableOnce)new Elem(null, "div", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6), NodeSeq$.MODULE$.canBuildFrom());
        return content;
    }

    private Seq<Node> generateSessionStatsTable(HttpServletRequest request) {
        None$ none$;
        int numSessions = this.store().getSessionList().size();
        if (numSessions > 0) {
            String sessionTableTag = "sessionstat";
            int sessionTablePage = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)request.getParameter(new StringBuilder(5).append(sessionTableTag).append(".page").toString())).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)ThriftServerPage.$anonfun$generateSessionStatsTable$1(x$2))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1));
            try {
                none$ = new Some(new SessionStatsPagedTable(request, this.parent, this.store().getSessionList(), "sqlserver", UIUtils$.MODULE$.prependBaseUri(request, this.parent.basePath(), UIUtils$.MODULE$.prependBaseUri$default$3()), sessionTableTag).table(sessionTablePage));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof IllegalArgumentException ? true : throwable2 instanceof IndexOutOfBoundsException) {
                    Null$ $md = Null$.MODULE$;
                    $md = new UnprefixedAttribute("class", (Seq)new Text("alert alert-error"), (MetaData)$md);
                    NodeBuffer $buf = new NodeBuffer();
                    $buf.$amp$plus((Object)new Text("\n            "));
                    NodeBuffer $buf2 = new NodeBuffer();
                    $buf2.$amp$plus((Object)new Text("Error while rendering job table:"));
                    $buf.$amp$plus((Object)new Elem(null, "p", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
                    $buf.$amp$plus((Object)new Text("\n            "));
                    NodeBuffer $buf3 = new NodeBuffer();
                    $buf3.$amp$plus((Object)new Text("\n              "));
                    $buf3.$amp$plus((Object)Utils$.MODULE$.exceptionString(throwable2));
                    $buf3.$amp$plus((Object)new Text("\n            "));
                    $buf.$amp$plus((Object)new Elem(null, "pre", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
                    $buf.$amp$plus((Object)new Text("\n          "));
                    Some some = new Some((Object)new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf));
                    none$ = some;
                }
                throw throwable;
            }
        } else {
            none$ = None$.MODULE$;
        }
        None$ table = none$;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-sessionstat',\n                'aggregated-sessionstat')"), (MetaData)$md);
        $md = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-sessionstat collapse-table"), (MetaData)$md);
        $md = new UnprefixedAttribute("id", (Seq)new Text("sessionstat"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n        "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md2);
        $buf4.$amp$plus((Object)new Elem(null, "span", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf4.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("Session Statistics ("));
        $buf5.$amp$plus((Object)BoxesRunTime.boxToInteger((int)numSessions));
        $buf5.$amp$plus((Object)new Text(")"));
        $buf4.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf4.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf.$amp$plus((Object)new Text("\n    "));
        Elem elem = new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-sessionstat collapsible-table"), (MetaData)$md3);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n        "));
        $buf6.$amp$plus(table.getOrElse((Function0 & Serializable & scala.Serializable)() -> "No statistics have been generated yet."));
        $buf6.$amp$plus((Object)new Text("\n      "));
        NodeSeq content = (NodeSeq)elem.$plus$plus((GenTraversableOnce)new Elem(null, "div", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6), NodeSeq$.MODULE$.canBuildFrom());
        return content;
    }

    public static final /* synthetic */ int $anonfun$generateSQLStatsTable$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
    }

    public static final /* synthetic */ int $anonfun$generateSessionStatsTable$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toInt();
    }

    public ThriftServerPage(ThriftServerTab parent) {
        this.parent = parent;
        super("");
        Logging.$init$((Logging)this);
        this.store = parent.store();
        this.startTime = parent.startTime();
    }
}

