/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.mllib.FPGrowthExample;
import org.apache.spark.examples.mllib.FPGrowthExample$;
import org.apache.spark.examples.mllib.FPGrowthExample$Params$;
import org.apache.spark.mllib.fpm.FPGrowth;
import org.apache.spark.mllib.fpm.FPGrowthModel;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;
import scopt.OptionParser;
import scopt.Read$;

public final class FPGrowthExample$ {
    public static FPGrowthExample$ MODULE$;

    static {
        new FPGrowthExample$();
    }

    public void main(String[] args) {
        FPGrowthExample.Params defaultParams = new FPGrowthExample.Params(FPGrowthExample$Params$.MODULE$.apply$default$1(), FPGrowthExample$Params$.MODULE$.apply$default$2(), FPGrowthExample$Params$.MODULE$.apply$default$3());
        OptionParser<FPGrowthExample.Params> parser = new OptionParser<FPGrowthExample.Params>(defaultParams){

            public static final /* synthetic */ FPGrowthExample.Params $anonfun$new$1(double x, FPGrowthExample.Params c) {
                double x$1 = x;
                String x$2 = c.copy$default$1();
                int x$3 = c.copy$default$3();
                return c.copy(x$2, x$1, x$3);
            }

            public static final /* synthetic */ FPGrowthExample.Params $anonfun$new$2(int x, FPGrowthExample.Params c) {
                int x$4 = x;
                String x$5 = c.copy$default$1();
                double x$6 = c.copy$default$2();
                return c.copy(x$5, x$6, x$4);
            }
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FPGrowth: an example FP-growth app."}));
                this.opt("minSupport", Read$.MODULE$.doubleRead()).text(new StringBuilder(32).append("minimal support level, default: ").append(defaultParams$1.minSupport()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$1(BoxesRunTime.unboxToDouble((Object)x), c));
                this.opt("numPartition", Read$.MODULE$.intRead()).text(new StringBuilder(30).append("number of partition, default: ").append(defaultParams$1.numPartition()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$2(BoxesRunTime.unboxToInt((Object)x), c));
                this.arg("<input>", Read$.MODULE$.stringRead()).text("input paths to input data set, whose file format is that each line contains a transaction with each item in String and separated by a space").required().action((Function2 & Serializable & scala.Serializable)(x, c) -> c.copy((String)x, c.copy$default$2(), c.copy$default$3()));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1$adapted(java.lang.Object org.apache.spark.examples.mllib.FPGrowthExample$Params ), $anonfun$new$2$adapted(java.lang.Object org.apache.spark.examples.mllib.FPGrowthExample$Params ), $anonfun$new$3(java.lang.String org.apache.spark.examples.mllib.FPGrowthExample$Params )}, serializedLambda);
            }
        };
        Option option = parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams);
        if (option instanceof Some) {
            Some some = (Some)option;
            FPGrowthExample.Params params = (FPGrowthExample.Params)some.value();
            this.run(params);
            return;
        }
        throw package$.MODULE$.exit(1);
    }

    public void run(FPGrowthExample.Params params) {
        SparkConf conf = new SparkConf().setAppName(new StringBuilder(21).append("FPGrowthExample with ").append(params).toString());
        SparkContext sc = new SparkContext(conf);
        RDD transactions = sc.textFile(params.input(), sc.textFile$default$2()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.split(" "), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))).cache();
        Predef$.MODULE$.println((Object)new StringBuilder(24).append("Number of transactions: ").append(transactions.count()).toString());
        FPGrowthModel model = new FPGrowth().setMinSupport(params.minSupport()).setNumPartitions(params.numPartition()).run(transactions, ClassTag$.MODULE$.apply(String.class));
        Predef$.MODULE$.println((Object)new StringBuilder(29).append("Number of frequent itemsets: ").append(model.freqItemsets().count()).toString());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.freqItemsets().collect())).foreach((Function1 & Serializable & scala.Serializable)itemset -> {
            Predef$.MODULE$.println((Object)new StringBuilder(2).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])itemset.items())).mkString("[", ",", "]")).append(", ").append(itemset.freq()).toString());
            return BoxedUnit.UNIT;
        });
        sc.stop();
    }

    private FPGrowthExample$() {
        MODULE$ = this;
    }
}

