/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pipelines.graph;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.pipelines.graph.DataflowGraph;
import org.apache.spark.sql.pipelines.graph.DataflowGraphTransformer$;
import org.apache.spark.sql.pipelines.graph.Flow;
import org.apache.spark.sql.pipelines.graph.GraphElement;
import org.apache.spark.sql.pipelines.graph.ResolutionCompletedFlow;
import org.apache.spark.sql.pipelines.graph.ResolutionFailedFlow;
import org.apache.spark.sql.pipelines.graph.ResolvedFlow;
import org.apache.spark.sql.pipelines.graph.Sink;
import org.apache.spark.sql.pipelines.graph.Table;
import org.apache.spark.sql.pipelines.graph.View;
import org.apache.spark.util.ThreadUtils$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NoStackTrace;
import scala.util.hashing.MurmurHash3$;

@ScalaSignature(bytes="\u0006\u0005\r]g\u0001B4i\u0001UD\u0011\"\u001b\u0001\u0003\u0002\u0003\u0006I!a\u0001\t\u000f\u0005-\u0001\u0001\"\u0001\u0002\u000e!I\u00111\u0003\u0001A\u0002\u0013%\u0011Q\u0003\u0005\n\u0003s\u0001\u0001\u0019!C\u0005\u0003wA\u0001\"!\u0013\u0001A\u0003&\u0011q\u0003\u0005\n\u0003\u0017\u0002\u0001\u0019!C\u0005\u0003\u001bB\u0011\"a\u001b\u0001\u0001\u0004%I!!\u001c\t\u0011\u0005E\u0004\u0001)Q\u0005\u0003\u001fB\u0011\"a\u001d\u0001\u0001\u0004%I!!\u001e\t\u0013\u0005}\u0004\u00011A\u0005\n\u0005\u0005\u0005\u0002CAC\u0001\u0001\u0006K!a\u001e\t\u0013\u0005\u001d\u0005\u00011A\u0005\n\u0005%\u0005\"CAG\u0001\u0001\u0007I\u0011BAH\u0011!\t\u0019\n\u0001Q!\n\u0005-\u0005\"CAK\u0001\u0001\u0007I\u0011BAL\u0011%\t\t\u000b\u0001a\u0001\n\u0013\t\u0019\u000b\u0003\u0005\u0002(\u0002\u0001\u000b\u0015BAM\u0011%\tI\u000b\u0001a\u0001\n\u0013\tY\u000bC\u0005\u00020\u0002\u0001\r\u0011\"\u0003\u00022\"A\u0011Q\u0017\u0001!B\u0013\ti\u000bC\u0005\u00028\u0002\u0001\r\u0011\"\u0003\u0002:\"I\u00111\u0019\u0001A\u0002\u0013%\u0011Q\u0019\u0005\t\u0003\u0013\u0004\u0001\u0015)\u0003\u0002<\"I\u00111\u001a\u0001A\u0002\u0013%\u0011Q\u001a\u0005\n\u0003#\u0004\u0001\u0019!C\u0005\u0003'D\u0001\"a6\u0001A\u0003&\u0011q\u001a\u0005\n\u00033\u0004\u0001\u0019!C\u0005\u00037D\u0011\"!:\u0001\u0001\u0004%I!a:\t\u0011\u0005-\b\u0001)Q\u0005\u0003;D\u0011\"!<\u0001\u0001\u0004%I!!\u0006\t\u0013\u0005=\b\u00011A\u0005\n\u0005E\b\u0002CA{\u0001\u0001\u0006K!a\u0006\t\u0013\u0005]\b\u00011A\u0005\n\u0005e\u0006\"CA}\u0001\u0001\u0007I\u0011BA~\u0011!\ty\u0010\u0001Q!\n\u0005m\u0006\"\u0003B\u0001\u0001\t\u0007I\u0011\u0002B\u0002\u0011!\u0011Y\u0001\u0001Q\u0001\n\t\u0015\u0001\"\u0003B\u0007\u0001\u0001\u0007I\u0011\u0002B\b\u0011%\u00119\u0002\u0001a\u0001\n\u0013\u0011I\u0002\u0003\u0005\u0003\u001e\u0001\u0001\u000b\u0015\u0002B\t\u0011)\u0011y\u0002\u0001EC\u0002\u0013%!\u0011\u0005\u0005\n\u0005g\u0001!\u0019!C\u0005\u0005kA\u0001B!\u0010\u0001A\u0003%!q\u0007\u0005\b\u0005\u007f\u0001A\u0011\u0002B!\u0011\u001d\u0011\u0019\u0005\u0001C\u0005\u0005\u000bBqAa\u0012\u0001\t\u0013\u0011I\u0005C\u0004\u0003L\u0001!IA!\u0014\t\u000f\t=\u0003\u0001\"\u0001\u0003R!9!Q\f\u0001\u0005\n\t}\u0003b\u0002B4\u0001\u0011\u0005!\u0011\u000e\u0005\n\u0005\u007f\u0002\u0011\u0013!C\u0001\u0005\u0003CqAa&\u0001\t\u0003\u0011I\nC\u0004\u0003\u001c\u0002!\tE!(\b\u000f\t}\u0005\u000e#\u0001\u0003\"\u001a1q\r\u001bE\u0001\u0005GCq!a\u00038\t\u0003\u0011YK\u0002\u0004\u0003.^\u0002%q\u0016\u0005\u000b\u0005#L$Q3A\u0005\u0002\tM\u0007B\u0003Bks\tE\t\u0015!\u0003\u0002`!Q!q[\u001d\u0003\u0016\u0004%\tA!7\t\u0015\t\u0005\u0018H!E!\u0002\u0013\u0011Y\u000eC\u0004\u0002\fe\"\tAa9\t\u0013\t5\u0018(!A\u0005\u0002\t=\b\"\u0003B{sE\u0005I\u0011\u0001B|\u0011%\u0011Y0OI\u0001\n\u0003\u0011i\u0010C\u0005\u0004\u0002e\n\t\u0011\"\u0011\u0004\u0004!I11B\u001d\u0002\u0002\u0013\u0005!1\u0001\u0005\n\u0007\u001bI\u0014\u0011!C\u0001\u0007\u001fA\u0011b!\u0007:\u0003\u0003%\tea\u0007\t\u0013\r%\u0012(!A\u0005\u0002\r-\u0002\"CB\u0018s\u0005\u0005I\u0011IB\u0019\u0011%\u0019)$OA\u0001\n\u0003\u001a9\u0004C\u0005\u0004:e\n\t\u0011\"\u0011\u0004<\u001dI1qH\u001c\u0002\u0002#\u00051\u0011\t\u0004\n\u0005[;\u0014\u0011!E\u0001\u0007\u0007Bq!a\u0003L\t\u0003\u0019Y\u0006C\u0005\u0004^-\u000b\t\u0011\"\u0012\u0004`!I1\u0011M&\u0002\u0002\u0013\u000551\r\u0005\n\u0007SZ\u0015\u0011!CA\u0007WB\u0011b! L\u0003\u0003%Iaa \u0007\r\r\u0005u\u0007QBB\u0011)\u00119.\u0015BK\u0002\u0013\u0005!\u0011\u001c\u0005\u000b\u0005C\f&\u0011#Q\u0001\n\tm\u0007bBA\u0006#\u0012\u00051Q\u0011\u0005\n\u0005[\f\u0016\u0011!C\u0001\u0007\u0017C\u0011B!>R#\u0003%\tA!@\t\u0013\r\u0005\u0011+!A\u0005B\r\r\u0001\"CB\u0006#\u0006\u0005I\u0011\u0001B\u0002\u0011%\u0019i!UA\u0001\n\u0003\u0019y\tC\u0005\u0004\u001aE\u000b\t\u0011\"\u0011\u0004\u001c!I1\u0011F)\u0002\u0002\u0013\u000511\u0013\u0005\n\u0007_\t\u0016\u0011!C!\u0007/C\u0011b!\u000eR\u0003\u0003%\tea\u000e\t\u0013\re\u0012+!A\u0005B\rmu!CBPo\u0005\u0005\t\u0012ABQ\r%\u0019\tiNA\u0001\u0012\u0003\u0019\u0019\u000bC\u0004\u0002\f\u0001$\taa+\t\u0013\ru\u0003-!A\u0005F\r}\u0003\"CB1A\u0006\u0005I\u0011QBW\u0011%\u0019I\u0007YA\u0001\n\u0003\u001b\t\fC\u0005\u0004~\u0001\f\t\u0011\"\u0003\u0004\u0000!91qW\u001c\u0005\u0002\re&\u0001\u0007#bi\u00064Gn\\<He\u0006\u0004\b\u000e\u0016:b]N4wN]7fe*\u0011\u0011N[\u0001\u0006OJ\f\u0007\u000f\u001b\u0006\u0003W2\f\u0011\u0002]5qK2Lg.Z:\u000b\u00055t\u0017aA:rY*\u0011q\u000e]\u0001\u0006gB\f'o\u001b\u0006\u0003cJ\fa!\u00199bG\",'\"A:\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u00011h\u0010\u0005\u0002xy6\t\u0001P\u0003\u0002zu\u0006!A.\u00198h\u0015\u0005Y\u0018\u0001\u00026bm\u0006L!! =\u0003\r=\u0013'.Z2u!\t9x0C\u0002\u0002\u0002a\u0014Q\"Q;u_\u000ecwn]3bE2,\u0007\u0003BA\u0003\u0003\u000fi\u0011\u0001[\u0005\u0004\u0003\u0013A'!\u0004#bi\u00064Gn\\<He\u0006\u0004\b.\u0001\u0004=S:LGO\u0010\u000b\u0005\u0003\u001f\t\t\u0002E\u0002\u0002\u0006\u0001Aa!\u001b\u0002A\u0002\u0005\r\u0011A\u0002;bE2,7/\u0006\u0002\u0002\u0018A1\u0011\u0011DA\u0017\u0003gqA!a\u0007\u0002(9!\u0011QDA\u0012\u001b\t\tyBC\u0002\u0002\"Q\fa\u0001\u0010:p_Rt\u0014BAA\u0013\u0003\u0015\u00198-\u00197b\u0013\u0011\tI#a\u000b\u0002\u000fA\f7m[1hK*\u0011\u0011QE\u0005\u0005\u0003_\t\tDA\u0002TKFTA!!\u000b\u0002,A!\u0011QAA\u001b\u0013\r\t9\u0004\u001b\u0002\u0006)\u0006\u0014G.Z\u0001\u000bi\u0006\u0014G.Z:`I\u0015\fH\u0003BA\u001f\u0003\u000b\u0002B!a\u0010\u0002B5\u0011\u00111F\u0005\u0005\u0003\u0007\nYC\u0001\u0003V]&$\b\"CA$\t\u0005\u0005\t\u0019AA\f\u0003\rAH%M\u0001\bi\u0006\u0014G.Z:!\u0003!!\u0018M\u00197f\u001b\u0006\u0004XCAA(!!\t\t&!\u0017\u0002`\u0005Mb\u0002BA*\u0003+\u0002B!!\b\u0002,%!\u0011qKA\u0016\u0003\u0019\u0001&/\u001a3fM&!\u00111LA/\u0005\ri\u0015\r\u001d\u0006\u0005\u0003/\nY\u0003\u0005\u0003\u0002b\u0005\u001dTBAA2\u0015\r\t)\u0007\\\u0001\tG\u0006$\u0018\r\\=ti&!\u0011\u0011NA2\u0005=!\u0016M\u00197f\u0013\u0012,g\u000e^5gS\u0016\u0014\u0018\u0001\u0004;bE2,W*\u00199`I\u0015\fH\u0003BA\u001f\u0003_B\u0011\"a\u0012\b\u0003\u0003\u0005\r!a\u0014\u0002\u0013Q\f'\r\\3NCB\u0004\u0013!\u00024m_^\u001cXCAA<!\u0019\tI\"!\f\u0002zA!\u0011QAA>\u0013\r\ti\b\u001b\u0002\u0005\r2|w/A\u0005gY><8o\u0018\u0013fcR!\u0011QHAB\u0011%\t9ECA\u0001\u0002\u0004\t9(\u0001\u0004gY><8\u000fI\u0001\bM2|wo\u001d+p+\t\tY\t\u0005\u0005\u0002R\u0005e\u0013qLA<\u0003-1Gn\\<t)>|F%Z9\u0015\t\u0005u\u0012\u0011\u0013\u0005\n\u0003\u000fj\u0011\u0011!a\u0001\u0003\u0017\u000b\u0001B\u001a7poN$v\u000eI\u0001\u0006m&,wo]\u000b\u0003\u00033\u0003b!!\u0007\u0002.\u0005m\u0005\u0003BA\u0003\u0003;K1!a(i\u0005\u00111\u0016.Z<\u0002\u0013YLWm^:`I\u0015\fH\u0003BA\u001f\u0003KC\u0011\"a\u0012\u0011\u0003\u0003\u0005\r!!'\u0002\rYLWm^:!\u0003\u001d1\u0018.Z<NCB,\"!!,\u0011\u0011\u0005E\u0013\u0011LA0\u00037\u000b1B^5fo6\u000b\u0007o\u0018\u0013fcR!\u0011QHAZ\u0011%\t9eEA\u0001\u0002\u0004\ti+\u0001\u0005wS\u0016<X*\u00199!\u0003\u0015\u0019\u0018N\\6t+\t\tY\f\u0005\u0004\u0002\u001a\u00055\u0012Q\u0018\t\u0005\u0003\u000b\ty,C\u0002\u0002B\"\u0014AaU5oW\u0006I1/\u001b8lg~#S-\u001d\u000b\u0005\u0003{\t9\rC\u0005\u0002HY\t\t\u00111\u0001\u0002<\u000611/\u001b8lg\u0002\nqa]5oW6\u000b\u0007/\u0006\u0002\u0002PBA\u0011\u0011KA-\u0003?\ni,A\u0006tS:\\W*\u00199`I\u0015\fH\u0003BA\u001f\u0003+D\u0011\"a\u0012\u001a\u0003\u0003\u0005\r!a4\u0002\u0011MLgn['ba\u0002\n1BZ1jY\u0016$g\t\\8xgV\u0011\u0011Q\u001c\t\u0007\u00033\ti#a8\u0011\t\u0005\u0015\u0011\u0011]\u0005\u0004\u0003GD'a\u0006*fg>dW\u000f^5p]\u000e{W\u000e\u001d7fi\u0016$g\t\\8x\u0003=1\u0017-\u001b7fI\u001acwn^:`I\u0015\fH\u0003BA\u001f\u0003SD\u0011\"a\u0012\u001d\u0003\u0003\u0005\r!!8\u0002\u0019\u0019\f\u0017\u000e\\3e\r2|wo\u001d\u0011\u0002\u0019\u0019\f\u0017\u000e\\3e)\u0006\u0014G.Z:\u0002!\u0019\f\u0017\u000e\\3e)\u0006\u0014G.Z:`I\u0015\fH\u0003BA\u001f\u0003gD\u0011\"a\u0012 \u0003\u0003\u0005\r!a\u0006\u0002\u001b\u0019\f\u0017\u000e\\3e)\u0006\u0014G.Z:!\u0003-1\u0017-\u001b7fINKgn[:\u0002\u001f\u0019\f\u0017\u000e\\3e'&t7n]0%KF$B!!\u0010\u0002~\"I\u0011q\t\u0012\u0002\u0002\u0003\u0007\u00111X\u0001\rM\u0006LG.\u001a3TS:\\7\u000fI\u0001\fa\u0006\u0014\u0018\r\u001c7fY&\u001cX.\u0006\u0002\u0003\u0006A!\u0011q\bB\u0004\u0013\u0011\u0011I!a\u000b\u0003\u0007%sG/\u0001\u0007qCJ\fG\u000e\\3mSNl\u0007%\u0001\u000fgSb,G\rU8pY\u0016CXmY;u_JLe.\u001b;jC2L'0\u001a3\u0016\u0005\tE\u0001\u0003BA \u0005'IAA!\u0006\u0002,\t9!i\\8mK\u0006t\u0017\u0001\t4jq\u0016$\u0007k\\8m\u000bb,7-\u001e;pe&s\u0017\u000e^5bY&TX\rZ0%KF$B!!\u0010\u0003\u001c!I\u0011qI\u0014\u0002\u0002\u0003\u0007!\u0011C\u0001\u001eM&DX\r\u001a)p_2,\u00050Z2vi>\u0014\u0018J\\5uS\u0006d\u0017N_3eA\u0005\tb-\u001b=fIB{w\u000e\\#yK\u000e,Ho\u001c:\u0016\u0005\t\r\u0002\u0003\u0002B\u0013\u0005_i!Aa\n\u000b\t\t%\"1F\u0001\u000bG>t7-\u001e:sK:$(b\u0001B\u0017u\u0006!Q\u000f^5m\u0013\u0011\u0011\tDa\n\u0003%QC'/Z1e!>|G.\u0012=fGV$xN]\u0001\rg\u0016dg-\u0012=fGV$xN]\u000b\u0003\u0005o\u0001BA!\n\u0003:%!!1\bB\u0014\u0005=)\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017!D:fY\u001a,\u00050Z2vi>\u0014\b%A\bd_6\u0004X\u000f^3UC\ndW-T1q)\t\ty%\u0001\bd_6\u0004X\u000f^3WS\u0016<X*\u00199\u0015\u0005\u00055\u0016AD2p[B,H/Z*j].l\u0015\r\u001d\u000b\u0003\u0003\u001f\fabY8naV$XM\u00127poN$v\u000e\u0006\u0002\u0002\f\u0006yAO]1og\u001a|'/\u001c+bE2,7\u000f\u0006\u0003\u0002\u0010\tM\u0003b\u0002B+a\u0001\u0007!qK\u0001\fiJ\fgn\u001d4pe6,'\u000f\u0005\u0005\u0002@\te\u00131GA\u001a\u0013\u0011\u0011Y&a\u000b\u0003\u0013\u0019+hn\u0019;j_:\f\u0014A\b3fM\u0006,H\u000e^(o\r\u0006LG.\u001a3EKB,g\u000eZ3oiR\u000b'\r\\3t)\u0011\tiD!\u0019\t\u000f\t\r\u0014\u00071\u0001\u0003f\u00059b-Y5mK\u0012$\u0016M\u00197f\t\u0016\u0004XM\u001c3f]\u000eLWm\u001d\t\t\u0003#\nI&a\u0018\u0002\u0018\u0005\u0011BO]1og\u001a|'/\u001c#po:tu\u000eZ3t)\u0019\tyAa\u001b\u0003|!9!Q\u000b\u001aA\u0002\t5\u0004CCA \u0005_\u0012\u0019H!\u001f\u0003z%!!\u0011OA\u0016\u0005%1UO\\2uS>t'\u0007\u0005\u0003\u0002\u0006\tU\u0014b\u0001B<Q\naqI]1qQ\u0016cW-\\3oiB1\u0011\u0011DA\u0017\u0005gB\u0011B! 3!\u0003\u0005\rA!\u0005\u0002%\u0011L7/\u00192mKB\u000b'/\u00197mK2L7/\\\u0001\u001diJ\fgn\u001d4pe6$un\u001e8O_\u0012,7\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011\u0019I\u000b\u0003\u0003\u0012\t\u00155F\u0001BD!\u0011\u0011IIa%\u000e\u0005\t-%\u0002\u0002BG\u0005\u001f\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\t\tE\u00151F\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002BK\u0005\u0017\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003A9W\r\u001e#bi\u00064Gn\\<He\u0006\u0004\b.\u0006\u0002\u0002\u0004\u0005)1\r\\8tKR\u0011\u0011QH\u0001\u0019\t\u0006$\u0018M\u001a7po\u001e\u0013\u0018\r\u001d5Ue\u0006t7OZ8s[\u0016\u0014\bcAA\u0003oM\u0019qG!*\u0011\t\u0005}\"qU\u0005\u0005\u0005S\u000bYC\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0005C\u0013q\u0004\u0016:b]N4wN]7O_\u0012,'+\u001a;ss\u0006\u0014G.Z#yG\u0016\u0004H/[8o'%I$\u0011\u0017B\\\u0005\u000b\u0014Y\r\u0005\u0003\u0002\u001a\tM\u0016\u0002\u0002B[\u0003c\u0011\u0011\"\u0012=dKB$\u0018n\u001c8\u0011\t\te&\u0011Y\u0007\u0003\u0005wSAA!0\u0003@\u000691m\u001c8ue>d'\u0002\u0002B\u0017\u0003WIAAa1\u0003<\naaj\\*uC\u000e\\GK]1dKB!\u0011q\bBd\u0013\u0011\u0011I-a\u000b\u0003\u000fA\u0013x\u000eZ;diB!\u0011\u0011\u0004Bg\u0013\u0011\u0011y-!\r\u0003\u0019M+'/[1mSj\f'\r\\3\u0002#\u0011\fG/Y:fi&#WM\u001c;jM&,'/\u0006\u0002\u0002`\u0005\u0011B-\u0019;bg\u0016$\u0018\nZ3oi&4\u0017.\u001a:!\u0003)1\u0017-\u001b7fI:{G-Z\u000b\u0003\u00057\u0004B!!\u0002\u0003^&\u0019!q\u001c5\u0003)I+7o\u001c7vi&|gNR1jY\u0016$g\t\\8x\u0003-1\u0017-\u001b7fI:{G-\u001a\u0011\u0015\r\t\u0015(\u0011\u001eBv!\r\u00119/O\u0007\u0002o!9!\u0011\u001b A\u0002\u0005}\u0003b\u0002Bl}\u0001\u0007!1\\\u0001\u0005G>\u0004\u0018\u0010\u0006\u0004\u0003f\nE(1\u001f\u0005\n\u0005#|\u0004\u0013!a\u0001\u0003?B\u0011Ba6@!\u0003\u0005\rAa7\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!\u0011 \u0016\u0005\u0003?\u0012))\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t}(\u0006\u0002Bn\u0005\u000b\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAB\u0003!\r98qA\u0005\u0004\u0007\u0013A(AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\rE1q\u0003\t\u0005\u0003\u007f\u0019\u0019\"\u0003\u0003\u0004\u0016\u0005-\"aA!os\"I\u0011q\t#\u0002\u0002\u0003\u0007!QA\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u00111Q\u0004\t\u0007\u0007?\u0019)c!\u0005\u000e\u0005\r\u0005\"\u0002BB\u0012\u0003W\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u00199c!\t\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005#\u0019i\u0003C\u0005\u0002H\u0019\u000b\t\u00111\u0001\u0004\u0012\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\u0019)aa\r\t\u0013\u0005\u001ds)!AA\u0002\t\u0015\u0011\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\t\u0015\u0011AB3rk\u0006d7\u000f\u0006\u0003\u0003\u0012\ru\u0002\"CA$\u0013\u0006\u0005\t\u0019AB\t\u0003}!&/\u00198tM>\u0014XNT8eKJ+GO]=bE2,W\t_2faRLwN\u001c\t\u0004\u0005O\\5#B&\u0004F\rE\u0003CCB$\u0007\u001b\nyFa7\u0003f6\u00111\u0011\n\u0006\u0005\u0007\u0017\nY#A\u0004sk:$\u0018.\\3\n\t\r=3\u0011\n\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004\u0003BB*\u00073j!a!\u0016\u000b\u0007\r]#0\u0001\u0002j_&!!qZB+)\t\u0019\t%\u0001\u0005u_N#(/\u001b8h)\t\u0019)!A\u0003baBd\u0017\u0010\u0006\u0004\u0003f\u000e\u00154q\r\u0005\b\u0005#t\u0005\u0019AA0\u0011\u001d\u00119N\u0014a\u0001\u00057\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0004n\re\u0004CBA \u0007_\u001a\u0019(\u0003\u0003\u0004r\u0005-\"AB(qi&|g\u000e\u0005\u0005\u0002@\rU\u0014q\fBn\u0013\u0011\u00199(a\u000b\u0003\rQ+\b\u000f\\33\u0011%\u0019YhTA\u0001\u0002\u0004\u0011)/A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\u0012A\u001e\u0002\u001d)J\fgn\u001d4pe6tu\u000eZ3GC&dW\rZ#yG\u0016\u0004H/[8o'%\t&\u0011\u0017B\\\u0005\u000b\u0014Y\r\u0006\u0003\u0004\b\u000e%\u0005c\u0001Bt#\"9!q\u001b+A\u0002\tmG\u0003BBD\u0007\u001bC\u0011Ba6V!\u0003\u0005\rAa7\u0015\t\rE1\u0011\u0013\u0005\n\u0003\u000fJ\u0016\u0011!a\u0001\u0005\u000b!BA!\u0005\u0004\u0016\"I\u0011qI.\u0002\u0002\u0003\u00071\u0011\u0003\u000b\u0005\u0007\u000b\u0019I\nC\u0005\u0002Hq\u000b\t\u00111\u0001\u0003\u0006Q!!\u0011CBO\u0011%\t9EXA\u0001\u0002\u0004\u0019\t\"\u0001\u000fUe\u0006t7OZ8s[:{G-\u001a$bS2,G-\u0012=dKB$\u0018n\u001c8\u0011\u0007\t\u001d\bmE\u0003a\u0007K\u001b\t\u0006\u0005\u0005\u0004H\r\u001d&1\\BD\u0013\u0011\u0019Ik!\u0013\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0006\u0002\u0004\"R!1qQBX\u0011\u001d\u00119n\u0019a\u0001\u00057$Baa-\u00046B1\u0011qHB8\u00057D\u0011ba\u001fe\u0003\u0003\u0005\raa\"\u00029]LG\u000f\u001b#bi\u00064Gn\\<He\u0006\u0004\b\u000e\u0016:b]N4wN]7feV!11XBb)\u0011\u0019il!6\u0015\t\r}6q\u001a\t\u0005\u0007\u0003\u001c\u0019\r\u0004\u0001\u0005\u000f\r\u0015gM1\u0001\u0004H\n\tA+\u0005\u0003\u0004J\u000eE\u0001\u0003BA \u0007\u0017LAa!4\u0002,\t9aj\u001c;iS:<\u0007bBBiM\u0002\u000711[\u0001\u0002MBA\u0011q\bB-\u0003\u001f\u0019y\f\u0003\u0004jM\u0002\u0007\u00111\u0001")
public class DataflowGraphTransformer
implements AutoCloseable {
    private ThreadPoolExecutor fixedPoolExecutor;
    private final DataflowGraph graph;
    private scala.collection.immutable.Seq<Table> tables;
    private Map<TableIdentifier, Table> tableMap;
    private scala.collection.immutable.Seq<Flow> flows;
    private Map<TableIdentifier, scala.collection.immutable.Seq<Flow>> flowsTo;
    private scala.collection.immutable.Seq<View> views;
    private Map<TableIdentifier, View> viewMap;
    private scala.collection.immutable.Seq<Sink> sinks;
    private Map<TableIdentifier, Sink> sinkMap;
    private scala.collection.immutable.Seq<ResolutionCompletedFlow> failedFlows;
    private scala.collection.immutable.Seq<Table> failedTables;
    private scala.collection.immutable.Seq<Sink> failedSinks;
    private final int parallelism;
    private boolean fixedPoolExecutorInitialized;
    private final ExecutorService selfExecutor;
    private volatile boolean bitmap$0;

    public static <T> T withDataflowGraphTransformer(DataflowGraph graph, Function1<DataflowGraphTransformer, T> f) {
        return DataflowGraphTransformer$.MODULE$.withDataflowGraphTransformer(graph, f);
    }

    private scala.collection.immutable.Seq<Table> tables() {
        return this.tables;
    }

    private void tables_$eq(scala.collection.immutable.Seq<Table> x$1) {
        this.tables = x$1;
    }

    private Map<TableIdentifier, Table> tableMap() {
        return this.tableMap;
    }

    private void tableMap_$eq(Map<TableIdentifier, Table> x$1) {
        this.tableMap = x$1;
    }

    private scala.collection.immutable.Seq<Flow> flows() {
        return this.flows;
    }

    private void flows_$eq(scala.collection.immutable.Seq<Flow> x$1) {
        this.flows = x$1;
    }

    private Map<TableIdentifier, scala.collection.immutable.Seq<Flow>> flowsTo() {
        return this.flowsTo;
    }

    private void flowsTo_$eq(Map<TableIdentifier, scala.collection.immutable.Seq<Flow>> x$1) {
        this.flowsTo = x$1;
    }

    private scala.collection.immutable.Seq<View> views() {
        return this.views;
    }

    private void views_$eq(scala.collection.immutable.Seq<View> x$1) {
        this.views = x$1;
    }

    private Map<TableIdentifier, View> viewMap() {
        return this.viewMap;
    }

    private void viewMap_$eq(Map<TableIdentifier, View> x$1) {
        this.viewMap = x$1;
    }

    private scala.collection.immutable.Seq<Sink> sinks() {
        return this.sinks;
    }

    private void sinks_$eq(scala.collection.immutable.Seq<Sink> x$1) {
        this.sinks = x$1;
    }

    private Map<TableIdentifier, Sink> sinkMap() {
        return this.sinkMap;
    }

    private void sinkMap_$eq(Map<TableIdentifier, Sink> x$1) {
        this.sinkMap = x$1;
    }

    private scala.collection.immutable.Seq<ResolutionCompletedFlow> failedFlows() {
        return this.failedFlows;
    }

    private void failedFlows_$eq(scala.collection.immutable.Seq<ResolutionCompletedFlow> x$1) {
        this.failedFlows = x$1;
    }

    private scala.collection.immutable.Seq<Table> failedTables() {
        return this.failedTables;
    }

    private void failedTables_$eq(scala.collection.immutable.Seq<Table> x$1) {
        this.failedTables = x$1;
    }

    private scala.collection.immutable.Seq<Sink> failedSinks() {
        return this.failedSinks;
    }

    private void failedSinks_$eq(scala.collection.immutable.Seq<Sink> x$1) {
        this.failedSinks = x$1;
    }

    private int parallelism() {
        return this.parallelism;
    }

    private boolean fixedPoolExecutorInitialized() {
        return this.fixedPoolExecutorInitialized;
    }

    private void fixedPoolExecutorInitialized_$eq(boolean x$1) {
        this.fixedPoolExecutorInitialized = x$1;
    }

    private ThreadPoolExecutor fixedPoolExecutor$lzycompute() {
        DataflowGraphTransformer dataflowGraphTransformer = this;
        synchronized (dataflowGraphTransformer) {
            if (!this.bitmap$0) {
                this.fixedPoolExecutorInitialized_$eq(true);
                this.fixedPoolExecutor = ThreadUtils$.MODULE$.newDaemonFixedThreadPool(this.parallelism(), "data-flow-graph-transformer-");
                this.bitmap$0 = true;
            }
        }
        return this.fixedPoolExecutor;
    }

    private ThreadPoolExecutor fixedPoolExecutor() {
        if (!this.bitmap$0) {
            return this.fixedPoolExecutor$lzycompute();
        }
        return this.fixedPoolExecutor;
    }

    private ExecutorService selfExecutor() {
        return this.selfExecutor;
    }

    private synchronized Map<TableIdentifier, Table> computeTableMap() {
        return ((IterableOnceOps)this.tables().map((Function1 & Serializable)table -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)table.identifier()), table))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private synchronized Map<TableIdentifier, View> computeViewMap() {
        return ((IterableOnceOps)this.views().map((Function1 & Serializable)view -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)view.identifier()), view))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private synchronized Map<TableIdentifier, Sink> computeSinkMap() {
        return ((IterableOnceOps)this.sinks().map((Function1 & Serializable)sink -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)sink.identifier()), sink))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private synchronized Map<TableIdentifier, scala.collection.immutable.Seq<Flow>> computeFlowsTo() {
        return this.flows().groupBy((Function1 & Serializable)x$1 -> x$1.destinationIdentifier());
    }

    public synchronized DataflowGraphTransformer transformTables(Function1<Table, Table> transformer) {
        this.tables_$eq((scala.collection.immutable.Seq<Table>)((scala.collection.immutable.Seq)this.tables().map(transformer)));
        this.tableMap_$eq(this.computeTableMap());
        return this;
    }

    private void defaultOnFailedDependentTables(Map<TableIdentifier, scala.collection.immutable.Seq<Table>> failedTableDependencies) {
        Predef$.MODULE$.require(failedTableDependencies.isEmpty(), (Function0 & Serializable)() -> "Dependency failure happened and some tables were not resolved");
    }

    public DataflowGraphTransformer transformDownNodes(Function2<GraphElement, scala.collection.immutable.Seq<GraphElement>, scala.collection.immutable.Seq<GraphElement>> transformer, boolean disableParallelism) {
        ExecutorService executor = disableParallelism ? this.selfExecutor() : this.fixedPoolExecutor();
        int batchSize = disableParallelism ? 1 : this.parallelism();
        ConcurrentLinkedQueue resolvedFlows2 = new ConcurrentLinkedQueue();
        ConcurrentLinkedQueue resolvedTables = new ConcurrentLinkedQueue();
        ConcurrentLinkedQueue resolvedViews = new ConcurrentLinkedQueue();
        ConcurrentLinkedQueue resolvedSinks = new ConcurrentLinkedQueue();
        ConcurrentHashMap resolvedFlowsMap = new ConcurrentHashMap();
        ConcurrentHashMap resolvedFlowDestinationsMap = new ConcurrentHashMap();
        ConcurrentLinkedQueue failedFlowsQueue = new ConcurrentLinkedQueue();
        ConcurrentHashMap failedDependentFlows = new ConcurrentHashMap();
        ArrayBuffer futures = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        ConcurrentLinkedDeque toBeResolvedFlows = new ConcurrentLinkedDeque();
        toBeResolvedFlows.addAll(CollectionConverters$.MODULE$.SeqHasAsJava(this.flows()).asJava());
        while (futures.nonEmpty() || toBeResolvedFlows.peekFirst() != null) {
            BoxedUnit boxedUnit;
            None$ flowOpt;
            Tuple2 tuple2 = futures.partition((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isDone()));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ArrayBuffer done = (ArrayBuffer)tuple2._1();
            ArrayBuffer notDone = (ArrayBuffer)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)done, (Object)notDone);
            ArrayBuffer done2 = (ArrayBuffer)tuple22._1();
            ArrayBuffer notDone2 = (ArrayBuffer)tuple22._2();
            try {
                done2.foreach((Function1 & Serializable)x$4 -> {
                    x$4.get();
                    return BoxedUnit.UNIT;
                });
            }
            catch (ExecutionException exn) {
                throw exn.getCause();
            }
            futures = notDone2;
            Object object = flowOpt = futures.size() < batchSize ? Option$.MODULE$.apply(toBeResolvedFlows.pollFirst()) : None$.MODULE$;
            if (flowOpt.isDefined()) {
                Flow flow2 = (Flow)flowOpt.get();
                boxedUnit = futures.append(executor.submit(() -> {
                    DataflowGraphTransformer.$anonfun$transformDownNodes$3(this, transformer, flow2, resolvedFlowsMap, resolvedFlows2, failedDependentFlows, resolvedFlowDestinationsMap, toBeResolvedFlows, resolvedTables, resolvedViews, resolvedSinks, failedFlowsQueue);
                    return BoxedUnit.UNIT;
                }));
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        this.failedTables_$eq((scala.collection.immutable.Seq<Table>)((scala.collection.immutable.Seq)this.tables().filterNot((Function1 & Serializable)table -> BoxesRunTime.boxToBoolean((boolean)DataflowGraphTransformer.$anonfun$transformDownNodes$20(resolvedFlowDestinationsMap, table)))));
        this.failedSinks_$eq((scala.collection.immutable.Seq<Sink>)((scala.collection.immutable.Seq)this.sinks().filterNot((Function1 & Serializable)sink -> BoxesRunTime.boxToBoolean((boolean)DataflowGraphTransformer.$anonfun$transformDownNodes$21(resolvedFlowDestinationsMap, sink)))));
        Tuple2 tuple2 = CollectionConverters$.MODULE$.CollectionHasAsScala(resolvedFlows2).asScala().toSeq().partition((Function1 & Serializable)flow -> BoxesRunTime.boxToBoolean((boolean)DataflowGraphTransformer.$anonfun$transformDownNodes$22(resolvedFlowDestinationsMap, flow)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Seq resolvedFlowsWithResolvedDest = (scala.collection.immutable.Seq)tuple2._1();
        scala.collection.immutable.Seq resolvedFlowsWithFailedDest = (scala.collection.immutable.Seq)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)resolvedFlowsWithResolvedDest, (Object)resolvedFlowsWithFailedDest);
        scala.collection.immutable.Seq resolvedFlowsWithResolvedDest2 = (scala.collection.immutable.Seq)tuple23._1();
        scala.collection.immutable.Seq resolvedFlowsWithFailedDest2 = (scala.collection.immutable.Seq)tuple23._2();
        this.failedFlows_$eq((scala.collection.immutable.Seq<ResolutionCompletedFlow>)((scala.collection.immutable.Seq)((IterableOps)resolvedFlowsWithFailedDest2.$plus$plus((IterableOnce)CollectionConverters$.MODULE$.CollectionHasAsScala(failedFlowsQueue).asScala().toSeq())).$plus$plus((IterableOnce)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(failedDependentFlows.values()).asScala().flatten(Predef$.MODULE$.$conforms())).toSeq())));
        this.flows_$eq((scala.collection.immutable.Seq<Flow>)resolvedFlowsWithResolvedDest2);
        this.flowsTo_$eq(this.computeFlowsTo());
        this.tables_$eq((scala.collection.immutable.Seq<Table>)CollectionConverters$.MODULE$.CollectionHasAsScala(resolvedTables).asScala().toSeq());
        this.views_$eq((scala.collection.immutable.Seq<View>)CollectionConverters$.MODULE$.CollectionHasAsScala(resolvedViews).asScala().toSeq());
        this.sinks_$eq((scala.collection.immutable.Seq<Sink>)CollectionConverters$.MODULE$.CollectionHasAsScala(resolvedSinks).asScala().toSeq());
        this.tableMap_$eq(this.computeTableMap());
        this.viewMap_$eq(this.computeViewMap());
        this.sinkMap_$eq(this.computeSinkMap());
        return this;
    }

    public boolean transformDownNodes$default$2() {
        return false;
    }

    public DataflowGraph getDataflowGraph() {
        return this.graph.copy((scala.collection.immutable.Seq<Flow>)((scala.collection.immutable.Seq)this.flows().$plus$plus(this.failedFlows())), (scala.collection.immutable.Seq<Table>)((scala.collection.immutable.Seq)this.tables().$plus$plus(this.failedTables())), (scala.collection.immutable.Seq<Sink>)((scala.collection.immutable.Seq)this.sinks().$plus$plus(this.failedSinks())), this.graph.copy$default$4());
    }

    @Override
    public void close() {
        if (this.fixedPoolExecutorInitialized()) {
            this.fixedPoolExecutor().shutdown();
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$transformDownNodes$4(GraphElement x$5) {
        return x$5 instanceof ResolvedFlow;
    }

    public static final /* synthetic */ boolean $anonfun$transformDownNodes$8(ConcurrentHashMap failedDependentFlows$1, TableIdentifier datasetIdentifier$1, ConcurrentLinkedDeque toBeResolvedFlows$1, TableIdentifier x$8, boolean resolved) {
        Object object = resolved ? failedDependentFlows$1.computeIfPresent(datasetIdentifier$1, (x$9, toRetryFlows) -> {
            toRetryFlows.foreach((Function1 & Serializable)x$10 -> {
                toBeResolvedFlows$1.addFirst(x$10);
                return BoxedUnit.UNIT;
            });
            return null;
        }) : BoxedUnit.UNIT;
        return resolved;
    }

    public static final /* synthetic */ boolean $anonfun$transformDownNodes$12(BooleanRef isCurrentThreadLeader$1, TableIdentifier x$11) {
        isCurrentThreadLeader$1.elem = true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$transformDownNodes$14(GraphElement x$13) {
        return x$13 instanceof Sink;
    }

    public static final /* synthetic */ boolean $anonfun$transformDownNodes$17(ConcurrentHashMap failedDependentFlows$1, Flow flow$1, ConcurrentLinkedDeque toBeResolvedFlows$1, TableIdentifier x$15, boolean x$16) {
        failedDependentFlows$1.computeIfPresent(flow$1.destinationIdentifier(), (x$17, toRetryFlows) -> {
            toRetryFlows.foreach((Function1 & Serializable)x$18 -> {
                toBeResolvedFlows$1.addFirst(x$18);
                return BoxedUnit.UNIT;
            });
            return null;
        });
        return true;
    }

    public static final /* synthetic */ void $anonfun$transformDownNodes$3(DataflowGraphTransformer $this, Function2 transformer$1, Flow flow$1, ConcurrentHashMap resolvedFlowsMap$1, ConcurrentLinkedQueue resolvedFlows$1, ConcurrentHashMap failedDependentFlows$1, ConcurrentHashMap resolvedFlowDestinationsMap$1, ConcurrentLinkedDeque toBeResolvedFlows$1, ConcurrentLinkedQueue resolvedTables$1, ConcurrentLinkedQueue resolvedViews$1, ConcurrentLinkedQueue resolvedSinks$1, ConcurrentLinkedQueue failedFlowsQueue$1) {
        block12: {
            try {
                Object object;
                try {
                    scala.collection.immutable.Seq result = (scala.collection.immutable.Seq)transformer$1.apply((Object)flow$1, (Object)package$.MODULE$.Seq().empty());
                    Predef$.MODULE$.require(result.forall((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DataflowGraphTransformer.$anonfun$transformDownNodes$4(x$5))), (Function0 & Serializable)() -> "transformer must return a Seq[Flow]");
                    scala.collection.immutable.Seq transformedFlows = (scala.collection.immutable.Seq)result.map((Function1 & Serializable)x$6 -> (ResolvedFlow)x$6);
                    resolvedFlowsMap$1.put(flow$1.identifier(), transformedFlows);
                    object = BoxesRunTime.boxToBoolean((boolean)resolvedFlows$1.addAll(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)transformedFlows).asJava()));
                }
                catch (TransformNodeRetryableException e) {
                    TableIdentifier datasetIdentifier = e.datasetIdentifier();
                    failedDependentFlows$1.compute(datasetIdentifier, (x$7, flows) -> {
                        ResolutionFailedFlow failedFlow = e.failedNode();
                        if (flows == null) {
                            return new .colon.colon((Object)failedFlow, (List)Nil$.MODULE$);
                        }
                        return (scala.collection.immutable.Seq)flows.$colon$plus((Object)failedFlow);
                    });
                    object = resolvedFlowDestinationsMap$1.computeIfPresent(datasetIdentifier, (x$8, resolved) -> BoxesRunTime.boxToBoolean((boolean)DataflowGraphTransformer.$anonfun$transformDownNodes$8(failedDependentFlows$1, datasetIdentifier, toBeResolvedFlows$1, x$8, BoxesRunTime.unboxToBoolean((Object)resolved))));
                }
                catch (Throwable other) {
                    throw other;
                }
                if (!((IterableOnceOps)$this.flowsTo().apply((Object)flow$1.destinationIdentifier())).forall((Function1 & Serializable)flowToDestination -> BoxesRunTime.boxToBoolean((boolean)resolvedFlowsMap$1.containsKey(flowToDestination.identifier())))) break block12;
                BooleanRef isCurrentThreadLeader = BooleanRef.create((boolean)false);
                resolvedFlowDestinationsMap$1.computeIfAbsent(flow$1.destinationIdentifier(), x$11 -> BoxesRunTime.boxToBoolean((boolean)DataflowGraphTransformer.$anonfun$transformDownNodes$12(isCurrentThreadLeader, x$11)));
                if (isCurrentThreadLeader.elem) {
                    if ($this.tableMap().contains((Object)flow$1.destinationIdentifier())) {
                        scala.collection.immutable.Seq transformed = (scala.collection.immutable.Seq)transformer$1.apply($this.tableMap().apply((Object)flow$1.destinationIdentifier()), $this.flowsTo().apply((Object)flow$1.destinationIdentifier()));
                        resolvedTables$1.addAll(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)transformed.collect((PartialFunction)new Serializable(null){
                            private static final long serialVersionUID = 0L;

                            public final <A1 extends GraphElement, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                A1 A1 = x1;
                                if (A1 instanceof Table) {
                                    Table table = (Table)A1;
                                    return (B1)table;
                                }
                                return (B1)function1.apply(x1);
                            }

                            public final boolean isDefinedAt(GraphElement x1) {
                                GraphElement graphElement = x1;
                                return graphElement instanceof Table;
                            }
                        })).asJava());
                        v1 = resolvedFlows$1.addAll(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)transformed.collect((PartialFunction)new Serializable(null){
                            private static final long serialVersionUID = 0L;

                            public final <A1 extends GraphElement, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                                A1 A1 = x2;
                                if (A1 instanceof ResolvedFlow) {
                                    ResolvedFlow resolvedFlow = (ResolvedFlow)A1;
                                    return (B1)resolvedFlow;
                                }
                                return (B1)function1.apply(x2);
                            }

                            public final boolean isDefinedAt(GraphElement x2) {
                                GraphElement graphElement = x2;
                                return graphElement instanceof ResolvedFlow;
                            }
                        })).asJava());
                    } else if ($this.viewMap().contains((Object)flow$1.destinationIdentifier())) {
                        scala.collection.immutable.Seq transformed = (scala.collection.immutable.Seq)transformer$1.apply($this.viewMap().apply((Object)flow$1.destinationIdentifier()), $this.flowsTo().apply((Object)flow$1.destinationIdentifier()));
                        v1 = resolvedViews$1.addAll(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)transformed.map((Function1 & Serializable)x$12 -> (View)x$12)).asJava());
                    } else if ($this.sinkMap().contains((Object)flow$1.destinationIdentifier())) {
                        scala.collection.immutable.Seq transformed = (scala.collection.immutable.Seq)transformer$1.apply($this.sinkMap().apply((Object)flow$1.destinationIdentifier()), $this.flowsTo().apply((Object)flow$1.destinationIdentifier()));
                        Predef$.MODULE$.require(transformed.forall((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)DataflowGraphTransformer.$anonfun$transformDownNodes$14(x$13))), (Function0 & Serializable)() -> "transformer must return a Seq[Sink]");
                        v1 = resolvedSinks$1.addAll(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)transformed.map((Function1 & Serializable)x$14 -> (Sink)x$14)).asJava());
                    } else {
                        throw new IllegalArgumentException("Unsupported destination " + flow$1.destinationIdentifier().unquotedString() + " in flow: " + flow$1.displayName() + " at transformDownNodes");
                    }
                    resolvedFlowDestinationsMap$1.computeIfPresent(flow$1.destinationIdentifier(), (x$15, x$16) -> BoxesRunTime.boxToBoolean((boolean)DataflowGraphTransformer.$anonfun$transformDownNodes$17(failedDependentFlows$1, flow$1, toBeResolvedFlows$1, x$15, BoxesRunTime.unboxToBoolean((Object)x$16))));
                }
            }
            catch (TransformNodeFailedException ex) {
                failedFlowsQueue$1.add(ex.failedNode());
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$transformDownNodes$20(ConcurrentHashMap resolvedFlowDestinationsMap$1, Table table) {
        return BoxesRunTime.unboxToBoolean((Object)resolvedFlowDestinationsMap$1.getOrDefault(table.identifier(), BoxesRunTime.boxToBoolean((boolean)false)));
    }

    public static final /* synthetic */ boolean $anonfun$transformDownNodes$21(ConcurrentHashMap resolvedFlowDestinationsMap$1, Sink sink) {
        return BoxesRunTime.unboxToBoolean((Object)resolvedFlowDestinationsMap$1.getOrDefault(sink.identifier(), BoxesRunTime.boxToBoolean((boolean)false)));
    }

    public static final /* synthetic */ boolean $anonfun$transformDownNodes$22(ConcurrentHashMap resolvedFlowDestinationsMap$1, ResolutionCompletedFlow flow) {
        return BoxesRunTime.unboxToBoolean((Object)resolvedFlowDestinationsMap$1.getOrDefault(flow.destinationIdentifier(), BoxesRunTime.boxToBoolean((boolean)false)));
    }

    public DataflowGraphTransformer(DataflowGraph graph) {
        this.graph = graph;
        this.tables = graph.tables();
        this.tableMap = this.computeTableMap();
        this.flows = graph.flows();
        this.flowsTo = this.computeFlowsTo();
        this.views = graph.views();
        this.viewMap = this.computeViewMap();
        this.sinks = graph.sinks();
        this.sinkMap = this.computeSinkMap();
        this.failedFlows = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        this.failedTables = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        this.failedSinks = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        this.parallelism = 10;
        this.fixedPoolExecutorInitialized = false;
        this.selfExecutor = ThreadUtils$.MODULE$.sameThreadExecutorService();
    }

    public static class TransformNodeFailedException
    extends Exception
    implements NoStackTrace,
    Product {
        private final ResolutionFailedFlow failedNode;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public /* synthetic */ Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        @Override
        public Throwable fillInStackTrace() {
            return NoStackTrace.fillInStackTrace$((NoStackTrace)this);
        }

        public ResolutionFailedFlow failedNode() {
            return this.failedNode;
        }

        public TransformNodeFailedException copy(ResolutionFailedFlow failedNode) {
            return new TransformNodeFailedException(failedNode);
        }

        public ResolutionFailedFlow copy$default$1() {
            return this.failedNode();
        }

        public String productPrefix() {
            return "TransformNodeFailedException";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.failedNode();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof TransformNodeFailedException;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "failedNode";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 1007710952, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof TransformNodeFailedException)) return false;
            boolean bl = true;
            if (!bl) return false;
            TransformNodeFailedException transformNodeFailedException = (TransformNodeFailedException)x$1;
            ResolutionFailedFlow resolutionFailedFlow = this.failedNode();
            ResolutionFailedFlow resolutionFailedFlow2 = transformNodeFailedException.failedNode();
            if (resolutionFailedFlow == null) {
                if (resolutionFailedFlow2 != null) {
                    return false;
                }
            } else if (!resolutionFailedFlow.equals(resolutionFailedFlow2)) return false;
            if (!transformNodeFailedException.canEqual(this)) return false;
            return true;
        }

        public TransformNodeFailedException(ResolutionFailedFlow failedNode) {
            this.failedNode = failedNode;
            NoStackTrace.$init$((NoStackTrace)this);
            Product.$init$((Product)this);
        }
    }

    public static class TransformNodeRetryableException
    extends Exception
    implements NoStackTrace,
    Product {
        private final TableIdentifier datasetIdentifier;
        private final ResolutionFailedFlow failedNode;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public /* synthetic */ Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        @Override
        public Throwable fillInStackTrace() {
            return NoStackTrace.fillInStackTrace$((NoStackTrace)this);
        }

        public TableIdentifier datasetIdentifier() {
            return this.datasetIdentifier;
        }

        public ResolutionFailedFlow failedNode() {
            return this.failedNode;
        }

        public TransformNodeRetryableException copy(TableIdentifier datasetIdentifier, ResolutionFailedFlow failedNode) {
            return new TransformNodeRetryableException(datasetIdentifier, failedNode);
        }

        public TableIdentifier copy$default$1() {
            return this.datasetIdentifier();
        }

        public ResolutionFailedFlow copy$default$2() {
            return this.failedNode();
        }

        public String productPrefix() {
            return "TransformNodeRetryableException";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.datasetIdentifier();
                }
                case 1: {
                    return this.failedNode();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof TransformNodeRetryableException;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "datasetIdentifier";
                }
                case 1: {
                    return "failedNode";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 460780554, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof TransformNodeRetryableException)) return false;
            boolean bl = true;
            if (!bl) return false;
            TransformNodeRetryableException transformNodeRetryableException = (TransformNodeRetryableException)x$1;
            TableIdentifier tableIdentifier = this.datasetIdentifier();
            TableIdentifier tableIdentifier2 = transformNodeRetryableException.datasetIdentifier();
            if (tableIdentifier == null) {
                if (tableIdentifier2 != null) {
                    return false;
                }
            } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
            ResolutionFailedFlow resolutionFailedFlow = this.failedNode();
            ResolutionFailedFlow resolutionFailedFlow2 = transformNodeRetryableException.failedNode();
            if (resolutionFailedFlow == null) {
                if (resolutionFailedFlow2 != null) {
                    return false;
                }
            } else if (!resolutionFailedFlow.equals(resolutionFailedFlow2)) return false;
            if (!transformNodeRetryableException.canEqual(this)) return false;
            return true;
        }

        public TransformNodeRetryableException(TableIdentifier datasetIdentifier, ResolutionFailedFlow failedNode) {
            this.datasetIdentifier = datasetIdentifier;
            this.failedNode = failedNode;
            NoStackTrace.$init$((NoStackTrace)this);
            Product.$init$((Product)this);
        }
    }
}

