/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.core;

import com.yammer.metrics.core.Clock;
import com.yammer.metrics.core.Metered;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricProcessor;
import com.yammer.metrics.core.Stoppable;
import com.yammer.metrics.stats.EWMA;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class Meter
implements Metered,
Stoppable {
    private static final long INTERVAL = 5L;
    private final EWMA m1Rate = EWMA.oneMinuteEWMA();
    private final EWMA m5Rate = EWMA.fiveMinuteEWMA();
    private final EWMA m15Rate = EWMA.fifteenMinuteEWMA();
    private final AtomicLong count = new AtomicLong();
    private final long startTime;
    private final TimeUnit rateUnit;
    private final String eventType;
    private final ScheduledFuture<?> future;
    private final Clock clock;

    Meter(ScheduledExecutorService tickThread, String eventType, TimeUnit rateUnit, Clock clock) {
        this.rateUnit = rateUnit;
        this.eventType = eventType;
        this.future = tickThread.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                Meter.this.tick();
            }
        }, 5L, 5L, TimeUnit.SECONDS);
        this.clock = clock;
        this.startTime = this.clock.tick();
    }

    @Override
    public TimeUnit rateUnit() {
        return this.rateUnit;
    }

    @Override
    public String eventType() {
        return this.eventType;
    }

    void tick() {
        this.m1Rate.tick();
        this.m5Rate.tick();
        this.m15Rate.tick();
    }

    public void mark() {
        this.mark(1L);
    }

    public void mark(long n) {
        this.count.addAndGet(n);
        this.m1Rate.update(n);
        this.m5Rate.update(n);
        this.m15Rate.update(n);
    }

    @Override
    public long count() {
        return this.count.get();
    }

    @Override
    public double fifteenMinuteRate() {
        return this.m15Rate.rate(this.rateUnit);
    }

    @Override
    public double fiveMinuteRate() {
        return this.m5Rate.rate(this.rateUnit);
    }

    @Override
    public double meanRate() {
        if (this.count() == 0L) {
            return 0.0;
        }
        long elapsed = this.clock.tick() - this.startTime;
        return this.convertNsRate((double)this.count() / (double)elapsed);
    }

    @Override
    public double oneMinuteRate() {
        return this.m1Rate.rate(this.rateUnit);
    }

    private double convertNsRate(double ratePerNs) {
        return ratePerNs * (double)this.rateUnit.toNanos(1L);
    }

    @Override
    public void stop() {
        this.future.cancel(false);
    }

    @Override
    public <T> void processWith(MetricProcessor<T> processor, MetricName name, T context) throws Exception {
        processor.processMeter(name, this, context);
    }
}

