/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.shaded.framework.imps;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.curator.shaded.drivers.OperationTrace;
import org.apache.curator.shaded.framework.api.ChildrenDeletable;
import org.apache.curator.shaded.framework.api.CuratorEventType;
import org.apache.curator.shaded.framework.api.ErrorListenerPathable;
import org.apache.curator.shaded.framework.imps.BackgroundOperation;
import org.apache.curator.shaded.framework.imps.CreateBuilderImpl;
import org.apache.curator.shaded.framework.imps.CuratorEventImpl;
import org.apache.curator.shaded.framework.imps.CuratorFrameworkImpl;
import org.apache.curator.shaded.framework.imps.OperationAndData;
import org.apache.curator.shaded.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.curator.shaded.utils.ThreadUtils;
import org.apache.curator.shaded.utils.ZKPaths;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FindAndDeleteProtectedNodeInBackground
implements BackgroundOperation<Void> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorFrameworkImpl client;
    private final String namespaceAdjustedParentPath;
    private final String protectedId;
    @VisibleForTesting
    static final AtomicBoolean debugInsertError = new AtomicBoolean(false);

    FindAndDeleteProtectedNodeInBackground(CuratorFrameworkImpl client, String namespaceAdjustedParentPath, String protectedId) {
        this.client = client;
        this.namespaceAdjustedParentPath = namespaceAdjustedParentPath;
        this.protectedId = protectedId;
    }

    void execute() {
        OperationAndData.ErrorCallback<Void> errorCallback = new OperationAndData.ErrorCallback<Void>(){

            @Override
            public void retriesExhausted(OperationAndData<Void> operationAndData) {
                operationAndData.reset();
                FindAndDeleteProtectedNodeInBackground.this.client.processBackgroundOperation(operationAndData, null);
            }
        };
        OperationAndData<Void> operationAndData = new OperationAndData<Void>(this, null, null, errorCallback, null, null);
        this.client.processBackgroundOperation(operationAndData, null);
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<Void> operationAndData) throws Exception {
        final OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("FindAndDeleteProtectedNodeInBackground");
        AsyncCallback.Children2Callback callback = new AsyncCallback.Children2Callback(){

            @Override
            public void processResult(int rc, String path, Object o, List<String> strings, Stat stat) {
                String node;
                trace.setReturnCode(rc).setPath(path).setStat(stat).commit();
                if (debugInsertError.compareAndSet(true, false)) {
                    rc = KeeperException.Code.CONNECTIONLOSS.intValue();
                }
                if (rc == KeeperException.Code.OK.intValue() && (node = CreateBuilderImpl.findNode(strings, "/", FindAndDeleteProtectedNodeInBackground.this.protectedId)) != null) {
                    try {
                        String deletePath2 = FindAndDeleteProtectedNodeInBackground.this.client.unfixForNamespace(ZKPaths.makePath(FindAndDeleteProtectedNodeInBackground.this.namespaceAdjustedParentPath, node));
                        ((ErrorListenerPathable)((ChildrenDeletable)FindAndDeleteProtectedNodeInBackground.this.client.delete().guaranteed()).inBackground()).forPath(deletePath2);
                    }
                    catch (Exception e) {
                        ThreadUtils.checkInterrupted(e);
                        FindAndDeleteProtectedNodeInBackground.this.log.error("Could not start guaranteed delete for node: " + node);
                        rc = KeeperException.Code.CONNECTIONLOSS.intValue();
                    }
                }
                if (rc != KeeperException.Code.OK.intValue()) {
                    CuratorEventImpl event = new CuratorEventImpl(FindAndDeleteProtectedNodeInBackground.this.client, CuratorEventType.CHILDREN, rc, path, null, o, stat, null, strings, null, null, null);
                    FindAndDeleteProtectedNodeInBackground.this.client.processBackgroundOperation(operationAndData, event);
                }
            }
        };
        this.client.getZooKeeper().getChildren(this.namespaceAdjustedParentPath, false, callback, null);
    }
}

