/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io.checkpointing;

import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointFailureReason;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.io.network.api.CancelCheckpointMarker;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.partition.consumer.CheckpointableInput;
import org.apache.flink.runtime.jobgraph.tasks.CheckpointableTask;
import org.apache.flink.streaming.runtime.io.checkpointing.AlternatingWaitingForFirstBarrier;
import org.apache.flink.streaming.runtime.io.checkpointing.AlternatingWaitingForFirstBarrierUnaligned;
import org.apache.flink.streaming.runtime.io.checkpointing.BarrierHandlerState;
import org.apache.flink.streaming.runtime.io.checkpointing.ChannelState;
import org.apache.flink.streaming.runtime.io.checkpointing.CheckpointBarrierHandler;
import org.apache.flink.streaming.runtime.io.checkpointing.WaitingForFirstBarrier;
import org.apache.flink.streaming.runtime.tasks.SubtaskCheckpointCoordinator;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.concurrent.FutureUtils;
import org.apache.flink.util.function.FunctionWithException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
@NotThreadSafe
public class SingleCheckpointBarrierHandler
extends CheckpointBarrierHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SingleCheckpointBarrierHandler.class);
    private final String taskName;
    private final ControllerImpl context;
    private final BiFunction<Callable<?>, Duration, CheckpointBarrierHandler.Cancellable> registerTimer;
    private final SubtaskCheckpointCoordinator subTaskCheckpointCoordinator;
    private final CheckpointableInput[] inputs;
    private long currentCheckpointId = -1L;
    @Nullable
    private CheckpointBarrier pendingCheckpointBarrier;
    private final Set<InputChannelInfo> alignedChannels = new HashSet<InputChannelInfo>();
    private int targetChannelCount;
    private long lastCancelledOrCompletedCheckpointId = -1L;
    private int numOpenChannels;
    private CompletableFuture<Void> allBarriersReceivedFuture = new CompletableFuture();
    private BarrierHandlerState currentState;
    private CheckpointBarrierHandler.Cancellable currentAlignmentTimer;
    private final boolean alternating;

    @VisibleForTesting
    public static SingleCheckpointBarrierHandler createUnalignedCheckpointBarrierHandler(SubtaskCheckpointCoordinator checkpointCoordinator, String taskName, CheckpointableTask toNotifyOnCheckpoint, Clock clock, boolean enableCheckpointsAfterTasksFinish, CheckpointableInput ... inputs) {
        return SingleCheckpointBarrierHandler.unaligned(taskName, toNotifyOnCheckpoint, checkpointCoordinator, clock, (int)Arrays.stream(inputs).flatMap(gate -> gate.getChannelInfos().stream()).count(), (callable, duration) -> {
            throw new IllegalStateException("Strictly unaligned checkpoints should never register any callbacks");
        }, enableCheckpointsAfterTasksFinish, inputs);
    }

    public static SingleCheckpointBarrierHandler unaligned(String taskName, CheckpointableTask toNotifyOnCheckpoint, SubtaskCheckpointCoordinator checkpointCoordinator, Clock clock, int numOpenChannels, BiFunction<Callable<?>, Duration, CheckpointBarrierHandler.Cancellable> registerTimer, boolean enableCheckpointAfterTasksFinished, CheckpointableInput ... inputs) {
        return new SingleCheckpointBarrierHandler(taskName, toNotifyOnCheckpoint, checkpointCoordinator, clock, numOpenChannels, new AlternatingWaitingForFirstBarrierUnaligned(false, new ChannelState(inputs)), false, registerTimer, inputs, enableCheckpointAfterTasksFinished);
    }

    public static SingleCheckpointBarrierHandler aligned(String taskName, CheckpointableTask toNotifyOnCheckpoint, Clock clock, int numOpenChannels, BiFunction<Callable<?>, Duration, CheckpointBarrierHandler.Cancellable> registerTimer, boolean enableCheckpointAfterTasksFinished, CheckpointableInput ... inputs) {
        return new SingleCheckpointBarrierHandler(taskName, toNotifyOnCheckpoint, null, clock, numOpenChannels, new WaitingForFirstBarrier(inputs), false, registerTimer, inputs, enableCheckpointAfterTasksFinished);
    }

    public static SingleCheckpointBarrierHandler alternating(String taskName, CheckpointableTask toNotifyOnCheckpoint, SubtaskCheckpointCoordinator checkpointCoordinator, Clock clock, int numOpenChannels, BiFunction<Callable<?>, Duration, CheckpointBarrierHandler.Cancellable> registerTimer, boolean enableCheckpointAfterTasksFinished, CheckpointableInput ... inputs) {
        return new SingleCheckpointBarrierHandler(taskName, toNotifyOnCheckpoint, checkpointCoordinator, clock, numOpenChannels, new AlternatingWaitingForFirstBarrier(new ChannelState(inputs)), true, registerTimer, inputs, enableCheckpointAfterTasksFinished);
    }

    private SingleCheckpointBarrierHandler(String taskName, CheckpointableTask toNotifyOnCheckpoint, @Nullable SubtaskCheckpointCoordinator subTaskCheckpointCoordinator, Clock clock, int numOpenChannels, BarrierHandlerState currentState, boolean alternating, BiFunction<Callable<?>, Duration, CheckpointBarrierHandler.Cancellable> registerTimer, CheckpointableInput[] inputs, boolean enableCheckpointAfterTasksFinished) {
        super(toNotifyOnCheckpoint, clock, enableCheckpointAfterTasksFinished);
        this.taskName = taskName;
        this.numOpenChannels = numOpenChannels;
        this.currentState = currentState;
        this.alternating = alternating;
        this.registerTimer = registerTimer;
        this.subTaskCheckpointCoordinator = subTaskCheckpointCoordinator;
        this.context = new ControllerImpl();
        this.inputs = inputs;
    }

    @Override
    public void processBarrier(CheckpointBarrier barrier, InputChannelInfo channelInfo, boolean isRpcTriggered) throws IOException {
        long barrierId = barrier.getId();
        LOG.debug("{}: Received barrier from channel {} @ {}.", new Object[]{this.taskName, channelInfo, barrierId});
        if (this.currentCheckpointId > barrierId || this.currentCheckpointId == barrierId && !this.isCheckpointPending()) {
            if (!barrier.getCheckpointOptions().isUnalignedCheckpoint()) {
                this.inputs[channelInfo.getGateIdx()].resumeConsumption(channelInfo);
            }
            return;
        }
        this.checkNewCheckpoint(barrier);
        Preconditions.checkState((this.currentCheckpointId == barrierId ? 1 : 0) != 0);
        this.markCheckpointAlignedAndTransformState(channelInfo, barrier, (FunctionWithException<BarrierHandlerState, BarrierHandlerState, Exception>)((FunctionWithException)state -> state.barrierReceived(this.context, channelInfo, barrier, !isRpcTriggered)));
    }

    protected void markCheckpointAlignedAndTransformState(InputChannelInfo alignedChannel, CheckpointBarrier barrier, FunctionWithException<BarrierHandlerState, BarrierHandlerState, Exception> stateTransformer) throws IOException {
        this.alignedChannels.add(alignedChannel);
        if (this.alignedChannels.size() == 1) {
            if (this.targetChannelCount == 1) {
                this.markAlignmentStartAndEnd(barrier.getId(), barrier.getTimestamp());
            } else {
                this.markAlignmentStart(barrier.getId(), barrier.getTimestamp());
            }
        }
        if (this.alignedChannels.size() == this.targetChannelCount && this.targetChannelCount > 1) {
            this.markAlignmentEnd();
        }
        try {
            this.currentState = (BarrierHandlerState)stateTransformer.apply((Object)this.currentState);
        }
        catch (CheckpointException e) {
            this.abortInternal(this.currentCheckpointId, e);
        }
        catch (Exception e) {
            ExceptionUtils.rethrowIOException((Throwable)e);
        }
        if (this.alignedChannels.size() == this.targetChannelCount) {
            this.alignedChannels.clear();
            this.lastCancelledOrCompletedCheckpointId = this.currentCheckpointId;
            LOG.debug("{}: All the channels are aligned for checkpoint {}.", (Object)this.taskName, (Object)this.currentCheckpointId);
            this.resetAlignmentTimer();
            this.allBarriersReceivedFuture.complete(null);
        }
    }

    private void triggerCheckpoint(CheckpointBarrier trigger) throws IOException {
        LOG.debug("{}: Triggering checkpoint {} on the barrier announcement at {}.", new Object[]{this.taskName, trigger.getId(), trigger.getTimestamp()});
        this.notifyCheckpoint(trigger);
    }

    @Override
    public void processBarrierAnnouncement(CheckpointBarrier announcedBarrier, int sequenceNumber, InputChannelInfo channelInfo) throws IOException {
        this.checkNewCheckpoint(announcedBarrier);
        long barrierId = announcedBarrier.getId();
        if (this.currentCheckpointId > barrierId || this.currentCheckpointId == barrierId && !this.isCheckpointPending()) {
            LOG.debug("{}: Obsolete announcement of checkpoint {} for channel {}.", new Object[]{this.taskName, barrierId, channelInfo});
            return;
        }
        this.currentState = this.currentState.announcementReceived(this.context, channelInfo, sequenceNumber);
    }

    private void registerAlignmentTimer(CheckpointBarrier announcedBarrier) {
        long alignedCheckpointTimeout = announcedBarrier.getCheckpointOptions().getAlignedCheckpointTimeout();
        long timePassedSinceCheckpointStart = this.getClock().absoluteTimeMillis() - announcedBarrier.getTimestamp();
        long timerDelay = Math.max(alignedCheckpointTimeout - timePassedSinceCheckpointStart, 0L);
        this.currentAlignmentTimer = this.registerTimer.apply(() -> {
            long barrierId = announcedBarrier.getId();
            try {
                if (this.currentCheckpointId == barrierId && !this.getAllBarriersReceivedFuture(barrierId).isDone()) {
                    this.currentState = this.currentState.alignmentTimeout(this.context, announcedBarrier);
                }
            }
            catch (CheckpointException ex) {
                this.abortInternal(barrierId, ex);
            }
            catch (Exception e) {
                ExceptionUtils.rethrowIOException((Throwable)e);
            }
            this.currentAlignmentTimer = null;
            return null;
        }, Duration.ofMillis(timerDelay));
    }

    private void checkNewCheckpoint(CheckpointBarrier barrier) throws IOException {
        long barrierId = barrier.getId();
        if (this.currentCheckpointId >= barrierId) {
            return;
        }
        if (this.isCheckpointPending()) {
            this.cancelSubsumedCheckpoint(barrierId);
        }
        this.currentCheckpointId = barrierId;
        this.pendingCheckpointBarrier = barrier;
        this.alignedChannels.clear();
        this.targetChannelCount = this.numOpenChannels;
        this.allBarriersReceivedFuture = new CompletableFuture();
        if (this.alternating && barrier.getCheckpointOptions().isTimeoutable()) {
            this.registerAlignmentTimer(barrier);
        }
    }

    @Override
    public void processCancellationBarrier(CancelCheckpointMarker cancelBarrier, InputChannelInfo channelInfo) throws IOException {
        long cancelledId = cancelBarrier.getCheckpointId();
        if (cancelledId > this.currentCheckpointId || cancelledId == this.currentCheckpointId && this.alignedChannels.size() > 0) {
            LOG.debug("{}: Received cancellation {}.", (Object)this.taskName, (Object)cancelledId);
            this.abortInternal(cancelledId, new CheckpointException(CheckpointFailureReason.CHECKPOINT_DECLINED_ON_CANCELLATION_BARRIER));
        }
    }

    private void abortInternal(long cancelledId, CheckpointFailureReason reason) throws IOException {
        this.abortInternal(cancelledId, new CheckpointException(reason));
    }

    private void abortInternal(long cancelledId, CheckpointException exception) throws IOException {
        LOG.debug("{}: Aborting checkpoint {} after exception {}.", new Object[]{this.taskName, this.currentCheckpointId, exception});
        this.currentCheckpointId = Math.max(cancelledId, this.currentCheckpointId);
        this.lastCancelledOrCompletedCheckpointId = Math.max(this.lastCancelledOrCompletedCheckpointId, cancelledId);
        this.pendingCheckpointBarrier = null;
        this.alignedChannels.clear();
        this.targetChannelCount = 0;
        this.resetAlignmentTimer();
        this.currentState = this.currentState.abort(cancelledId);
        if (cancelledId == this.currentCheckpointId) {
            this.resetAlignment();
        }
        this.notifyAbort(cancelledId, exception);
        this.allBarriersReceivedFuture.completeExceptionally(exception);
    }

    private void resetAlignmentTimer() {
        if (this.currentAlignmentTimer != null) {
            this.currentAlignmentTimer.cancel();
            this.currentAlignmentTimer = null;
        }
    }

    @Override
    public void processEndOfPartition(InputChannelInfo channelInfo) throws IOException {
        --this.numOpenChannels;
        if (!this.isCheckpointAfterTasksFinishedEnabled()) {
            if (this.isCheckpointPending()) {
                LOG.warn("{}: Received EndOfPartition(-1) before completing current checkpoint {}. Skipping current checkpoint.", (Object)this.taskName, (Object)this.currentCheckpointId);
                this.abortInternal(this.currentCheckpointId, CheckpointFailureReason.CHECKPOINT_DECLINED_INPUT_END_OF_STREAM);
            }
        } else {
            if (!this.isCheckpointPending()) {
                return;
            }
            Preconditions.checkState((this.pendingCheckpointBarrier != null ? 1 : 0) != 0, (Object)"pending checkpoint barrier should not be null when there is pending checkpoint.");
            this.markCheckpointAlignedAndTransformState(channelInfo, this.pendingCheckpointBarrier, (FunctionWithException<BarrierHandlerState, BarrierHandlerState, Exception>)((FunctionWithException)state -> state.endOfPartitionReceived(this.context, channelInfo)));
        }
    }

    @Override
    public long getLatestCheckpointId() {
        return this.currentCheckpointId;
    }

    @Override
    public void close() throws IOException {
        this.resetAlignmentTimer();
        this.allBarriersReceivedFuture.cancel(false);
        super.close();
    }

    @Override
    protected boolean isCheckpointPending() {
        return this.currentCheckpointId != this.lastCancelledOrCompletedCheckpointId && this.currentCheckpointId >= 0L;
    }

    private void cancelSubsumedCheckpoint(long barrierId) throws IOException {
        LOG.warn("{}: Received checkpoint barrier for checkpoint {} before completing current checkpoint {}. Skipping current checkpoint.", new Object[]{this.taskName, barrierId, this.currentCheckpointId});
        this.abortInternal(this.currentCheckpointId, CheckpointFailureReason.CHECKPOINT_DECLINED_SUBSUMED);
    }

    @Override
    public CompletableFuture<Void> getAllBarriersReceivedFuture(long checkpointId) {
        if (checkpointId < this.currentCheckpointId || this.numOpenChannels == 0) {
            return FutureUtils.completedVoidFuture();
        }
        if (checkpointId > this.currentCheckpointId) {
            throw new IllegalStateException("Checkpoint " + checkpointId + " has not been started at all");
        }
        return this.allBarriersReceivedFuture;
    }

    @VisibleForTesting
    int getNumOpenChannels() {
        return this.numOpenChannels;
    }

    public String toString() {
        return String.format("%s: current checkpoint: %d, current aligned channels: %d, target channel count: %d", this.taskName, this.currentCheckpointId, this.alignedChannels.size(), this.targetChannelCount);
    }

    private final class ControllerImpl
    implements BarrierHandlerState.Controller {
        private ControllerImpl() {
        }

        @Override
        public void triggerGlobalCheckpoint(CheckpointBarrier checkpointBarrier) throws IOException {
            SingleCheckpointBarrierHandler.this.triggerCheckpoint(checkpointBarrier);
        }

        @Override
        public boolean isTimedOut(CheckpointBarrier barrier) {
            return barrier.getCheckpointOptions().isTimeoutable() && barrier.getId() <= SingleCheckpointBarrierHandler.this.currentCheckpointId && barrier.getCheckpointOptions().getAlignedCheckpointTimeout() < SingleCheckpointBarrierHandler.this.getClock().absoluteTimeMillis() - barrier.getTimestamp();
        }

        @Override
        public boolean allBarriersReceived() {
            return SingleCheckpointBarrierHandler.this.alignedChannels.size() == SingleCheckpointBarrierHandler.this.targetChannelCount;
        }

        @Override
        @Nullable
        public CheckpointBarrier getPendingCheckpointBarrier() {
            return SingleCheckpointBarrierHandler.this.pendingCheckpointBarrier;
        }

        @Override
        public void initInputsCheckpoint(CheckpointBarrier checkpointBarrier) throws CheckpointException {
            Preconditions.checkState((SingleCheckpointBarrierHandler.this.subTaskCheckpointCoordinator != null ? 1 : 0) != 0);
            long barrierId = checkpointBarrier.getId();
            SingleCheckpointBarrierHandler.this.subTaskCheckpointCoordinator.initInputsCheckpoint(barrierId, checkpointBarrier.getCheckpointOptions());
        }
    }
}

