/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.service.alert.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.exception.AlertException;
import org.apache.streampark.console.base.mybatis.pager.MybatisPager;
import org.apache.streampark.console.core.bean.AlertConfigWithParams;
import org.apache.streampark.console.core.entity.AlertConfig;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.mapper.AlertConfigMapper;
import org.apache.streampark.console.core.service.ApplicationService;
import org.apache.streampark.console.core.service.alert.AlertConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.SUPPORTS, readOnly=true, rollbackFor={Exception.class})
public class AlertConfigServiceImpl
extends ServiceImpl<AlertConfigMapper, AlertConfig>
implements AlertConfigService {
    private static final Logger log = LoggerFactory.getLogger(AlertConfigServiceImpl.class);
    @Autowired
    private ApplicationService applicationService;

    @Override
    public IPage<AlertConfigWithParams> page(AlertConfigWithParams params, RestRequest request) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(params.getUserId() != null, AlertConfig::getUserId, (Object)params.getUserId());
        Page page = new MybatisPager().getDefaultPage(request);
        IPage resultPage = ((AlertConfigMapper)this.getBaseMapper()).selectPage((IPage)page, (Wrapper)wrapper);
        Page result = new Page();
        if (CollectionUtils.isNotEmpty((Collection)resultPage.getRecords())) {
            result.setRecords(resultPage.getRecords().stream().map(AlertConfigWithParams::of).collect(Collectors.toList()));
        }
        return result;
    }

    @Override
    public boolean exist(AlertConfig alertConfig) {
        AlertConfig confByName = ((AlertConfigMapper)this.baseMapper).getAlertConfByName(alertConfig);
        return confByName != null;
    }

    @Override
    public boolean deleteById(Long id) throws AlertException {
        long count = this.applicationService.count((Wrapper)new LambdaQueryWrapper().eq(id != null, Application::getAlertId, (Object)id));
        if (count > 0L) {
            throw new AlertException(String.format("AlertId:%d, this is bound by application. Please clear the configuration first", id));
        }
        return this.removeById(id);
    }
}

