/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.plexus.annotations;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import org.codehaus.plexus.component.annotations.Requirement;
import org.sonatype.guice.bean.reflect.DeferredClass;
import org.sonatype.guice.bean.reflect.LoadedClass;
import org.sonatype.guice.plexus.config.Hints;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RequirementImpl
implements Requirement {
    private final DeferredClass<?> role;
    private final boolean optional;
    private final String hint;
    private final String[] hints;

    public RequirementImpl(DeferredClass<?> role, boolean optional, List<String> hints) {
        if (null == role || null == hints || hints.contains(null)) {
            throw new IllegalArgumentException("@Requirement cannot contain null values");
        }
        this.role = role;
        this.optional = optional;
        int length = hints.size();
        if (length == 0) {
            this.hint = "";
            this.hints = Hints.NO_HINTS;
        } else if (length == 1) {
            this.hint = hints.get(0);
            this.hints = Hints.NO_HINTS;
        } else {
            this.hint = "";
            this.hints = hints.toArray(new String[length]);
        }
    }

    @Deprecated
    public RequirementImpl(Class<?> role, boolean optional, String ... hints) {
        this((DeferredClass<?>)new LoadedClass(role), optional, Arrays.asList(hints));
    }

    public Class<?> role() {
        return this.role.load();
    }

    public boolean optional() {
        return this.optional;
    }

    public String hint() {
        return this.hint;
    }

    public String[] hints() {
        return (String[])this.hints.clone();
    }

    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (rhs instanceof Requirement) {
            Requirement req = (Requirement)rhs;
            return this.role().equals(req.role()) && this.optional == req.optional() && this.hint.equals(req.hint()) && Arrays.equals(this.hints, req.hints());
        }
        return false;
    }

    public int hashCode() {
        return (127 * "role".hashCode() ^ this.role().hashCode()) + (127 * "optional".hashCode() ^ Boolean.valueOf(this.optional).hashCode()) + (127 * "hint".hashCode() ^ this.hint.hashCode()) + (127 * "hints".hashCode() ^ Arrays.hashCode(this.hints));
    }

    public String toString() {
        return String.format("@%s(hints=%s, optional=%b, role=%s, hint=%s)", Requirement.class.getName(), Arrays.toString(this.hints), this.optional, this.role(), this.hint);
    }

    public Class<? extends Annotation> annotationType() {
        return Requirement.class;
    }
}

