/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.source;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.eventtime.WatermarkOutput;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.io.PushingAsyncDataInput;
import org.apache.flink.streaming.runtime.tasks.ExceptionInChainedOperatorException;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;
import org.apache.flink.util.Preconditions;

@Internal
public final class WatermarkToDataOutput
implements WatermarkOutput {
    private final PushingAsyncDataInput.DataOutput<?> output;
    private long maxWatermarkSoFar;
    private boolean isIdle;

    public WatermarkToDataOutput(PushingAsyncDataInput.DataOutput<?> output) {
        this.output = (PushingAsyncDataInput.DataOutput)Preconditions.checkNotNull(output);
        this.maxWatermarkSoFar = Long.MIN_VALUE;
    }

    public void emitWatermark(org.apache.flink.api.common.eventtime.Watermark watermark) {
        long newWatermark = watermark.getTimestamp();
        if (newWatermark <= this.maxWatermarkSoFar) {
            return;
        }
        this.maxWatermarkSoFar = newWatermark;
        try {
            this.markActiveInternally();
            this.output.emitWatermark(new Watermark(newWatermark));
        }
        catch (ExceptionInChainedOperatorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExceptionInChainedOperatorException(e);
        }
    }

    public void markIdle() {
        if (this.isIdle) {
            return;
        }
        try {
            this.output.emitWatermarkStatus(WatermarkStatus.IDLE);
            this.isIdle = true;
        }
        catch (ExceptionInChainedOperatorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExceptionInChainedOperatorException(e);
        }
    }

    public void markActive() {
        try {
            this.markActiveInternally();
        }
        catch (ExceptionInChainedOperatorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExceptionInChainedOperatorException(e);
        }
    }

    private boolean markActiveInternally() throws Exception {
        if (!this.isIdle) {
            return true;
        }
        this.output.emitWatermarkStatus(WatermarkStatus.ACTIVE);
        this.isIdle = false;
        return false;
    }
}

