/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.checkpoint.CheckpointMetaData;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.CheckpointType;
import org.apache.flink.runtime.execution.CancelTaskException;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.apache.flink.streaming.api.checkpoint.ExternallyInducedSource;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.operators.StreamSource;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.streaming.runtime.tasks.StreamTaskActionExecutor;
import org.apache.flink.streaming.runtime.tasks.mailbox.MailboxDefaultAction;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FatalExitExceptionHandler;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;

@Internal
public class SourceStreamTask<OUT, SRC extends SourceFunction<OUT>, OP extends StreamSource<OUT, SRC>>
extends StreamTask<OUT, OP> {
    private final LegacySourceFunctionThread sourceThread;
    private final Object lock;
    private volatile boolean externallyInducedCheckpoints;
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private volatile FinishingReason finishingReason = FinishingReason.END_OF_DATA;

    public SourceStreamTask(Environment env) throws Exception {
        this(env, new Object());
    }

    private SourceStreamTask(Environment env, Object lock) throws Exception {
        super(env, null, (Thread.UncaughtExceptionHandler)FatalExitExceptionHandler.INSTANCE, StreamTaskActionExecutor.synchronizedExecutor(lock));
        this.lock = Preconditions.checkNotNull((Object)lock);
        this.sourceThread = new LegacySourceFunctionThread();
        this.getEnvironment().getMetricGroup().getIOMetricGroup().setEnableBusyTime(false);
    }

    @Override
    protected void init() {
        SourceFunction source = (SourceFunction)((StreamSource)this.mainOperator).getUserFunction();
        if (source instanceof ExternallyInducedSource) {
            this.externallyInducedCheckpoints = true;
            ExternallyInducedSource.CheckpointTrigger triggerHook = new ExternallyInducedSource.CheckpointTrigger(){

                @Override
                public void triggerCheckpoint(long checkpointId) throws FlinkException {
                    CheckpointOptions checkpointOptions = CheckpointOptions.forConfig((CheckpointType)CheckpointType.CHECKPOINT, (CheckpointStorageLocationReference)CheckpointStorageLocationReference.getDefault(), (boolean)SourceStreamTask.this.configuration.isExactlyOnceCheckpointMode(), (boolean)SourceStreamTask.this.configuration.isUnalignedCheckpointsEnabled(), (long)SourceStreamTask.this.configuration.getAlignedCheckpointTimeout().toMillis());
                    long timestamp = System.currentTimeMillis();
                    CheckpointMetaData checkpointMetaData = new CheckpointMetaData(checkpointId, timestamp, timestamp);
                    try {
                        SourceStreamTask.super.triggerCheckpointAsync(checkpointMetaData, checkpointOptions).get();
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new FlinkException(e.getMessage(), (Throwable)e);
                    }
                }
            };
            ((ExternallyInducedSource)source).setCheckpointTrigger(triggerHook);
        }
        this.getEnvironment().getMetricGroup().getIOMetricGroup().gauge("checkpointStartDelayNanos", this::getAsyncCheckpointStartDelayNanos);
    }

    @Override
    protected void advanceToEndOfEventTime() throws Exception {
        this.operatorChain.getMainOperatorOutput().emitWatermark(Watermark.MAX_WATERMARK);
    }

    @Override
    protected void cleanUpInternal() {
    }

    @Override
    protected void processInput(MailboxDefaultAction.Controller controller) throws Exception {
        controller.suspendDefaultAction();
        this.sourceThread.setTaskDescription(this.getName());
        this.sourceThread.start();
        this.sourceThread.getCompletionFuture().whenComplete((ignore, sourceThreadThrowable) -> {
            if (sourceThreadThrowable != null) {
                this.mailboxProcessor.reportThrowable((Throwable)sourceThreadThrowable);
            } else {
                this.mailboxProcessor.suspend();
            }
        });
    }

    @Override
    protected void cancelTask() {
        if (this.stopped.compareAndSet(false, true)) {
            if (this.isFailing()) {
                this.interruptSourceThread(true);
            }
            this.cancelOperator(true);
        }
    }

    @Override
    protected void finishTask() {
        this.finishingReason = FinishingReason.STOP_WITH_SAVEPOINT_NO_DRAIN;
        this.cancelOperator(false);
    }

    private void cancelOperator(boolean interruptThread) {
        try {
            if (this.mainOperator != null) {
                ((StreamSource)this.mainOperator).cancel();
            }
        }
        finally {
            this.interruptSourceThread(interruptThread);
        }
    }

    private void interruptSourceThread(boolean interrupt) {
        if (this.operatorChain != null && this.operatorChain.isTaskDeployedAsFinished()) {
            return;
        }
        if (this.sourceThread.isAlive()) {
            if (interrupt) {
                this.sourceThread.interrupt();
            }
        } else if (!this.sourceThread.getCompletionFuture().isDone()) {
            this.sourceThread.getCompletionFuture().complete(null);
        }
    }

    @Override
    protected CompletableFuture<Void> getCompletionFuture() {
        return this.sourceThread.getCompletionFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Boolean> triggerCheckpointAsync(CheckpointMetaData checkpointMetaData, CheckpointOptions checkpointOptions) {
        if (!this.externallyInducedCheckpoints) {
            if (checkpointOptions.getCheckpointType().shouldDrain()) {
                return this.triggerStopWithSavepointWithDrainAsync(checkpointMetaData, checkpointOptions);
            }
            return super.triggerCheckpointAsync(checkpointMetaData, checkpointOptions);
        }
        Object object = this.lock;
        synchronized (object) {
            return CompletableFuture.completedFuture(this.isRunning());
        }
    }

    private CompletableFuture<Boolean> triggerStopWithSavepointWithDrainAsync(CheckpointMetaData checkpointMetaData, CheckpointOptions checkpointOptions) {
        this.mainMailboxExecutor.execute(() -> this.stopOperatorForStopWithSavepointWithDrain(checkpointMetaData.getCheckpointId()), "stop legacy source for stop-with-savepoint --drain");
        return this.assertTriggeringCheckpointExceptions((CompletableFuture<Boolean>)this.sourceThread.getCompletionFuture().thenCompose(ignore -> super.triggerCheckpointAsync(checkpointMetaData, checkpointOptions)), checkpointMetaData.getCheckpointId());
    }

    private void stopOperatorForStopWithSavepointWithDrain(long checkpointId) {
        this.setSynchronousSavepoint(checkpointId, true);
        this.finishingReason = FinishingReason.STOP_WITH_SAVEPOINT_DRAIN;
        if (this.mainOperator != null) {
            ((StreamSource)this.mainOperator).stop();
        }
    }

    @Override
    protected void declineCheckpoint(long checkpointId) {
        if (!this.externallyInducedCheckpoints) {
            super.declineCheckpoint(checkpointId);
        }
    }

    private class LegacySourceFunctionThread
    extends Thread {
        private final CompletableFuture<Void> completionFuture = new CompletableFuture();

        LegacySourceFunctionThread() {
        }

        @Override
        public void run() {
            try {
                if (!SourceStreamTask.this.operatorChain.isTaskDeployedAsFinished()) {
                    StreamTask.LOG.debug("Legacy source {} skip execution since the task is finished on restore", (Object)SourceStreamTask.this.getTaskNameWithSubtaskAndId());
                    ((StreamSource)SourceStreamTask.this.mainOperator).run(SourceStreamTask.this.lock, SourceStreamTask.this.operatorChain);
                }
                this.completeProcessing();
                this.completionFuture.complete(null);
            }
            catch (Throwable t) {
                if (SourceStreamTask.this.isCanceled() && ExceptionUtils.findThrowable((Throwable)t, InterruptedException.class).isPresent()) {
                    this.completionFuture.completeExceptionally((Throwable)new CancelTaskException(t));
                }
                if (SourceStreamTask.this.finishingReason == FinishingReason.STOP_WITH_SAVEPOINT_NO_DRAIN) {
                    this.completionFuture.complete(null);
                }
                this.completionFuture.completeExceptionally(t);
            }
        }

        private void completeProcessing() throws InterruptedException, ExecutionException {
            if (SourceStreamTask.this.finishingReason.shouldCallFinish() && !SourceStreamTask.this.isCanceled() && !SourceStreamTask.this.isFailing()) {
                SourceStreamTask.this.mainMailboxExecutor.submit(() -> {
                    SourceStreamTask.this.operatorChain.endInput(1);
                    SourceStreamTask.this.endData();
                }, "SourceStreamTask finished processing data.").get();
            }
        }

        public void setTaskDescription(String taskDescription) {
            this.setName("Legacy Source Thread - " + taskDescription);
        }

        CompletableFuture<Void> getCompletionFuture() {
            return SourceStreamTask.this.isFailing() && !this.isAlive() ? CompletableFuture.completedFuture(null) : this.completionFuture;
        }
    }

    private static enum FinishingReason {
        END_OF_DATA(true),
        STOP_WITH_SAVEPOINT_DRAIN(true),
        STOP_WITH_SAVEPOINT_NO_DRAIN(false);

        private final boolean shouldCallFinish;

        private FinishingReason(boolean shouldCallFinish) {
            this.shouldCallFinish = shouldCallFinish;
        }

        boolean shouldCallFinish() {
            return this.shouldCallFinish;
        }
    }
}

