/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.service.alert.impl;

import freemarker.template.Template;
import java.util.HashMap;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.apache.commons.mail.HtmlEmail;
import org.apache.streampark.console.base.exception.AlertException;
import org.apache.streampark.console.base.util.FreemarkerUtils;
import org.apache.streampark.console.core.bean.AlertConfigWithParams;
import org.apache.streampark.console.core.bean.AlertTemplate;
import org.apache.streampark.console.core.bean.SenderEmail;
import org.apache.streampark.console.core.service.SettingService;
import org.apache.streampark.console.core.service.alert.AlertNotifyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
@Lazy
public class EmailAlertNotifyServiceImpl
implements AlertNotifyService {
    private static final Logger log = LoggerFactory.getLogger(EmailAlertNotifyServiceImpl.class);
    private Template template;
    @Autowired
    private SettingService settingService;

    @PostConstruct
    public void loadTemplateFile() throws Exception {
        String template = "alert-email.ftl";
        this.template = FreemarkerUtils.loadTemplateFile(template);
    }

    @Override
    public boolean doAlert(AlertConfigWithParams alertConfig, AlertTemplate template) throws AlertException {
        String contacts;
        SenderEmail senderEmail = Optional.ofNullable(this.settingService.getSenderEmail()).orElseThrow(() -> new AlertException("Please configure first mail sender"));
        String string = contacts = alertConfig.getEmailParams() == null ? null : alertConfig.getEmailParams().getContacts();
        if (!StringUtils.hasLength((String)contacts)) {
            throw new AlertException("Please configure a valid contacts");
        }
        String[] emails = contacts.split(",");
        return this.sendEmail(senderEmail, template, emails);
    }

    private boolean sendEmail(SenderEmail senderEmail, AlertTemplate mail, String ... mails) throws AlertException {
        log.info(mail.getSubject());
        try {
            HashMap<String, AlertTemplate> out = new HashMap<String, AlertTemplate>(16);
            out.put("mail", mail);
            String html = FreemarkerUtils.format(this.template, out);
            HtmlEmail htmlEmail = new HtmlEmail();
            htmlEmail.setCharset("UTF-8");
            htmlEmail.setHostName(senderEmail.getSmtpHost());
            htmlEmail.setAuthentication(senderEmail.getUserName(), senderEmail.getPassword());
            htmlEmail.setFrom(senderEmail.getFrom());
            if (senderEmail.isSsl()) {
                htmlEmail.setSSLCheckServerIdentity(true);
                htmlEmail.setSSLOnConnect(true);
                htmlEmail.setSslSmtpPort(senderEmail.getSmtpPort().toString());
            } else {
                htmlEmail.setSmtpPort(senderEmail.getSmtpPort().intValue());
            }
            htmlEmail.setSubject(mail.getSubject());
            htmlEmail.setHtmlMsg(html);
            htmlEmail.addTo(mails);
            htmlEmail.send();
            return true;
        }
        catch (Exception e) {
            throw new AlertException("Failed send email alert", e);
        }
    }
}

