/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.streampark.common.conf.CommonConfig;
import org.apache.streampark.common.conf.InternalConfigHolder;
import org.apache.streampark.common.conf.InternalOption;
import org.apache.streampark.console.core.bean.SenderEmail;
import org.apache.streampark.console.core.entity.Setting;
import org.apache.streampark.console.core.mapper.SettingMapper;
import org.apache.streampark.console.core.service.SettingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.SUPPORTS, readOnly=true, rollbackFor={Exception.class})
public class SettingServiceImpl
extends ServiceImpl<SettingMapper, Setting>
implements SettingService,
ApplicationListener<ContextRefreshedEvent> {
    private static final Logger log = LoggerFactory.getLogger(SettingServiceImpl.class);
    private final Setting emptySetting = new Setting();

    @Override
    public Setting get(String key) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(Setting::getSettingKey, (Object)key);
        return (Setting)this.getOne((Wrapper)queryWrapper);
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        List settingList = super.list();
        settingList.forEach(x -> SETTINGS.put(x.getSettingKey(), x));
    }

    @Override
    public boolean update(Setting setting) {
        try {
            String value = StringUtils.trimToNull((String)setting.getSettingValue());
            setting.setSettingValue(value);
            Setting entity = new Setting();
            entity.setSettingValue(setting.getSettingValue());
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(Setting::getSettingKey, (Object)setting.getSettingKey());
            this.update(entity, (Wrapper)queryWrapper);
            String settingKey = setting.getSettingKey();
            if (CommonConfig.MAVEN_SETTINGS_PATH().key().equals(settingKey)) {
                InternalConfigHolder.set((InternalOption)CommonConfig.MAVEN_SETTINGS_PATH(), (Object)value);
            }
            if (CommonConfig.MAVEN_REMOTE_URL().key().equals(settingKey)) {
                InternalConfigHolder.set((InternalOption)CommonConfig.MAVEN_REMOTE_URL(), (Object)value);
            }
            if (CommonConfig.MAVEN_AUTH_USER().key().equals(settingKey)) {
                InternalConfigHolder.set((InternalOption)CommonConfig.MAVEN_AUTH_USER(), (Object)value);
            }
            if (CommonConfig.MAVEN_AUTH_PASSWORD().key().equals(settingKey)) {
                InternalConfigHolder.set((InternalOption)CommonConfig.MAVEN_AUTH_PASSWORD(), (Object)value);
            }
            Optional optional = Optional.ofNullable(SETTINGS.get(setting.getSettingKey()));
            optional.ifPresent(x -> x.setSettingValue(value));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public SenderEmail getSenderEmail() {
        try {
            String host = ((Setting)SETTINGS.get("alert.email.host")).getSettingValue();
            String port = ((Setting)SETTINGS.get("alert.email.port")).getSettingValue();
            String from = ((Setting)SETTINGS.get("alert.email.from")).getSettingValue();
            String userName = ((Setting)SETTINGS.get("alert.email.userName")).getSettingValue();
            String password = ((Setting)SETTINGS.get("alert.email.password")).getSettingValue();
            String ssl = ((Setting)SETTINGS.get("alert.email.ssl")).getSettingValue();
            SenderEmail senderEmail = new SenderEmail();
            senderEmail.setSmtpHost(host);
            senderEmail.setSmtpPort(Integer.parseInt(port));
            senderEmail.setFrom(from);
            senderEmail.setUserName(userName);
            senderEmail.setPassword(password);
            senderEmail.setSsl(Boolean.parseBoolean(ssl));
            return senderEmail;
        }
        catch (Exception e) {
            log.warn("Fault Alert Email is not set.");
            return null;
        }
    }

    @Override
    public String getDockerRegisterAddress() {
        return SETTINGS.getOrDefault("docker.register.address", this.emptySetting).getSettingValue();
    }

    @Override
    public String getDockerRegisterUser() {
        return SETTINGS.getOrDefault("docker.register.user", this.emptySetting).getSettingValue();
    }

    @Override
    public String getDockerRegisterPassword() {
        return SETTINGS.getOrDefault("docker.register.password", this.emptySetting).getSettingValue();
    }

    @Override
    public String getDockerRegisterNamespace() {
        return SETTINGS.getOrDefault("docker.register.namespace", this.emptySetting).getSettingValue();
    }

    @Override
    public String getStreamParkAddress() {
        return SETTINGS.getOrDefault("streampark.console.webapp.address", this.emptySetting).getSettingValue();
    }

    @Override
    public String getMavenSettings() {
        return SETTINGS.getOrDefault("streampark.maven.settings", this.emptySetting).getSettingValue();
    }

    @Override
    public String getMavenRepository() {
        return SETTINGS.getOrDefault("streampark.maven.central.repository", this.emptySetting).getSettingValue();
    }

    @Override
    public String getMavenAuthUser() {
        return SETTINGS.getOrDefault("streampark.maven.auth.user", this.emptySetting).getSettingValue();
    }

    @Override
    public String getMavenAuthPassword() {
        return SETTINGS.getOrDefault("streampark.maven.auth.password", this.emptySetting).getSettingValue();
    }

    @Override
    public String getIngressModeDefault() {
        return SETTINGS.getOrDefault("ingress.mode.default", this.emptySetting).getSettingValue();
    }
}

