/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.TextElement;

@PublicEvolving
public class HeartbeatManagerOptions {
    @Documentation.Section(value={"expert_fault_tolerance"})
    public static final ConfigOption<Long> HEARTBEAT_INTERVAL = ConfigOptions.key("heartbeat.interval").defaultValue(10000L).withDescription("Time interval between heartbeat RPC requests from the sender to the receiver side.");
    @Documentation.Section(value={"expert_fault_tolerance"})
    public static final ConfigOption<Long> HEARTBEAT_TIMEOUT = ConfigOptions.key("heartbeat.timeout").defaultValue(50000L).withDescription("Timeout for requesting and receiving heartbeats for both sender and receiver sides.");
    private static final String HEARTBEAT_RPC_FAILURE_THRESHOLD_KEY = "heartbeat.rpc-failure-threshold";
    @Documentation.Section(value={"expert_fault_tolerance"})
    public static final ConfigOption<Integer> HEARTBEAT_RPC_FAILURE_THRESHOLD = ConfigOptions.key("heartbeat.rpc-failure-threshold").intType().defaultValue(2).withDescription(Description.builder().text("The number of consecutive failed heartbeat RPCs until a heartbeat target is marked as unreachable. Failed heartbeat RPCs can be used to detect dead targets faster because they no longer receive the RPCs. The detection time is %s * %s. In environments with a flaky network, setting this value too low can produce false positives. In this case, we recommend to increase this value, but not higher than %s / %s. The mechanism can be disabled by setting this option to %s", TextElement.code(HEARTBEAT_INTERVAL.key()), TextElement.code("heartbeat.rpc-failure-threshold"), TextElement.code(HEARTBEAT_TIMEOUT.key()), TextElement.code(HEARTBEAT_INTERVAL.key()), TextElement.code("-1")).build());

    private HeartbeatManagerOptions() {
    }
}

