/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.artifact.filter.resolve;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.maven.shared.artifact.filter.resolve.FilterTransformer;
import org.apache.maven.shared.artifact.filter.resolve.TransformableFilter;

public class ScopeFilter
implements TransformableFilter {
    private final Collection<String> excluded;
    private final Collection<String> included;

    public ScopeFilter(Collection<String> included, Collection<String> excluded) {
        this.included = included == null ? null : Collections.unmodifiableCollection(included);
        this.excluded = excluded == null ? null : Collections.unmodifiableCollection(excluded);
    }

    public static ScopeFilter including(Collection<String> included) {
        return new ScopeFilter(included, null);
    }

    public static ScopeFilter including(String ... included) {
        return new ScopeFilter(Arrays.asList(included), null);
    }

    public static ScopeFilter excluding(Collection<String> excluded) {
        return new ScopeFilter(null, excluded);
    }

    public static ScopeFilter excluding(String ... excluded) {
        return new ScopeFilter(null, Arrays.asList(excluded));
    }

    public final Collection<String> getExcluded() {
        return this.excluded;
    }

    public final Collection<String> getIncluded() {
        return this.included;
    }

    @Override
    public <T> T transform(FilterTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

