/*
 * Decompiled with CFR 0.152.
 */
package com.p6spy.engine.event;

import com.p6spy.engine.common.CallableStatementInformation;
import com.p6spy.engine.common.ConnectionInformation;
import com.p6spy.engine.common.PreparedStatementInformation;
import com.p6spy.engine.common.ResultSetInformation;
import com.p6spy.engine.common.StatementInformation;
import com.p6spy.engine.event.JdbcEventListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CompoundJdbcEventListener
extends JdbcEventListener {
    private final List<JdbcEventListener> eventListeners;

    public CompoundJdbcEventListener() {
        this.eventListeners = new ArrayList<JdbcEventListener>();
    }

    public CompoundJdbcEventListener(List<JdbcEventListener> eventListeners) {
        this.eventListeners = eventListeners;
    }

    public void addListender(JdbcEventListener listener) {
        this.addListener(listener);
    }

    public void addListener(JdbcEventListener listener) {
        this.eventListeners.add(listener);
    }

    public List<JdbcEventListener> getEventListeners() {
        return Collections.unmodifiableList(this.eventListeners);
    }

    @Override
    public void onBeforeGetConnection(ConnectionInformation connectionInformation) {
        for (JdbcEventListener eventListener : this.eventListeners) {
            eventListener.onBeforeGetConnection(connectionInformation);
        }
    }

    @Override
    public void onAfterGetConnection(ConnectionInformation connectionInformation, SQLException e) {
        for (JdbcEventListener eventListener : this.eventListeners) {
            eventListener.onAfterGetConnection(connectionInformation, e);
        }
    }

    @Override
    @Deprecated
    public void onConnectionWrapped(ConnectionInformation connectionInformation) {
        for (JdbcEventListener eventListener : this.eventListeners) {
            eventListener.onConnectionWrapped(connectionInformation);
        }
    }

    @Override
    public void onBeforeAddBatch(PreparedStatementInformation statementInformation) {
        for (JdbcEventListener eventListener : this.eventListeners) {
            eventListener.onBeforeAddBatch(statementInformation);
        }
    }

    @Override
    public void onAfterAddBatch(PreparedStatementInformation statementInformation, long timeElapsedNanos, SQLException e) {
        for (JdbcEventListener eventListener : this.eventListeners) {
            eventListener.onAfterAddBatch(statementInformation, timeElapsedNanos, e);
        }
    }

    @Override
    public void onBeforeAddBatch(StatementInformation statementInformation, String sql) {
        for (JdbcEventListener eventListener : this.eventListeners) {
            eventListener.onBeforeAddBatch(statementInformation, sql);
        }
    }

    @Override
    public void onAfterAddBatch(StatementInformation statementInformation, long timeElapsedNanos, String sql, SQLException e) {
        for (JdbcEventListener eventListener : this.eventListeners) {
            eventListener.onAfterAddBatch(statementInformation, timeElapsedNanos, sql, e);
        }
    }

    @Override
    public void onBeforeExecute(PreparedStatementInformation statementInformation) {
        for (JdbcEventListener eventListener : this.eventListeners) {
            eventListener.onBeforeExecute(statementInformation);
        }
    }

    @Override
    public void onAfterExecute(PreparedStatementInformation statementInformation, long timeElapsedNanos, SQLException e) {
        for (JdbcEventListener eventListener : this.eventListeners) {
            eventListener.onAfterExecute(statementInformation, timeElapsedNanos, e);
        }
    }

    @Override
    public void onBeforeExecute(StatementInformation statementInformation, String sql) {
        for (JdbcEventListener eventListener : this.eventListeners) {
            eventListener.onBeforeExecute(statementInformation, sql);
        }
    }

    @Override
    public void onAfterExecute(StatementInformation statementInformation, long timeElapsedNanos, String sql, SQLException e) {
        for (JdbcEventListener eventListener : this.eventListeners) {
            eventListener.onAfterExecute(statementInformation, timeElapsedNanos, sql, e);
        }
    }

    @Override
    public void onBeforeExecuteBatch(StatementInformation statementInformation) {
        for (JdbcEventListener eventListener : this.eventListeners) {
            eventListener.onBeforeExecuteBatch(statementInformation);
        }
    }

    @Override
    public void onAfterExecuteBatch(StatementInformation statementInformation, long timeElapsedNanos, int[] updateCounts, SQLException e) {
        for (JdbcEventListener eventListener : this.eventListeners) {
            eventListener.onAfterExecuteBatch(statementInformation, timeElapsedNanos, updateCounts, e);
        }
    }

    @Override
    public void onBeforeExecuteUpdate(PreparedStatementInformation statementInformation) {
        for (JdbcEventListener eventListener : this.eventListeners) {
            eventListener.onBeforeExecuteUpdate(statementInformation);
        }
    }

    @Override
    public void onAfterExecuteUpdate(PreparedStatementInformation statementInformation, long timeElapsedNanos, int rowCount, SQLException e) {
        for (JdbcEventListener eventListener : this.eventListeners) {
            eventListener.onAfterExecuteUpdate(statementInformation, timeElapsedNanos, rowCount, e);
        }
    }

    @Override
    public void onBeforeExecuteUpdate(StatementInformation statementInformation, String sql) {
        for (JdbcEventListener eventListener : this.eventListeners) {
            eventListener.onBeforeExecuteUpdate(statementInformation, sql);
        }
    }

    @Override
    public void onAfterExecuteUpdate(StatementInformation statementInformation, long timeElapsedNanos, String sql, int rowCount, SQLException e) {
        for (JdbcEventListener eventListener : this.eventListeners) {
            eventListener.onAfterExecuteUpdate(statementInformation, timeElapsedNanos, sql, rowCount, e);
        }
    }

    @Override
    public void onBeforeExecuteQuery(PreparedStatementInformation statementInformation) {
        for (JdbcEventListener eventListener : this.eventListeners) {
            eventListener.onBeforeExecuteQuery(statementInformation);
        }
    }

    @Override
    public void onAfterExecuteQuery(PreparedStatementInformation statementInformation, long timeElapsedNanos, SQLException e) {
        for (JdbcEventListener eventListener : this.eventListeners) {
            eventListener.onAfterExecuteQuery(statementInformation, timeElapsedNanos, e);
        }
    }

    @Override
    public void onBeforeExecuteQuery(StatementInformation statementInformation, String sql) {
        for (JdbcEventListener eventListener : this.eventListeners) {
            eventListener.onBeforeExecuteQuery(statementInformation, sql);
        }
    }

    @Override
    public void onAfterExecuteQuery(StatementInformation statementInformation, long timeElapsedNanos, String sql, SQLException e) {
        for (JdbcEventListener eventListener : this.eventListeners) {
            eventListener.onAfterExecuteQuery(statementInformation, timeElapsedNanos, sql, e);
        }
    }

    @Override
    public void onAfterPreparedStatementSet(PreparedStatementInformation statementInformation, int parameterIndex, Object value, SQLException e) {
        for (JdbcEventListener eventListener : this.eventListeners) {
            eventListener.onAfterPreparedStatementSet(statementInformation, parameterIndex, value, e);
        }
    }

    @Override
    public void onAfterCallableStatementSet(CallableStatementInformation statementInformation, String parameterName, Object value, SQLException e) {
        for (JdbcEventListener eventListener : this.eventListeners) {
            eventListener.onAfterCallableStatementSet(statementInformation, parameterName, value, e);
        }
    }

    @Override
    public void onAfterGetResultSet(StatementInformation statementInformation, long timeElapsedNanos, SQLException e) {
        for (JdbcEventListener eventListener : this.eventListeners) {
            eventListener.onAfterGetResultSet(statementInformation, timeElapsedNanos, e);
        }
    }

    @Override
    public void onBeforeResultSetNext(ResultSetInformation resultSetInformation) {
        for (JdbcEventListener eventListener : this.eventListeners) {
            eventListener.onBeforeResultSetNext(resultSetInformation);
        }
    }

    @Override
    public void onAfterResultSetNext(ResultSetInformation resultSetInformation, long timeElapsedNanos, boolean hasNext, SQLException e) {
        for (JdbcEventListener eventListener : this.eventListeners) {
            eventListener.onAfterResultSetNext(resultSetInformation, timeElapsedNanos, hasNext, e);
        }
    }

    @Override
    public void onAfterResultSetClose(ResultSetInformation resultSetInformation, SQLException e) {
        for (JdbcEventListener eventListener : this.eventListeners) {
            eventListener.onAfterResultSetClose(resultSetInformation, e);
        }
    }

    @Override
    public void onAfterResultSetGet(ResultSetInformation resultSetInformation, String columnLabel, Object value, SQLException e) {
        for (JdbcEventListener eventListener : this.eventListeners) {
            eventListener.onAfterResultSetGet(resultSetInformation, columnLabel, value, e);
        }
    }

    @Override
    public void onAfterResultSetGet(ResultSetInformation resultSetInformation, int columnIndex, Object value, SQLException e) {
        for (JdbcEventListener eventListener : this.eventListeners) {
            eventListener.onAfterResultSetGet(resultSetInformation, columnIndex, value, e);
        }
    }

    @Override
    public void onBeforeCommit(ConnectionInformation connectionInformation) {
        for (JdbcEventListener eventListener : this.eventListeners) {
            eventListener.onBeforeCommit(connectionInformation);
        }
    }

    @Override
    public void onAfterCommit(ConnectionInformation connectionInformation, long timeElapsedNanos, SQLException e) {
        for (JdbcEventListener eventListener : this.eventListeners) {
            eventListener.onAfterCommit(connectionInformation, timeElapsedNanos, e);
        }
    }

    @Override
    public void onAfterConnectionClose(ConnectionInformation connectionInformation, SQLException e) {
        for (JdbcEventListener eventListener : this.eventListeners) {
            eventListener.onAfterConnectionClose(connectionInformation, e);
        }
    }

    @Override
    public void onBeforeRollback(ConnectionInformation connectionInformation) {
        for (JdbcEventListener eventListener : this.eventListeners) {
            eventListener.onBeforeRollback(connectionInformation);
        }
    }

    @Override
    public void onAfterRollback(ConnectionInformation connectionInformation, long timeElapsedNanos, SQLException e) {
        for (JdbcEventListener eventListener : this.eventListeners) {
            eventListener.onAfterRollback(connectionInformation, timeElapsedNanos, e);
        }
    }

    @Override
    public void onAfterStatementClose(StatementInformation statementInformation, SQLException e) {
        for (JdbcEventListener eventListener : this.eventListeners) {
            eventListener.onAfterStatementClose(statementInformation, e);
        }
    }

    @Override
    public void onBeforeSetAutoCommit(ConnectionInformation connectionInformation, boolean newAutoCommit, boolean currentAutoCommit) {
        for (JdbcEventListener eventListener : this.eventListeners) {
            eventListener.onBeforeSetAutoCommit(connectionInformation, newAutoCommit, currentAutoCommit);
        }
    }

    @Override
    public void onAfterSetAutoCommit(ConnectionInformation connectionInformation, boolean newAutoCommit, boolean oldAutoCommit, SQLException e) {
        for (JdbcEventListener eventListener : this.eventListeners) {
            eventListener.onAfterSetAutoCommit(connectionInformation, newAutoCommit, oldAutoCommit, e);
        }
    }
}

