/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.discovery.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.discovery.v1.Endpoint;
import io.fabric8.kubernetes.api.model.discovery.v1.EndpointFluent;
import io.fabric8.kubernetes.api.model.discovery.v1.EndpointFluentImpl;
import java.util.Objects;

public class EndpointBuilder
extends EndpointFluentImpl<EndpointBuilder>
implements VisitableBuilder<Endpoint, EndpointBuilder> {
    EndpointFluent<?> fluent;
    Boolean validationEnabled;

    public EndpointBuilder() {
        this(true);
    }

    public EndpointBuilder(Boolean validationEnabled) {
        this(new Endpoint(), validationEnabled);
    }

    public EndpointBuilder(EndpointFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public EndpointBuilder(EndpointFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Endpoint(), validationEnabled);
    }

    public EndpointBuilder(EndpointFluent<?> fluent, Endpoint instance) {
        this(fluent, instance, true);
    }

    public EndpointBuilder(EndpointFluent<?> fluent, Endpoint instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAddresses(instance.getAddresses());
        fluent.withConditions(instance.getConditions());
        fluent.withDeprecatedTopology(instance.getDeprecatedTopology());
        fluent.withHints(instance.getHints());
        fluent.withHostname(instance.getHostname());
        fluent.withNodeName(instance.getNodeName());
        fluent.withTargetRef(instance.getTargetRef());
        fluent.withZone(instance.getZone());
        this.validationEnabled = validationEnabled;
    }

    public EndpointBuilder(Endpoint instance) {
        this(instance, (Boolean)true);
    }

    public EndpointBuilder(Endpoint instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAddresses(instance.getAddresses());
        this.withConditions(instance.getConditions());
        this.withDeprecatedTopology(instance.getDeprecatedTopology());
        this.withHints(instance.getHints());
        this.withHostname(instance.getHostname());
        this.withNodeName(instance.getNodeName());
        this.withTargetRef(instance.getTargetRef());
        this.withZone(instance.getZone());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Endpoint build() {
        Endpoint buildable = new Endpoint(this.fluent.getAddresses(), this.fluent.getConditions(), this.fluent.getDeprecatedTopology(), this.fluent.getHints(), this.fluent.getHostname(), this.fluent.getNodeName(), this.fluent.getTargetRef(), this.fluent.getZone());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EndpointBuilder that = (EndpointBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

