/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.configuration;

import java.time.Duration;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;

@PublicEvolving
public class KubernetesHighAvailabilityOptions {
    @Documentation.Section(value={"expert_high_availability_k8s"})
    public static final ConfigOption<Duration> KUBERNETES_LEASE_DURATION = ConfigOptions.key((String)"high-availability.kubernetes.leader-election.lease-duration").durationType().defaultValue((Object)Duration.ofSeconds(15L)).withDescription("Define the lease duration for the Kubernetes leader election. The leader will continuously renew its lease time to indicate its existence. And the followers will do a lease checking against the current time. \"renewTime + leaseDuration > now\" means the leader is alive.");
    @Documentation.Section(value={"expert_high_availability_k8s"})
    public static final ConfigOption<Duration> KUBERNETES_RENEW_DEADLINE = ConfigOptions.key((String)"high-availability.kubernetes.leader-election.renew-deadline").durationType().defaultValue((Object)Duration.ofSeconds(15L)).withDescription("Defines the deadline duration when the leader tries to renew the lease. The leader will give up its leadership if it cannot successfully renew the lease in the given time.");
    @Documentation.Section(value={"expert_high_availability_k8s"})
    public static final ConfigOption<Duration> KUBERNETES_RETRY_PERIOD = ConfigOptions.key((String)"high-availability.kubernetes.leader-election.retry-period").durationType().defaultValue((Object)Duration.ofSeconds(5L)).withDescription("Defines the pause duration between consecutive retries. All the contenders, including the current leader and all other followers, periodically try to acquire/renew the leadership if possible at this interval.");

    private KubernetesHighAvailabilityOptions() {
    }
}

