/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.highavailability;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.kubernetes.kubeclient.FlinkKubeClient;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesConfigMap;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesException;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesLeaderElector;
import org.apache.flink.runtime.persistence.PossibleInconsistentStateException;
import org.apache.flink.runtime.persistence.RetrievableStateStorageHelper;
import org.apache.flink.runtime.persistence.StateHandleStore;
import org.apache.flink.runtime.persistence.StringResourceVersion;
import org.apache.flink.runtime.state.RetrievableStateHandle;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.util.StateHandleStoreUtils;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesStateHandleStore<T extends Serializable>
implements StateHandleStore<T, StringResourceVersion> {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesStateHandleStore.class);
    private final FlinkKubeClient kubeClient;
    private final String configMapName;
    private final RetrievableStateStorageHelper<T> storage;
    private final Predicate<String> configMapKeyFilter;
    private final String lockIdentity;

    public KubernetesStateHandleStore(FlinkKubeClient kubeClient, String configMapName, RetrievableStateStorageHelper<T> storage, Predicate<String> configMapKeyFilter, String lockIdentity) {
        this.kubeClient = (FlinkKubeClient)Preconditions.checkNotNull((Object)kubeClient, (String)"Kubernetes client");
        this.storage = (RetrievableStateStorageHelper)Preconditions.checkNotNull(storage, (String)"State storage");
        this.configMapName = (String)Preconditions.checkNotNull((Object)configMapName, (String)"ConfigMap name");
        this.configMapKeyFilter = (Predicate)Preconditions.checkNotNull(configMapKeyFilter);
        this.lockIdentity = (String)Preconditions.checkNotNull((Object)lockIdentity, (String)"Lock identity of current HA service");
    }

    public RetrievableStateHandle<T> addAndLock(String key, T state) throws PossibleInconsistentStateException, Exception {
        Preconditions.checkNotNull((Object)key, (String)"Key in ConfigMap.");
        Preconditions.checkNotNull(state, (String)"State.");
        RetrievableStateHandle storeHandle = this.storage.store(state);
        byte[] serializedStoreHandle = StateHandleStoreUtils.serializeOrDiscard((StateObject)storeHandle);
        boolean discardState = true;
        try {
            discardState = this.kubeClient.checkAndUpdateConfigMap(this.configMapName, c -> {
                if (KubernetesLeaderElector.hasLeadership(c, this.lockIdentity)) {
                    if (!c.getData().containsKey(key)) {
                        c.getData().put(key, this.encodeStateHandle(serializedStoreHandle));
                        return Optional.of(c);
                    }
                    throw new CompletionException((Throwable)this.getKeyAlreadyExistException(key));
                }
                return Optional.empty();
            }).get() == false;
            RetrievableStateHandle retrievableStateHandle = storeHandle;
            return retrievableStateHandle;
        }
        catch (Exception ex) {
            Optional possibleInconsistentStateException = ExceptionUtils.findThrowable((Throwable)ex, PossibleInconsistentStateException.class);
            if (possibleInconsistentStateException.isPresent()) {
                discardState = false;
                throw (PossibleInconsistentStateException)possibleInconsistentStateException.get();
            }
            throw (StateHandleStore.AlreadyExistException)ExceptionUtils.findThrowable((Throwable)ex, StateHandleStore.AlreadyExistException.class).orElseThrow(() -> ex);
        }
        finally {
            if (discardState) {
                storeHandle.discardState();
            }
        }
    }

    public void replace(String key, StringResourceVersion resourceVersion, T state) throws Exception {
        Preconditions.checkNotNull((Object)key, (String)"Key in ConfigMap.");
        Preconditions.checkNotNull(state, (String)"State.");
        RetrievableStateHandle<T> oldStateHandle = this.getAndLock(key);
        RetrievableStateHandle newStateHandle = this.storage.store(state);
        byte[] serializedStateHandle = StateHandleStoreUtils.serializeOrDiscard((StateObject)newStateHandle);
        boolean discardOldState = false;
        boolean discardNewState = true;
        try {
            boolean success;
            discardOldState = success = this.kubeClient.checkAndUpdateConfigMap(this.configMapName, c -> {
                if (KubernetesLeaderElector.hasLeadership(c, this.lockIdentity)) {
                    if (!c.getData().containsKey(key)) {
                        throw new CompletionException((Throwable)this.getKeyNotExistException(key));
                    }
                    c.getData().put(key, this.encodeStateHandle(serializedStateHandle));
                    return Optional.of(c);
                }
                return Optional.empty();
            }).get().booleanValue();
            discardNewState = !success;
        }
        catch (Exception ex) {
            Optional possibleInconsistentStateException = ExceptionUtils.findThrowable((Throwable)ex, PossibleInconsistentStateException.class);
            if (possibleInconsistentStateException.isPresent()) {
                discardNewState = false;
                throw (PossibleInconsistentStateException)possibleInconsistentStateException.get();
            }
            throw (StateHandleStore.NotExistException)ExceptionUtils.findThrowable((Throwable)ex, StateHandleStore.NotExistException.class).orElseThrow(() -> ex);
        }
        finally {
            if (discardNewState) {
                newStateHandle.discardState();
            }
            if (discardOldState) {
                oldStateHandle.discardState();
            }
        }
    }

    public StringResourceVersion exists(String key) throws Exception {
        Preconditions.checkNotNull((Object)key, (String)"Key in ConfigMap.");
        return this.kubeClient.getConfigMap(this.configMapName).map(configMap -> {
            if (configMap.getData().containsKey(key)) {
                return StringResourceVersion.valueOf((String)configMap.getResourceVersion());
            }
            return StringResourceVersion.notExisting();
        }).orElseThrow(this::getConfigMapNotExistException);
    }

    public RetrievableStateHandle<T> getAndLock(String key) throws Exception {
        Preconditions.checkNotNull((Object)key, (String)"Key in ConfigMap.");
        Optional<KubernetesConfigMap> optional = this.kubeClient.getConfigMap(this.configMapName);
        if (optional.isPresent()) {
            KubernetesConfigMap configMap = optional.get();
            if (configMap.getData().containsKey(key)) {
                return this.deserializeObject(configMap.getData().get(key));
            }
            throw this.getKeyNotExistException(key);
        }
        throw this.getConfigMapNotExistException();
    }

    public List<Tuple2<RetrievableStateHandle<T>, String>> getAllAndLock() {
        return this.kubeClient.getConfigMap(this.configMapName).map(configMap -> {
            ArrayList stateHandles = new ArrayList();
            configMap.getData().entrySet().stream().filter(entry -> this.configMapKeyFilter.test((String)entry.getKey())).forEach(entry -> {
                try {
                    stateHandles.add(new Tuple2(this.deserializeObject((String)entry.getValue()), entry.getKey()));
                }
                catch (IOException e) {
                    LOG.warn("ConfigMap {} contained corrupted data. Ignoring the key {}.", (Object)this.configMapName, entry.getKey());
                }
            });
            return stateHandles;
        }).orElse(Collections.emptyList());
    }

    public Collection<String> getAllHandles() throws Exception {
        return this.kubeClient.getConfigMap(this.configMapName).map(configMap -> configMap.getData().keySet().stream().filter(this.configMapKeyFilter).collect(Collectors.toList())).orElseThrow(this::getConfigMapNotExistException);
    }

    public boolean releaseAndTryRemove(String key) throws Exception {
        Preconditions.checkNotNull((Object)key, (String)"Key in ConfigMap.");
        AtomicReference stateHandleRefer = new AtomicReference();
        return (Boolean)((CompletableFuture)this.kubeClient.checkAndUpdateConfigMap(this.configMapName, configMap -> {
            if (KubernetesLeaderElector.hasLeadership(configMap, this.lockIdentity)) {
                String content = configMap.getData().remove(key);
                if (content != null) {
                    try {
                        stateHandleRefer.set(this.deserializeObject(content));
                    }
                    catch (IOException e) {
                        LOG.warn("Could not retrieve the state handle of {} from ConfigMap {}.", new Object[]{key, this.configMapName, e});
                    }
                }
                return Optional.of(configMap);
            }
            return Optional.empty();
        }).whenComplete((succeed, ignore) -> {
            if (succeed.booleanValue() && stateHandleRefer.get() != null) {
                try {
                    ((RetrievableStateHandle)stateHandleRefer.get()).discardState();
                }
                catch (Exception e) {
                    throw new CompletionException(e);
                }
            }
        })).get();
    }

    public void releaseAndTryRemoveAll() throws Exception {
        ArrayList validStateHandles = new ArrayList();
        ((CompletableFuture)this.kubeClient.checkAndUpdateConfigMap(this.configMapName, c -> {
            if (KubernetesLeaderElector.hasLeadership(c, this.lockIdentity)) {
                HashMap<String, String> updateData = new HashMap<String, String>(c.getData());
                c.getData().entrySet().stream().filter(entry -> this.configMapKeyFilter.test((String)entry.getKey())).forEach(entry -> {
                    try {
                        validStateHandles.add(this.deserializeObject((String)entry.getValue()));
                        updateData.remove(entry.getKey());
                    }
                    catch (IOException e) {
                        LOG.warn("ConfigMap {} contained corrupted data. Ignoring the key {}.", (Object)this.configMapName, entry.getKey());
                    }
                });
                c.getData().clear();
                c.getData().putAll(updateData);
                return Optional.of(c);
            }
            return Optional.empty();
        }).whenComplete((succeed, ignore) -> {
            if (succeed.booleanValue()) {
                Exception exception = null;
                for (RetrievableStateHandle stateHandle : validStateHandles) {
                    try {
                        stateHandle.discardState();
                    }
                    catch (Exception e) {
                        exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, exception);
                    }
                }
                if (exception != null) {
                    throw new CompletionException((Throwable)((Object)new KubernetesException("Could not properly remove all state handles.", exception)));
                }
            }
        })).get();
    }

    public void clearEntries() throws Exception {
        this.kubeClient.checkAndUpdateConfigMap(this.configMapName, c -> {
            if (KubernetesLeaderElector.hasLeadership(c, this.lockIdentity)) {
                c.getData().keySet().removeIf(this.configMapKeyFilter);
                return Optional.of(c);
            }
            return Optional.empty();
        }).get();
    }

    public void release(String name) {
    }

    public void releaseAll() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{configMapName='" + this.configMapName + "'}";
    }

    private RetrievableStateHandle<T> deserializeObject(String content) throws IOException {
        Preconditions.checkNotNull((Object)content, (String)"Content should not be null.");
        byte[] data = Base64.getDecoder().decode(content);
        try {
            return (RetrievableStateHandle)StateHandleStoreUtils.deserialize((byte[])data);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IOException("Failed to deserialize state handle from ConfigMap data " + content + '.', e);
        }
    }

    private KubernetesException getConfigMapNotExistException() {
        return new KubernetesException("ConfigMap " + this.configMapName + " does not exists. It may be deleted externally.");
    }

    private StateHandleStore.NotExistException getKeyNotExistException(String key) {
        return new StateHandleStore.NotExistException("Could not find " + key + " in ConfigMap " + this.configMapName);
    }

    private StateHandleStore.AlreadyExistException getKeyAlreadyExistException(String key) {
        return new StateHandleStore.AlreadyExistException(key + " already exists in ConfigMap " + this.configMapName);
    }

    private String encodeStateHandle(byte[] serializedStoreHandle) {
        return Base64.getEncoder().encodeToString(serializedStoreHandle);
    }
}

