/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.checkpoint.StatsSummarySnapshot;
import org.apache.flink.util.Preconditions;

@Internal
public class CompletedCheckpointStatsSummarySnapshot
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final StatsSummarySnapshot duration;
    private final StatsSummarySnapshot persistedData;
    private final StatsSummarySnapshot processedData;
    private final StatsSummarySnapshot stateSize;

    public CompletedCheckpointStatsSummarySnapshot(StatsSummarySnapshot duration, StatsSummarySnapshot processedData, StatsSummarySnapshot persistedData, StatsSummarySnapshot stateSize) {
        this.duration = (StatsSummarySnapshot)Preconditions.checkNotNull((Object)duration);
        this.persistedData = (StatsSummarySnapshot)Preconditions.checkNotNull((Object)persistedData);
        this.processedData = (StatsSummarySnapshot)Preconditions.checkNotNull((Object)processedData);
        this.stateSize = (StatsSummarySnapshot)Preconditions.checkNotNull((Object)stateSize);
    }

    public static CompletedCheckpointStatsSummarySnapshot empty() {
        return new CompletedCheckpointStatsSummarySnapshot(StatsSummarySnapshot.empty(), StatsSummarySnapshot.empty(), StatsSummarySnapshot.empty(), StatsSummarySnapshot.empty());
    }

    public StatsSummarySnapshot getEndToEndDurationStats() {
        return this.duration;
    }

    public StatsSummarySnapshot getPersistedDataStats() {
        return this.persistedData;
    }

    public StatsSummarySnapshot getProcessedDataStats() {
        return this.processedData;
    }

    public StatsSummarySnapshot getStateSizeStats() {
        return this.stateSize;
    }
}

