/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability.zookeeper;

import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobStoreService;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.ZooKeeperCheckpointRecoveryFactory;
import org.apache.flink.runtime.highavailability.AbstractHaServices;
import org.apache.flink.runtime.highavailability.RunningJobsRegistry;
import org.apache.flink.runtime.highavailability.zookeeper.CuratorFrameworkWithUnhandledErrorListener;
import org.apache.flink.runtime.highavailability.zookeeper.ZooKeeperRunningJobsRegistry;
import org.apache.flink.runtime.jobmanager.JobGraphStore;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.shaded.curator4.org.apache.curator.utils.ZKPaths;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.KeeperException;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.data.Stat;
import org.apache.flink.util.Preconditions;

public class ZooKeeperHaServices
extends AbstractHaServices {
    private final CuratorFrameworkWithUnhandledErrorListener curatorFrameworkWrapper;

    public ZooKeeperHaServices(CuratorFrameworkWithUnhandledErrorListener curatorFrameworkWrapper, Executor executor, Configuration configuration, BlobStoreService blobStoreService) {
        super(configuration, executor, blobStoreService);
        this.curatorFrameworkWrapper = (CuratorFrameworkWithUnhandledErrorListener)Preconditions.checkNotNull((Object)curatorFrameworkWrapper);
    }

    @Override
    public CheckpointRecoveryFactory createCheckpointRecoveryFactory() throws Exception {
        return new ZooKeeperCheckpointRecoveryFactory(ZooKeeperUtils.useNamespaceAndEnsurePath(this.curatorFrameworkWrapper.asCuratorFramework(), ZooKeeperUtils.getJobsPath()), this.configuration, this.ioExecutor);
    }

    @Override
    public JobGraphStore createJobGraphStore() throws Exception {
        return ZooKeeperUtils.createJobGraphs(this.curatorFrameworkWrapper.asCuratorFramework(), this.configuration);
    }

    @Override
    public RunningJobsRegistry createRunningJobsRegistry() {
        return new ZooKeeperRunningJobsRegistry(this.curatorFrameworkWrapper.asCuratorFramework(), this.configuration);
    }

    @Override
    protected LeaderElectionService createLeaderElectionService(String leaderPath) {
        return ZooKeeperUtils.createLeaderElectionService(this.curatorFrameworkWrapper.asCuratorFramework(), leaderPath);
    }

    @Override
    protected LeaderRetrievalService createLeaderRetrievalService(String leaderPath) {
        return ZooKeeperUtils.createLeaderRetrievalService(this.curatorFrameworkWrapper.asCuratorFramework(), leaderPath, this.configuration);
    }

    @Override
    public void internalClose() {
        this.curatorFrameworkWrapper.close();
    }

    @Override
    public void internalCleanup() throws Exception {
        this.cleanupZooKeeperPaths();
    }

    @Override
    public void internalCleanupJobData(JobID jobID) throws Exception {
        this.deleteZNode(ZooKeeperUtils.getLeaderPathForJob(jobID));
    }

    @Override
    protected String getLeaderPathForResourceManager() {
        return ZooKeeperUtils.getLeaderPathForResourceManager();
    }

    @Override
    protected String getLeaderPathForDispatcher() {
        return ZooKeeperUtils.getLeaderPathForDispatcher();
    }

    @Override
    public String getLeaderPathForJobManager(JobID jobID) {
        return ZooKeeperUtils.getLeaderPathForJobManager(jobID);
    }

    @Override
    protected String getLeaderPathForRestServer() {
        return ZooKeeperUtils.getLeaderPathForRestServer();
    }

    private void cleanupZooKeeperPaths() throws Exception {
        this.deleteOwnedZNode();
        this.tryDeleteEmptyParentZNodes();
    }

    private void deleteOwnedZNode() throws Exception {
        this.deleteZNode("/");
    }

    private void deleteZNode(String path) throws Exception {
        boolean zNodeDeleted = false;
        while (!zNodeDeleted) {
            Stat stat = (Stat)this.curatorFrameworkWrapper.asCuratorFramework().checkExists().forPath(path);
            if (stat == null) {
                this.logger.debug("znode {} has been deleted", (Object)path);
                return;
            }
            try {
                this.curatorFrameworkWrapper.asCuratorFramework().delete().deletingChildrenIfNeeded().forPath(path);
                zNodeDeleted = true;
            }
            catch (KeeperException.NoNodeException ignored) {
                this.logger.debug("Retrying to delete znode because of other concurrent delete operation.");
            }
        }
    }

    private void tryDeleteEmptyParentZNodes() throws Exception {
        String remainingPath = ZooKeeperHaServices.getParentPath(ZooKeeperHaServices.getNormalizedPath(this.curatorFrameworkWrapper.asCuratorFramework().getNamespace()));
        CuratorFramework nonNamespaceClient = this.curatorFrameworkWrapper.asCuratorFramework().usingNamespace(null);
        while (!ZooKeeperHaServices.isRootPath(remainingPath)) {
            try {
                nonNamespaceClient.delete().forPath(remainingPath);
            }
            catch (KeeperException.NotEmptyException ignored) {
                break;
            }
            remainingPath = ZooKeeperHaServices.getParentPath(remainingPath);
        }
    }

    private static boolean isRootPath(String remainingPath) {
        return "/".equals(remainingPath);
    }

    @Nonnull
    private static String getNormalizedPath(String path) {
        return ZKPaths.makePath((String)path, (String)"");
    }

    @Nonnull
    private static String getParentPath(String path) {
        return ZKPaths.getPathAndNode((String)path).getPath();
    }
}

