/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.buffer.ReadOnlySlicedNetworkBuffer;
import org.apache.flink.runtime.io.network.partition.BufferReaderWriterUtil;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufAllocator;
import org.apache.flink.shaded.netty4.io.netty.channel.DefaultFileRegion;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;

public class FileRegionBuffer
extends DefaultFileRegion
implements Buffer {
    private final FileChannel fileChannel;
    private final Buffer.DataType dataType;
    private final boolean isCompressed;

    public FileRegionBuffer(FileChannel fileChannel, long fileChannelPosition, int bufferSize, Buffer.DataType dataType, boolean isCompressed) {
        super(fileChannel, fileChannelPosition, (long)bufferSize);
        this.fileChannel = (FileChannel)Preconditions.checkNotNull((Object)fileChannel);
        this.dataType = (Buffer.DataType)((Object)Preconditions.checkNotNull((Object)((Object)dataType)));
        this.isCompressed = isCompressed;
    }

    private int bufferSize() {
        return (int)this.count();
    }

    @Override
    public boolean isBuffer() {
        return this.dataType.isBuffer();
    }

    @Override
    public MemorySegment getMemorySegment() {
        throw new UnsupportedOperationException("Method should never be called.");
    }

    @Override
    public int getMemorySegmentOffset() {
        throw new UnsupportedOperationException("Method should never be called.");
    }

    @Override
    public ReadOnlySlicedNetworkBuffer readOnlySlice() {
        throw new UnsupportedOperationException("Method should never be called.");
    }

    @Override
    public ReadOnlySlicedNetworkBuffer readOnlySlice(int index, int length) {
        throw new UnsupportedOperationException("Method should never be called.");
    }

    @Override
    public int getMaxCapacity() {
        throw new UnsupportedOperationException("Method should never be called.");
    }

    @Override
    public int getReaderIndex() {
        throw new UnsupportedOperationException("Method should never be called.");
    }

    @Override
    public void setReaderIndex(int readerIndex) throws IndexOutOfBoundsException {
        throw new UnsupportedOperationException("Method should never be called.");
    }

    @Override
    public ByteBuffer getNioBufferReadable() {
        try {
            ByteBuffer buffer = ByteBuffer.allocateDirect(this.bufferSize());
            BufferReaderWriterUtil.readByteBufferFully(this.fileChannel, buffer, this.position());
            buffer.flip();
            return buffer;
        }
        catch (IOException e) {
            throw new FlinkRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public ByteBuffer getNioBuffer(int index, int length) throws IndexOutOfBoundsException {
        throw new UnsupportedOperationException("Method should never be called.");
    }

    @Override
    public ByteBuf asByteBuf() {
        throw new UnsupportedOperationException("Method should never be called.");
    }

    @Override
    public void setSize(int writerIndex) {
        throw new UnsupportedOperationException("Method should never be called.");
    }

    @Override
    public int getSize() {
        return this.bufferSize();
    }

    @Override
    public int readableBytes() {
        return this.bufferSize();
    }

    @Override
    public void setAllocator(ByteBufAllocator allocator) {
    }

    @Override
    public BufferRecycler getRecycler() {
        return null;
    }

    @Override
    public void recycleBuffer() {
    }

    @Override
    public boolean isRecycled() {
        return false;
    }

    @Override
    public FileRegionBuffer retainBuffer() {
        return (FileRegionBuffer)super.retain();
    }

    @Override
    public boolean isCompressed() {
        return this.isCompressed;
    }

    @Override
    public void setCompressed(boolean isCompressed) {
        throw new UnsupportedOperationException("Method should never be called.");
    }

    @Override
    public Buffer.DataType getDataType() {
        return this.dataType;
    }

    @Override
    public void setDataType(Buffer.DataType dataType) {
        throw new UnsupportedOperationException("Method should never be called.");
    }

    public void deallocate() {
    }

    public Buffer readInto(MemorySegment segment) throws IOException {
        ByteBuffer buffer = segment.wrap(0, this.bufferSize());
        BufferReaderWriterUtil.readByteBufferFully(this.fileChannel, buffer, this.position());
        return new NetworkBuffer(segment, BufferRecycler.DummyBufferRecycler.INSTANCE, this.dataType, this.isCompressed, this.bufferSize());
    }
}

