/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

public class AtomicDisposableReferenceCounter {
    private final Object lock = new Object();
    private int referenceCount;
    private boolean isDisposed;
    private final int disposeOnReferenceCount;

    public AtomicDisposableReferenceCounter() {
        this.disposeOnReferenceCount = 0;
    }

    public AtomicDisposableReferenceCounter(int disposeOnReferenceCount) {
        this.disposeOnReferenceCount = disposeOnReferenceCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean increment() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isDisposed) {
                return false;
            }
            ++this.referenceCount;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean decrement() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isDisposed) {
                return false;
            }
            --this.referenceCount;
            if (this.referenceCount <= this.disposeOnReferenceCount) {
                this.isDisposed = true;
            }
            return this.isDisposed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get() {
        Object object = this.lock;
        synchronized (object) {
            return this.referenceCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposed() {
        Object object = this.lock;
        synchronized (object) {
            return this.isDisposed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean disposeIfNotUsed() {
        Object object = this.lock;
        synchronized (object) {
            if (this.referenceCount <= this.disposeOnReferenceCount) {
                this.isDisposed = true;
            }
            return this.isDisposed;
        }
    }
}

