/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.filter;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.plugins.shade.filter.Filter;
import org.apache.maven.plugins.shade.mojo.ArchiveFilter;
import org.codehaus.plexus.util.SelectorUtils;

public class SimpleFilter
implements Filter {
    private Set<File> jars;
    private Set<String> includes;
    private Set<String> excludes;
    private boolean excludeDefaults = true;

    @Deprecated
    public SimpleFilter(Set<File> jars, Set<String> includes, Set<String> excludes) {
        this(jars, includes, excludes, true);
    }

    public SimpleFilter(Set<File> jars, ArchiveFilter archiveFilter) {
        this(jars, archiveFilter.getIncludes(), archiveFilter.getExcludes(), archiveFilter.getExcludeDefaults());
    }

    private SimpleFilter(Set<File> jars, Set<String> includes, Set<String> excludes, boolean excludeDefaults) {
        this.jars = jars != null ? Collections.unmodifiableSet(jars) : Collections.emptySet();
        this.includes = this.normalizePatterns(includes);
        this.excludes = this.normalizePatterns(excludes);
        this.excludeDefaults = excludeDefaults;
    }

    @Override
    public boolean canFilter(File jar) {
        return this.jars.contains(jar);
    }

    @Override
    public boolean isFiltered(String classFile) {
        String path = this.normalizePath(classFile);
        return this.excludeDefaults && !this.isIncluded(path) || this.isExcluded(path);
    }

    public boolean isSpecificallyIncluded(String classFile) {
        if (this.includes == null || this.includes.isEmpty()) {
            return false;
        }
        String path = this.normalizePath(classFile);
        return this.isIncluded(path);
    }

    private boolean isIncluded(String classFile) {
        if (this.includes == null || this.includes.isEmpty()) {
            return true;
        }
        return this.matchPaths(this.includes, classFile);
    }

    private boolean isExcluded(String classFile) {
        if (this.excludes == null || this.excludes.isEmpty()) {
            return false;
        }
        return this.matchPaths(this.excludes, classFile);
    }

    private boolean matchPaths(Set<String> patterns, String classFile) {
        for (String pattern : patterns) {
            if (!SelectorUtils.matchPath((String)pattern, (String)classFile)) continue;
            return true;
        }
        return false;
    }

    private String normalizePath(String path) {
        return path != null ? path.replace(File.separatorChar == '/' ? (char)'\\' : '/', File.separatorChar) : null;
    }

    private Set<String> normalizePatterns(Set<String> patterns) {
        HashSet<String> result = new HashSet<String>();
        if (patterns != null) {
            for (String pattern : patterns) {
                if ((pattern = this.normalizePath(pattern)).endsWith(File.separator)) {
                    pattern = pattern + "**";
                }
                result.add(pattern);
            }
        }
        return result;
    }

    @Override
    public void finished() {
    }
}

