/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.resource.properties.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;

public class SkipPropertiesDateLineWriter
extends BufferedWriter {
    private State currentState = State.MUST_SKIP_DATE_COMMENT;

    public SkipPropertiesDateLineWriter(Writer out) {
        super(out);
    }

    @Override
    public void write(String str) throws IOException {
        if (this.currentState.shouldSkip(str)) {
            this.currentState = this.currentState.next();
            return;
        }
        super.write(str);
    }

    private static enum State {
        MUST_SKIP_DATE_COMMENT{

            @Override
            boolean shouldSkip(String content) {
                return content.length() > 1 && content.startsWith("#") && !content.startsWith("# ");
            }

            @Override
            State next() {
                return SKIPPED_DATE_COMMENT;
            }
        }
        ,
        SKIPPED_DATE_COMMENT{

            @Override
            boolean shouldSkip(String content) {
                return content.trim().isEmpty();
            }

            @Override
            State next() {
                return DONE;
            }
        }
        ,
        DONE{

            @Override
            boolean shouldSkip(String content) {
                return false;
            }

            @Override
            State next() {
                throw new UnsupportedOperationException("done is a terminal state");
            }
        };


        abstract boolean shouldSkip(String var1);

        abstract State next();
    }
}

