/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.streampark.common.util.Utils;
import org.apache.streampark.common.util.YarnUtils;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.base.exception.InternalException;
import org.apache.streampark.console.core.annotation.AppUpdated;
import org.apache.streampark.console.core.annotation.PermissionScope;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.entity.ApplicationBackUp;
import org.apache.streampark.console.core.entity.ApplicationLog;
import org.apache.streampark.console.core.enums.AppExistsState;
import org.apache.streampark.console.core.service.ApplicationBackUpService;
import org.apache.streampark.console.core.service.ApplicationLogService;
import org.apache.streampark.console.core.service.ApplicationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Validated
@RestController
@RequestMapping(value={"flink/app"})
public class ApplicationController {
    private static final Logger log = LoggerFactory.getLogger(ApplicationController.class);
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private ApplicationBackUpService backUpService;
    @Autowired
    private ApplicationLogService applicationLogService;

    @PostMapping(value={"get"})
    @PermissionScope(app="#app.id")
    @RequiresPermissions(value={"app:detail"})
    public RestResponse get(Application app) {
        Application application = this.applicationService.getApp(app);
        return RestResponse.success(application);
    }

    @PermissionScope(team="#app.teamId")
    @PostMapping(value={"create"})
    @RequiresPermissions(value={"app:create"})
    public RestResponse create(Application app) throws IOException {
        boolean saved = this.applicationService.create(app);
        return RestResponse.success(saved);
    }

    @PermissionScope(app="#app.id", team="#app.teamId")
    @PostMapping(value={"copy"})
    @RequiresPermissions(value={"app:copy"})
    public RestResponse copy(Application app) throws IOException {
        Long id = this.applicationService.copy(app);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("id", Long.toString(id));
        return id.equals(0L) ? RestResponse.success(false).data(data) : RestResponse.success(true).data(data);
    }

    @AppUpdated
    @PermissionScope(app="#app.id")
    @PostMapping(value={"update"})
    @RequiresPermissions(value={"app:update"})
    public RestResponse update(Application app) {
        this.applicationService.update(app);
        return RestResponse.success(true);
    }

    @PostMapping(value={"dashboard"})
    @PermissionScope(team="#app.teamId")
    public RestResponse dashboard(Application app) {
        Map<String, Serializable> map = this.applicationService.dashboard(app.getTeamId());
        return RestResponse.success(map);
    }

    @PostMapping(value={"list"})
    @PermissionScope(team="#app.teamId")
    @RequiresPermissions(value={"app:view"})
    public RestResponse list(Application app, RestRequest request) {
        IPage<Application> applicationList = this.applicationService.page(app, request);
        return RestResponse.success(applicationList);
    }

    @AppUpdated
    @PostMapping(value={"mapping"})
    @PermissionScope(app="#app.id")
    @RequiresPermissions(value={"app:mapping"})
    public RestResponse mapping(Application app) {
        boolean flag = this.applicationService.mapping(app);
        return RestResponse.success(flag);
    }

    @AppUpdated
    @PermissionScope(app="#app.id")
    @PostMapping(value={"revoke"})
    @RequiresPermissions(value={"app:release"})
    public RestResponse revoke(Application app) {
        this.applicationService.revoke(app);
        return RestResponse.success();
    }

    @PermissionScope(app="#app.id", team="#app.teamId")
    @PostMapping(value={"check_start"})
    @RequiresPermissions(value={"app:start"})
    public RestResponse checkStart(Application app) {
        AppExistsState stateEnum = this.applicationService.checkStart(app);
        return RestResponse.success(stateEnum.get());
    }

    @PermissionScope(app="#app.id", team="#app.teamId")
    @PostMapping(value={"start"})
    @RequiresPermissions(value={"app:start"})
    public RestResponse start(Application app) {
        try {
            this.applicationService.checkEnv(app);
            this.applicationService.start(app, false);
            return RestResponse.success(true);
        }
        catch (Exception e) {
            return RestResponse.success(false).message(e.getMessage());
        }
    }

    @PermissionScope(app="#app.id", team="#app.teamId")
    @PostMapping(value={"cancel"})
    @RequiresPermissions(value={"app:cancel"})
    public RestResponse cancel(Application app) throws Exception {
        this.applicationService.cancel(app);
        return RestResponse.success();
    }

    @PermissionScope(app="#app.id")
    @PostMapping(value={"abort"})
    @RequiresPermissions(value={"app:cancel"})
    public RestResponse abort(Application app) {
        this.applicationService.abort(app);
        return RestResponse.success();
    }

    @PostMapping(value={"yarn"})
    public RestResponse yarn() {
        return RestResponse.success(YarnUtils.getRMWebAppProxyURL());
    }

    @PostMapping(value={"name"})
    @PermissionScope(app="#app.id", team="#app.teamId")
    public RestResponse yarnName(Application app) {
        String yarnName = this.applicationService.getYarnName(app);
        return RestResponse.success(yarnName);
    }

    @PostMapping(value={"checkName"})
    @PermissionScope(app="#app.id", team="#app.teamId")
    public RestResponse checkName(Application app) {
        AppExistsState exists = this.applicationService.checkExists(app);
        return RestResponse.success(exists.get());
    }

    @PostMapping(value={"readConf"})
    public RestResponse readConf(String config) throws IOException {
        String content = this.applicationService.readConf(config);
        return RestResponse.success(content);
    }

    @PostMapping(value={"main"})
    @PermissionScope(app="#app.id", team="#app.teamId")
    public RestResponse getMain(Application app) {
        String mainClass = this.applicationService.getMain(app);
        return RestResponse.success(mainClass);
    }

    @PostMapping(value={"backups"})
    @PermissionScope(app="#backUp.appId", team="#backUp.teamId")
    public RestResponse backups(ApplicationBackUp backUp, RestRequest request) {
        IPage<ApplicationBackUp> backups = this.backUpService.page(backUp, request);
        return RestResponse.success(backups);
    }

    @PostMapping(value={"optionlog"})
    @PermissionScope(app="#log.appId", team="#log.teamId")
    public RestResponse log(ApplicationLog log, RestRequest request) {
        IPage<ApplicationLog> applicationList = this.applicationLogService.page(log, request);
        return RestResponse.success(applicationList);
    }

    @PermissionScope(app="#log.appId", team="#log.teamId")
    @PostMapping(value={"deleteOperationLog"})
    @RequiresPermissions(value={"app:delete"})
    public RestResponse deleteOperationLog(ApplicationLog log) {
        Boolean deleted = this.applicationLogService.delete(log);
        return RestResponse.success(deleted);
    }

    @PermissionScope(app="#app.id", team="#app.teamId")
    @PostMapping(value={"delete"})
    @RequiresPermissions(value={"app:delete"})
    public RestResponse delete(Application app) throws InternalException {
        Boolean deleted = this.applicationService.delete(app);
        return RestResponse.success(deleted);
    }

    @PermissionScope(app="#backUp.appId")
    @PostMapping(value={"deletebak"})
    public RestResponse deleteBak(ApplicationBackUp backUp) throws InternalException {
        Boolean deleted = this.backUpService.delete(backUp.getId());
        return RestResponse.success(deleted);
    }

    @PostMapping(value={"checkjar"})
    public RestResponse checkjar(String jar) {
        File file = new File(jar);
        try {
            Utils.checkJarFile((URL)file.toURI().toURL());
            return RestResponse.success(true);
        }
        catch (IOException e) {
            return RestResponse.success(file).message(e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"upload"})
    @RequiresPermissions(value={"app:create"})
    public RestResponse upload(MultipartFile file) throws Exception {
        String uploadPath = this.applicationService.upload(file);
        return RestResponse.success(uploadPath);
    }

    @PostMapping(value={"verifySchema"})
    public RestResponse verifySchema(String path) {
        URI uri = URI.create(path);
        String scheme = uri.getScheme();
        String pathPart = uri.getPath();
        RestResponse restResponse = RestResponse.success(true);
        String error = null;
        if (scheme == null) {
            error = "The scheme (hdfs://, file://, etc) is null. Please specify the file system scheme explicitly in the URI.";
        } else if (pathPart == null) {
            error = "The path to store the checkpoint data in is null. Please specify a directory path for the checkpoint data.";
        } else if (pathPart.isEmpty() || "/".equals(pathPart)) {
            error = "Cannot use the root directory for checkpoints.";
        }
        if (error != null) {
            restResponse = RestResponse.success(false).message(error);
        }
        return restResponse;
    }

    @PostMapping(value={"checkSavepointPath"})
    @PermissionScope(app="#app.id", team="#app.teamId")
    public RestResponse checkSavepointPath(Application app) throws Exception {
        String error = this.applicationService.checkSavepointPath(app);
        if (error == null) {
            return RestResponse.success(true);
        }
        return RestResponse.success(false).message(error);
    }

    @PermissionScope(app="#id")
    @PostMapping(value={"k8sStartLog"})
    public RestResponse k8sStartLog(Long id, Integer offset, Integer limit) throws Exception {
        String resp = this.applicationService.k8sStartLog(id, offset, limit);
        return RestResponse.success(resp);
    }
}

