/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.parser;

import java.sql.Date;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.types.parser.FieldParser;

@PublicEvolving
public class SqlDateParser
extends FieldParser<Date> {
    private static final Date DATE_INSTANCE = new Date(0L);
    private Date result;

    @Override
    public int parseField(byte[] bytes, int startPos, int limit, byte[] delimiter, Date reusable) {
        int endPos = this.nextStringEndPos(bytes, startPos, limit, delimiter);
        if (endPos < 0) {
            return -1;
        }
        if (endPos > startPos && (Character.isWhitespace(bytes[startPos]) || Character.isWhitespace(bytes[endPos - 1]))) {
            this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_ILLEGAL_CHARACTER);
            return -1;
        }
        String str = new String(bytes, startPos, endPos - startPos, ConfigConstants.DEFAULT_CHARSET);
        try {
            this.result = Date.valueOf(str);
            return endPos == limit ? limit : endPos + delimiter.length;
        }
        catch (IllegalArgumentException e) {
            this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_FORMAT_ERROR);
            return -1;
        }
    }

    @Override
    public Date createValue() {
        return DATE_INSTANCE;
    }

    @Override
    public Date getLastResult() {
        return this.result;
    }

    public static final Date parseField(byte[] bytes, int startPos, int length) {
        return SqlDateParser.parseField(bytes, startPos, length, '\uffff');
    }

    public static final Date parseField(byte[] bytes, int startPos, int length, char delimiter) {
        int limitedLen = SqlDateParser.nextStringLength(bytes, startPos, length, delimiter);
        if (limitedLen > 0 && (Character.isWhitespace(bytes[startPos]) || Character.isWhitespace(bytes[startPos + limitedLen - 1]))) {
            throw new NumberFormatException("There is leading or trailing whitespace in the numeric field.");
        }
        String str = new String(bytes, startPos, limitedLen, ConfigConstants.DEFAULT_CHARSET);
        return Date.valueOf(str);
    }
}

