/*
 * Decompiled with CFR 0.152.
 */
package org.json4s;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.json4s.ParserUtil$;
import org.json4s.Segment;
import org.json4s.Segments;
import scala.Option;
import scala.Some;
import scala.sys.package$;

public final class Segments$ {
    public static Segments$ MODULE$;
    private final boolean enableSegments;
    private int segmentSize;
    private final int maxNumOfSegments;
    private final AtomicInteger segmentCount;
    private final ArrayBlockingQueue<Segment> segments;

    static {
        new Segments$();
    }

    public int segmentSize() {
        return this.segmentSize;
    }

    public void segmentSize_$eq(int x$1) {
        this.segmentSize = x$1;
    }

    public void clear() {
        this.segments.clear();
    }

    public Segment apply() {
        if (this.enableSegments) {
            Segment s = this.acquire();
            if (s != null) {
                return s;
            }
            return new Segments.DisposableSegment(new char[this.segmentSize()]);
        }
        return new Segments.DisposableSegment(new char[this.segmentSize()]);
    }

    private Segment acquire() {
        boolean createNew;
        int curCount = this.segmentCount.get();
        boolean bl = createNew = this.segments.size() == 0 && curCount < this.maxNumOfSegments ? this.segmentCount.compareAndSet(curCount, curCount + 1) : false;
        if (createNew) {
            return new Segments.RecycledSegment(new char[this.segmentSize()]);
        }
        return this.segments.poll();
    }

    public void release(Segment s) {
        Segment segment = s;
        if (segment instanceof Segments.RecycledSegment) {
            this.segments.offer(s);
            return;
        }
    }

    private Segments$() {
        MODULE$ = this;
        Option option = package$.MODULE$.props().get("json4s.segments.enable");
        Some some = new Some((Object)"false");
        this.enableSegments = option == null ? some != null : !option.equals(some);
        this.segmentSize = ParserUtil$.MODULE$.defaultSegmentSize();
        this.maxNumOfSegments = 10000;
        this.segmentCount = new AtomicInteger(0);
        this.segments = new ArrayBlockingQueue(this.maxNumOfSegments);
    }
}

