/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.ExpressionVisitor;
import com.google.gxp.compiler.base.MultiLanguageAttrValue;
import com.google.gxp.compiler.base.Node;
import com.google.gxp.compiler.base.OutputLanguage;
import com.google.gxp.compiler.schema.Schema;

public class NativeExpression
extends Expression {
    private final MultiLanguageAttrValue nativeCode;
    private final String example;
    private final String phName;

    public NativeExpression(SourcePosition sourcePosition, String displayName, MultiLanguageAttrValue nativeCode, String example, String phName) {
        super(sourcePosition, displayName, null);
        this.nativeCode = Preconditions.checkNotNull(nativeCode);
        this.example = example;
        this.phName = phName;
    }

    public NativeExpression(Node fromNode, MultiLanguageAttrValue nativeCode, String example, String phName) {
        super(fromNode, null);
        this.nativeCode = Preconditions.checkNotNull(nativeCode);
        this.example = example;
        this.phName = phName;
    }

    public NativeExpression(SourcePosition pos, String displayName, MultiLanguageAttrValue nativeCode) {
        this(pos, displayName, nativeCode, null, null);
    }

    public NativeExpression(Node fromNode, MultiLanguageAttrValue nativeCode) {
        this(fromNode, nativeCode, null, null);
    }

    public NativeExpression(Node fromNode, MultiLanguageAttrValue nativeCode, Schema schema) {
        super(fromNode, schema);
        this.nativeCode = Preconditions.checkNotNull(nativeCode);
        this.example = null;
        this.phName = null;
    }

    public String getNativeCode(OutputLanguage outputLanguage) {
        return this.nativeCode.get(outputLanguage);
    }

    public String getDefaultNativeCode() {
        return this.nativeCode.getDefault();
    }

    public String getExample() {
        return this.example;
    }

    public String getPhName() {
        return this.phName;
    }

    @Override
    public boolean canEvaluateAs(OutputLanguage outputLanguage) {
        return this.getNativeCode(outputLanguage) != null;
    }

    @Override
    public <T> T acceptVisitor(ExpressionVisitor<T> visitor) {
        return visitor.visitNativeExpression(this);
    }

    @Override
    public boolean equals(Object that) {
        return that instanceof NativeExpression && this.equals((NativeExpression)that);
    }

    public boolean equals(NativeExpression that) {
        return this.equalsExpression(that) && this.nativeCode.equals(that.nativeCode) && Objects.equal(this.example, this.example) && Objects.equal(this.phName, that.phName);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.expressionHashCode(), this.nativeCode, this.example, this.phName);
    }
}

