/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraint;

import java.util.Map;
import net.sf.oval.ConstraintTarget;
import net.sf.oval.Validator;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.constraint.HasSubstring;
import net.sf.oval.context.OValContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HasSubstringCheck
extends AbstractAnnotationCheck<HasSubstring> {
    private static final long serialVersionUID = 1L;
    private boolean ignoreCase;
    private String substring;
    private transient String substringLowerCase;

    @Override
    public void configure(HasSubstring constraintAnnotation) {
        super.configure(constraintAnnotation);
        this.setIgnoreCase(constraintAnnotation.ignoreCase());
        this.setSubstring(constraintAnnotation.value());
    }

    protected Map<String, String> createMessageVariables() {
        Map<String, String> messageVariables = Validator.getCollectionFactory().createMap(2);
        messageVariables.put("ignoreCase", Boolean.toString(this.ignoreCase));
        messageVariables.put("substring", this.substring);
        return messageVariables;
    }

    @Override
    protected ConstraintTarget[] getAppliesToDefault() {
        return new ConstraintTarget[]{ConstraintTarget.VALUES};
    }

    public String getSubstring() {
        return this.substring;
    }

    private String getSubstringLowerCase() {
        if (this.substringLowerCase == null && this.substring != null) {
            this.substringLowerCase = this.substring.toLowerCase(Validator.getLocaleProvider().getLocale());
        }
        return this.substringLowerCase;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public boolean isSatisfied(Object validatedObject, Object valueToValidate, OValContext context, Validator validator) {
        if (valueToValidate == null) {
            return true;
        }
        if (this.ignoreCase) {
            return valueToValidate.toString().toLowerCase(Validator.getLocaleProvider().getLocale()).indexOf(this.getSubstringLowerCase()) > -1;
        }
        return valueToValidate.toString().indexOf(this.substring) > -1;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        this.requireMessageVariablesRecreation();
    }

    public void setSubstring(String substring) {
        this.substring = substring;
        this.requireMessageVariablesRecreation();
    }
}

