/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.generic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.velocity.tools.config.DefaultKey;
import org.apache.velocity.tools.generic.SafeConfig;
import org.apache.velocity.tools.generic.ValueParser;

@DefaultKey(value="collection")
public class CollectionTool
extends SafeConfig
implements Serializable {
    private static final long serialVersionUID = 1410809929945061865L;
    public static final String STRINGS_DELIMITER_FORMAT_KEY = "stringsDelimiter";
    public static final String STRINGS_TRIM_KEY = "trimStrings";
    public static final String DEFAULT_STRINGS_DELIMITER = ",";
    public static final boolean DEFAULT_STRINGS_TRIM = true;
    private String stringsDelimiter = ",";
    private boolean stringsTrim = true;

    protected final void setStringsDelimiter(String stringsDelimiter) {
        this.stringsDelimiter = stringsDelimiter;
    }

    public final String getStringsDelimiter() {
        return this.stringsDelimiter;
    }

    protected final void setStringsTrim(boolean stringsTrim) {
        this.stringsTrim = stringsTrim;
    }

    public final boolean getStringsTrim() {
        return this.stringsTrim;
    }

    @Override
    protected void configure(ValueParser values) {
        Boolean trim;
        super.configure(values);
        String delimiter = values.getString(STRINGS_DELIMITER_FORMAT_KEY);
        if (delimiter != null) {
            this.setStringsDelimiter(delimiter);
        }
        if ((trim = values.getBoolean(STRINGS_TRIM_KEY)) != null) {
            this.setStringsTrim(trim);
        }
    }

    public String[] split(String value) {
        if (value == null) {
            return null;
        }
        String[] values = value.indexOf(this.stringsDelimiter) < 0 ? new String[]{value} : value.split(this.stringsDelimiter);
        if (this.stringsTrim) {
            int l = values.length;
            for (int i = 0; i < l; ++i) {
                values[i] = values[i].trim();
            }
        }
        return values;
    }

    public <T> Collection<T> sort(Collection<T> c, Comparator<T> comparator) {
        ArrayList<T> list = new ArrayList<T>();
        for (T elem : c) {
            if (elem == null) continue;
            list.add(elem);
        }
        if (list.size() < c.size()) {
            this.getLog().warn("[collection] sort: null items have been filtered");
        }
        Collections.sort(list, comparator);
        return list;
    }

    public <T> T[] sort(T[] a, Comparator<T> comparator) {
        int nulls = 0;
        for (T t : a) {
            if (t != null) continue;
            ++nulls;
        }
        if (nulls > 0) {
            this.getLog().warn("[collection] sort: null items have been filtered out");
        }
        T[] copy = Arrays.copyOf(a, a.length - nulls);
        int to = 0;
        for (int from = 0; from < a.length; ++from) {
            if (a[from] == null) continue;
            copy[to++] = a[from];
        }
        Arrays.sort(copy, comparator);
        return copy;
    }

    public <T> Collection<T> sort(Map<?, T> map, Comparator<T> comparator) {
        return this.sort(map.values(), comparator);
    }

    public Collection<?> sort(Object o, Comparator<?> comparator) {
        if (o instanceof Collection) {
            return this.sort((Object)((Collection)o), comparator);
        }
        if (o instanceof Object[]) {
            return this.sort((Object)((Object[])o), comparator);
        }
        if (o instanceof Map) {
            return this.sort((Object)((Map)o), comparator);
        }
        this.getLog().error("object type not supported: {}", (Object)(o == null ? "null" : o.getClass().getName()));
        return null;
    }

    public Collection sort(Collection collection) {
        return this.sort(collection, (List)null);
    }

    public Collection sort(Object[] array) {
        return this.sort(array, (List)null);
    }

    public Collection sort(Map map) {
        return this.sort(map, (List)null);
    }

    public Collection sort(Object object) {
        if (object instanceof Collection) {
            return this.sort((Collection)object, (List)null);
        }
        if (object instanceof Object[]) {
            return this.sort((Object[])object, (List)null);
        }
        if (object instanceof Map) {
            return this.sort((Map)object, (List)null);
        }
        this.getLog().error("object type not supported: {}", (Object)(object == null ? "null" : object.getClass().getName()));
        return null;
    }

    public Collection sort(Object object, String property) {
        List<String> properties = Collections.singletonList(property);
        if (object instanceof Collection) {
            return this.sort((Collection)object, properties);
        }
        if (object instanceof Object[]) {
            return this.sort((Object[])object, properties);
        }
        if (object instanceof Map) {
            return this.sort((Map)object, properties);
        }
        this.getLog().error("object type not supported: {}", (Object)(object == null ? "null" : object.getClass().getName()));
        return null;
    }

    public Collection sort(Collection collection, List properties) {
        ArrayList list = new ArrayList();
        for (Object o : collection) {
            if (o == null) continue;
            list.add(o);
        }
        if (list.size() < collection.size()) {
            this.getLog().warn("[collection] sort: null items have been filtered out");
        }
        return this.internalSort(list, properties);
    }

    public Collection sort(Map map, List properties) {
        return this.sort(map.values(), properties);
    }

    public Collection sort(Object[] array, List properties) {
        return this.sort(Arrays.asList(array), properties);
    }

    protected Collection internalSort(List list, List properties) {
        try {
            if (properties == null) {
                Collections.sort(list);
            } else {
                Collections.sort(list, new PropertiesComparator(properties));
            }
            return list;
        }
        catch (Exception e) {
            this.getLog().error("exception encountered while sorting: {}", (Object)e.getMessage());
            return null;
        }
    }

    protected static Comparable getComparable(Object object, String property) {
        try {
            return (Comparable)PropertyUtils.getProperty((Object)object, (String)property);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not retrieve comparable value for '" + property + "' from " + object + ": " + e);
        }
    }

    public static class PropertiesComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 8139857062638518319L;
        private static final int TYPE_ASCENDING = 1;
        private static final int TYPE_DESCENDING = -1;
        public static final String TYPE_ASCENDING_SHORT = "asc";
        public static final String TYPE_DESCENDING_SHORT = "desc";
        List properties;
        int[] sortTypes;

        public PropertiesComparator(List props) {
            this.properties = new ArrayList(props.size());
            this.properties.addAll(props);
            this.sortTypes = new int[this.properties.size()];
            for (int i = 0; i < this.properties.size(); ++i) {
                if (this.properties.get(i) == null) {
                    throw new IllegalArgumentException("Property " + i + "is null, sort properties may not be null.");
                }
                String prop = this.properties.get(i).toString();
                int colonIndex = prop.indexOf(58);
                if (colonIndex != -1) {
                    String sortType = prop.substring(colonIndex + 1);
                    this.properties.set(i, prop.substring(0, colonIndex));
                    if (TYPE_ASCENDING_SHORT.equalsIgnoreCase(sortType)) {
                        this.sortTypes[i] = 1;
                        continue;
                    }
                    if (TYPE_DESCENDING_SHORT.equalsIgnoreCase(sortType)) {
                        this.sortTypes[i] = -1;
                        continue;
                    }
                    this.sortTypes[i] = 1;
                    continue;
                }
                this.sortTypes[i] = 1;
            }
        }

        public int compare(Object lhs, Object rhs) {
            for (int i = 0; i < this.properties.size(); ++i) {
                int comparison = 0;
                String property = (String)this.properties.get(i);
                Comparable left = CollectionTool.getComparable(lhs, property);
                Comparable right = CollectionTool.getComparable(rhs, property);
                if (left == null && right != null) {
                    comparison = right.compareTo(null);
                    comparison *= -1;
                } else if (left instanceof String) {
                    comparison = ((String)((Object)left)).compareToIgnoreCase((String)((Object)right));
                } else if (left != null) {
                    comparison = left.compareTo(right);
                }
                if (comparison == 0) continue;
                return comparison * this.sortTypes[i];
            }
            return 0;
        }
    }
}

