/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.ImmutableMap;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.base.Call;
import com.google.gxp.compiler.base.CallVisitor;
import com.google.gxp.compiler.base.Callable;
import com.google.gxp.compiler.base.ExhaustiveExpressionVisitor;
import com.google.gxp.compiler.reparent.Attribute;
import java.util.List;
import java.util.Map;

public class ValidatedCall
extends Call {
    private final Callable callee;

    public ValidatedCall(SourcePosition sourcePosition, String displayName, Callable callee, Map<String, Attribute> attributes, List<String> attrBundles) {
        super(sourcePosition, displayName, Preconditions.checkNotNull(callee.getSchema()), attributes, attrBundles);
        this.callee = Preconditions.checkNotNull(callee);
    }

    public ValidatedCall(Call fromCall, Callable callee, Map<String, Attribute> attributes) {
        super(fromCall.getSourcePosition(), fromCall.getDisplayName(), Preconditions.checkNotNull(callee.getSchema()), attributes, fromCall.getAttrBundles());
        this.callee = Preconditions.checkNotNull(callee);
    }

    public ValidatedCall withParams(Map<String, Attribute> attributes) {
        return Objects.equal(this.getAttributes(), attributes) ? this : new ValidatedCall(this.getSourcePosition(), this.getDisplayName(), this.callee, attributes, this.getAttrBundles());
    }

    @Override
    public Call transformParams(ExhaustiveExpressionVisitor visitor) {
        ImmutableMap.Builder<String, Attribute> mapBuilder = ImmutableMap.builder();
        for (Map.Entry<String, Attribute> param : this.getAttributes().entrySet()) {
            mapBuilder.put(param.getKey(), visitor.visitAttribute(param.getValue()));
        }
        return this.withParams(mapBuilder.build());
    }

    @Override
    public final <T> T acceptCallVisitor(CallVisitor<T> visitor) {
        return visitor.visitValidatedCall(this);
    }

    public Callable getCallee() {
        return this.callee;
    }

    @Override
    public boolean equals(Object that) {
        return this == that || that instanceof ValidatedCall && this.equals((ValidatedCall)that);
    }

    public boolean equals(ValidatedCall that) {
        return this.equalsCall(that) && Objects.equal(this.getCallee(), that.getCallee());
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.callHashCode(), this.getCallee());
    }
}

