/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.gpu;

import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.gpu.GPUInstruction;
import org.apache.sysds.runtime.instructions.gpu.MatrixMatrixArithmeticGPUInstruction;
import org.apache.sysds.runtime.instructions.gpu.ScalarMatrixArithmeticGPUInstruction;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.Operator;

public abstract class ArithmeticBinaryGPUInstruction
extends GPUInstruction {
    protected CPOperand _input1;
    protected CPOperand _input2;
    protected CPOperand _output;

    protected ArithmeticBinaryGPUInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(op, opcode, istr);
        this._gputype = GPUInstruction.GPUINSTRUCTION_TYPE.ArithmeticBinary;
        this._input1 = in1;
        this._input2 = in2;
        this._output = out;
    }

    public static ArithmeticBinaryGPUInstruction parseInstruction(String str) {
        BinaryOperator operator;
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 3);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand in2 = new CPOperand(parts[2]);
        CPOperand out = new CPOperand(parts[3]);
        Types.DataType dt1 = in1.getDataType();
        Types.DataType dt2 = in2.getDataType();
        Types.DataType dt3 = out.getDataType();
        Operator operator2 = dt1 != dt2 ? InstructionUtils.parseScalarBinaryOperator(opcode, dt1 == Types.DataType.SCALAR) : (operator = InstructionUtils.parseBinaryOperator(opcode));
        if (dt1 == Types.DataType.MATRIX && dt2 == Types.DataType.MATRIX && dt3 == Types.DataType.MATRIX) {
            return new MatrixMatrixArithmeticGPUInstruction(operator, in1, in2, out, opcode, str);
        }
        if (dt3 == Types.DataType.MATRIX && (dt1 == Types.DataType.SCALAR && dt2 == Types.DataType.MATRIX || dt1 == Types.DataType.MATRIX && dt2 == Types.DataType.SCALAR)) {
            return new ScalarMatrixArithmeticGPUInstruction(operator, in1, in2, out, opcode, str);
        }
        throw new DMLRuntimeException("Unsupported GPU ArithmeticInstruction.");
    }
}

