/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.lineage;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.EvalNaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.FunctionCallCPInstruction;
import org.apache.sysds.runtime.instructions.cp.VariableCPInstruction;
import org.apache.sysds.runtime.instructions.spark.WriteSPInstruction;
import org.apache.sysds.runtime.lineage.LineageDedupUtils;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.lineage.LineageItemUtils;
import org.apache.sysds.runtime.lineage.LineageTraceable;
import org.apache.sysds.utils.Explain;

public class LineageMap {
    private final Map<String, LineageItem> _traces = new HashMap<String, LineageItem>();
    private final Map<String, LineageItem> _literals = new HashMap<String, LineageItem>();

    public LineageMap() {
    }

    public LineageMap(LineageMap that) {
        this();
        this._traces.putAll(that._traces);
        this._literals.putAll(that._literals);
    }

    public void trace(Instruction inst, ExecutionContext ec) {
        if (inst instanceof FunctionCallCPInstruction || inst instanceof EvalNaryCPInstruction) {
            return;
        }
        if (!(inst instanceof LineageTraceable)) {
            throw new DMLRuntimeException("Unknown Instruction (" + inst.getOpcode() + ") traced.");
        }
        LineageTraceable linst = (LineageTraceable)((Object)inst);
        if (linst.hasSingleLineage()) {
            this.trace(inst, ec, linst.getLineageItem(ec));
        } else {
            Pair<String, LineageItem>[] items = linst.getLineageItems(ec);
            if (items == null || items.length < 1) {
                this.trace(inst, ec, null);
            } else {
                for (Pair<String, LineageItem> li : items) {
                    this.trace(inst, ec, this.cleanupInputLiterals(li, ec));
                }
            }
        }
    }

    public void processDedupItem(LineageMap lm, Long path, LineageItem[] liinputs, String name) {
        String delim = "_";
        for (Map.Entry<String, LineageItem> entry : lm._traces.entrySet()) {
            String opcode = "dedup" + delim + entry.getKey() + delim + name + delim + path.toString();
            LineageItem li = new LineageItem(opcode, liinputs);
            this.addLineageItem((Pair<String, LineageItem>)Pair.of((Object)entry.getKey(), (Object)li));
        }
    }

    public LineageItem getOrCreate(CPOperand variable) {
        if (variable == null) {
            return null;
        }
        String varname = variable.getName();
        if (variable.isLiteral()) {
            LineageItem ret = this._literals.get(varname);
            if (ret == null) {
                ret = new LineageItem(variable.getLineageLiteral());
                this._literals.put(varname, ret);
            }
            return ret;
        }
        LineageItem ret = this._traces.get(variable.getName());
        return ret != null ? ret : new LineageItem(variable.getLineageLiteral());
    }

    public LineageItem get(String varName) {
        return this._traces.get(varName);
    }

    public LineageItem set(String varName, LineageItem li) {
        return this._traces.put(varName, li);
    }

    public LineageItem setLiteral(String varName, LineageItem li) {
        return this._literals.put(varName, li);
    }

    public LineageItem get(CPOperand variable) {
        if (variable == null) {
            return null;
        }
        return this._traces.get(variable.getName());
    }

    public boolean contains(CPOperand variable) {
        return this._traces.containsKey(variable.getName());
    }

    public boolean containsKey(String key) {
        return this._traces.containsKey(key);
    }

    public void resetLineageMaps() {
        this._traces.clear();
        this._literals.clear();
    }

    public Map<String, LineageItem> getTraces() {
        return this._traces;
    }

    public Map<String, LineageItem> getLiterals() {
        return this._literals;
    }

    private void trace(Instruction inst, ExecutionContext ec, Pair<String, LineageItem> li) {
        block13: {
            block12: {
                if (!(inst instanceof VariableCPInstruction)) break block12;
                VariableCPInstruction vcp_inst = (VariableCPInstruction)inst;
                switch (vcp_inst.getVariableOpcode()) {
                    case AssignVariable: 
                    case CopyVariable: {
                        this.processCopyLI(li);
                        break;
                    }
                    case Read: 
                    case CreateVariable: {
                        if (li != null) {
                            this.addLineageItem(li);
                            break;
                        }
                        break block13;
                    }
                    case RemoveVariable: {
                        for (CPOperand input : vcp_inst.getInputs()) {
                            this.removeLineageItem(input.getName());
                        }
                        break block13;
                    }
                    case Write: {
                        this.processWriteLI(vcp_inst.getInput1(), vcp_inst.getInput2(), ec);
                        break;
                    }
                    case MoveVariable: {
                        this.moveLineageItem(vcp_inst.getInput1().getName(), vcp_inst.getInput2().getName());
                        break;
                    }
                    case CastAsBooleanVariable: 
                    case CastAsDoubleVariable: 
                    case CastAsIntegerVariable: 
                    case CastAsScalarVariable: 
                    case CastAsMatrixVariable: 
                    case CastAsFrameVariable: {
                        this.addLineageItem(li);
                        break;
                    }
                    default: {
                        throw new DMLRuntimeException("Unknown VariableCPInstruction (" + inst.getOpcode() + ") traced.");
                    }
                }
                break block13;
            }
            if (inst instanceof WriteSPInstruction) {
                this.processWriteLI(((WriteSPInstruction)inst).getInput1(), ((WriteSPInstruction)inst).getInput2(), ec);
            } else {
                this.addLineageItem(li);
            }
        }
    }

    private Pair<String, LineageItem> cleanupInputLiterals(Pair<String, LineageItem> li, ExecutionContext ec) {
        LineageItem item = (LineageItem)li.getValue();
        if (item.getInputs() == null) {
            return li;
        }
        for (int i = 0; i < item.getInputs().length; ++i) {
            CPOperand cp;
            LineageItem tmp = item.getInputs()[i];
            if (tmp.getType() != LineageItem.LineageItemType.Literal || !tmp.getData().endsWith("false") || !(cp = new CPOperand(tmp.getData())).getDataType().isScalar()) continue;
            cp.setLiteral(ec.getScalarInput(cp));
            item.getInputs()[i] = this.getOrCreate(cp);
        }
        return li;
    }

    private void processCopyLI(Pair<String, LineageItem> li) {
        if (((LineageItem)li.getValue()).getInputs().length != 1) {
            throw new DMLRuntimeException("AssignVariable and CopyVariable must have one input lineage item!");
        }
        this._traces.put((String)li.getKey(), ((LineageItem)li.getValue()).getInputs()[0]);
    }

    private void moveLineageItem(String keyFrom, String keyTo) {
        LineageItem input = this.removeLineageItem(keyFrom);
        if (!keyTo.equals("__pred")) {
            this._traces.put(keyTo, input);
        }
    }

    private LineageItem removeLineageItem(String key) {
        return this._traces.remove(key);
    }

    private void addLineageItem(Pair<String, LineageItem> li) {
        this._traces.put((String)li.getKey(), (LineageItem)li.getValue());
    }

    private void processWriteLI(CPOperand input1, CPOperand input2, ExecutionContext ec) {
        LineageItem li = this.get(input1);
        String fName = ec.getScalarInput(input2.getName(), Types.ValueType.STRING, input2.isLiteral()).getStringValue();
        if (DMLScript.LINEAGE_DEDUP) {
            LineageItemUtils.writeTraceToHDFS(LineageDedupUtils.mergeExplainDedupBlocks(ec), fName + ".lineage.dedup");
        }
        LineageItemUtils.writeTraceToHDFS(Explain.explain(li), fName + ".lineage");
    }
}

