/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import org.apache.sysds.common.Types;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.lops.LopProperties;
import org.apache.sysds.runtime.instructions.InstructionUtils;

public class Binary
extends Lop {
    private Types.OpOp2 operation;

    public Binary(Lop input1, Lop input2, Types.OpOp2 op, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et) {
        super(Lop.Type.Binary, dt, vt);
        this.init(input1, input2, op, dt, vt, et);
    }

    private void init(Lop input1, Lop input2, Types.OpOp2 op, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et) {
        this.operation = op;
        this.addInput(input1);
        this.addInput(input2);
        input1.addOutput(this);
        input2.addOutput(this);
        this.lps.setProperties(this.inputs, et);
    }

    @Override
    public String toString() {
        return " Operation: " + (Object)((Object)this.operation);
    }

    public Types.OpOp2 getOperationType() {
        return this.operation;
    }

    private String getOpcode() {
        return this.operation.toString();
    }

    @Override
    public String getInstructions(String input1, String input2, String output) {
        return InstructionUtils.concatOperands(this.getExecType().toString(), this.getOpcode(), this.getInputs().get(0).prepInputOperand(input1), this.getInputs().get(1).prepInputOperand(input2), this.prepOutputOperand(output));
    }
}

