/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.utils;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.utils.IntArrayList;

public abstract class ABitmap {
    protected static final Log LOG = LogFactory.getLog((String)ABitmap.class.getName());
    protected final int _numCols;
    protected IntArrayList[] _offsetsLists;
    protected final int _numZeros;

    public ABitmap(int numCols, IntArrayList[] offsetsLists, int numZeroGroups) {
        this._numCols = numCols;
        this._numZeros = numZeroGroups;
        this._offsetsLists = offsetsLists;
    }

    public int getNumColumns() {
        return this._numCols;
    }

    public abstract int getNumValues();

    public IntArrayList[] getOffsetList() {
        return this._offsetsLists;
    }

    public IntArrayList getOffsetsList(int idx) {
        return this._offsetsLists[idx];
    }

    public long getNumOffsets() {
        long ret = 0L;
        for (IntArrayList offlist : this._offsetsLists) {
            ret += (long)offlist.size();
        }
        return ret;
    }

    public int getNumOffsets(int ix) {
        return this._offsetsLists[ix].size();
    }

    public abstract void sortValuesByFrequency();

    public boolean containsZero() {
        return this._numZeros > 0;
    }

    public int getZeroCounts() {
        return this._numZeros;
    }

    public abstract BitmapType getType();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("\nzeros:  " + this._numZeros);
        sb.append("\ncolumns:" + this._numCols);
        sb.append("\nOffsets:" + Arrays.toString(this._offsetsLists));
        return sb.toString();
    }

    public static enum BitmapType {
        Lossy,
        Full;

    }
}

