/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.data.SparseRowVector;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.io.MatrixReader;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.UtilFunctions;

public class ReaderTextLIBSVM
extends MatrixReader {
    @Override
    public MatrixBlock readMatrixFromHDFS(String fname, long rlen, long clen, int blen, long estnnz) throws IOException, DMLRuntimeException {
        MatrixBlock ret = null;
        if (rlen >= 0L && clen >= 0L) {
            ret = ReaderTextLIBSVM.createOutputMatrixBlock(rlen, clen, (int)rlen, estnnz, true, false);
        }
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        ReaderTextLIBSVM.checkValidInputFile(fs, path);
        ret = ReaderTextLIBSVM.readLIBSVMMatrixFromHDFS(path, job, fs, ret, rlen, clen, blen);
        ret.examSparsity();
        return ret;
    }

    @Override
    public MatrixBlock readMatrixFromInputStream(InputStream is, long rlen, long clen, int blen, long estnnz) throws IOException, DMLRuntimeException {
        MatrixBlock ret = ReaderTextLIBSVM.createOutputMatrixBlock(rlen, clen, (int)rlen, estnnz, true, false);
        long lnnz = ReaderTextLIBSVM.readLIBSVMMatrixFromInputStream(is, "external inputstream", ret, new MutableInt(0), rlen, clen, blen);
        ret.setNonZeros(lnnz);
        ret.examSparsity();
        return ret;
    }

    private static MatrixBlock readLIBSVMMatrixFromHDFS(Path path, JobConf job, FileSystem fs, MatrixBlock dest, long rlen, long clen, int blen) throws IOException, DMLRuntimeException {
        ArrayList<Path> files = new ArrayList<Path>();
        if (fs.isDirectory(path)) {
            for (FileStatus stat : fs.listStatus(path, IOUtilFunctions.hiddenFileFilter)) {
                files.add(stat.getPath());
            }
            Collections.sort(files);
        } else {
            files.add(path);
        }
        if (dest == null) {
            dest = ReaderTextLIBSVM.computeLIBSVMSize(files, clen, job, fs);
            clen = dest.getNumColumns();
        }
        long lnnz = 0L;
        MutableInt row = new MutableInt(0);
        for (int fileNo = 0; fileNo < files.size(); ++fileNo) {
            lnnz += ReaderTextLIBSVM.readLIBSVMMatrixFromInputStream((InputStream)fs.open(files.get(fileNo)), path.toString(), dest, row, rlen, clen, blen);
        }
        dest.setNonZeros(lnnz);
        return dest;
    }

    private static long readLIBSVMMatrixFromInputStream(InputStream is, String srcInfo, MatrixBlock dest, MutableInt rowPos, long rlen, long clen, int blen) throws IOException {
        SparseRowVector vect = new SparseRowVector(1024);
        String value = null;
        int row = rowPos.intValue();
        long lnnz = 0L;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
            while ((value = br.readLine()) != null) {
                String rowStr = value.toString().trim();
                lnnz += (long)ReaderTextLIBSVM.parseLibsvmRow(rowStr, vect, (int)clen);
                dest.appendRow(row, vect);
                ++row;
            }
        }
        rowPos.setValue(row);
        return lnnz;
    }

    private static MatrixBlock computeLIBSVMSize(List<Path> files, long ncol, JobConf job, FileSystem fs) throws IOException, DMLRuntimeException {
        int nrow = -1;
        for (int fileNo = 0; fileNo < files.size(); ++fileNo) {
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fs.open(files.get(fileNo))));){
                while (br.readLine() != null) {
                    ++nrow;
                }
                continue;
            }
        }
        return ReaderTextLIBSVM.createOutputMatrixBlock(nrow, ncol, nrow, (long)nrow * ncol, true, false);
    }

    protected static int parseLibsvmRow(String rowStr, SparseRowVector vect, int clen) {
        vect.setSize(0);
        String[] parts = rowStr.split(" ");
        double label = Double.parseDouble(parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            String[] pair = parts[i].split(":");
            vect.append(Integer.parseInt(pair[0]) - 1, UtilFunctions.parseToDouble(pair[1], UtilFunctions.defaultNaString));
        }
        vect.append(clen - 1, label);
        return vect.size();
    }
}

