/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.transform.decode;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.transform.decode.Decoder;
import org.apache.sysds.runtime.util.UtilFunctions;

public class DecoderDummycode
extends Decoder {
    private static final long serialVersionUID = 4758831042891032129L;
    private int[] _clPos = null;
    private int[] _cuPos = null;

    protected DecoderDummycode(Types.ValueType[] schema, int[] dcCols) {
        super(schema, dcCols);
    }

    @Override
    public FrameBlock decode(MatrixBlock in, FrameBlock out) {
        out.ensureAllocatedColumns(in.getNumRows());
        for (int i = 0; i < in.getNumRows(); ++i) {
            for (int j = 0; j < this._colList.length; ++j) {
                for (int k = this._clPos[j]; k < this._cuPos[j]; ++k) {
                    if (in.quickGetValue(i, k - 1) == 0.0) continue;
                    int col = this._colList[j] - 1;
                    out.set(i, col, UtilFunctions.doubleToObject(out.getSchema()[col], k - this._clPos[j] + 1));
                }
            }
        }
        return out;
    }

    @Override
    public Decoder subRangeDecoder(int colStart, int colEnd, int dummycodedOffset) {
        ArrayList<Integer> dcList = new ArrayList<Integer>();
        ArrayList<Integer> clPosList = new ArrayList<Integer>();
        ArrayList<Integer> cuPosList = new ArrayList<Integer>();
        for (int j = 0; j < this._colList.length; ++j) {
            int colID = this._colList[j];
            if (colID < colStart || colID >= colEnd) continue;
            dcList.add(colID - (colStart - 1));
            clPosList.add(this._clPos[j] - dummycodedOffset);
            cuPosList.add(this._cuPos[j] - dummycodedOffset);
        }
        if (dcList.isEmpty()) {
            return null;
        }
        int[] colList = dcList.stream().mapToInt(i -> i).toArray();
        DecoderDummycode subRangeDecoder = new DecoderDummycode(Arrays.copyOfRange(this._schema, colStart - 1, colEnd - 1), colList);
        subRangeDecoder._clPos = clPosList.stream().mapToInt(i -> i).toArray();
        subRangeDecoder._cuPos = cuPosList.stream().mapToInt(i -> i).toArray();
        return subRangeDecoder;
    }

    @Override
    public void updateIndexRanges(long[] beginDims, long[] endDims) {
        if (this._colList == null) {
            return;
        }
        long lowerColDest = beginDims[1];
        long upperColDest = endDims[1];
        for (int i = 0; i < this._colList.length; ++i) {
            long numDistinct = this._cuPos[i] - this._clPos[i];
            if ((long)this._cuPos[i] <= beginDims[1] + 1L && numDistinct > 0L) {
                lowerColDest -= numDistinct - 1L;
            }
            if ((long)this._cuPos[i] > endDims[1] + 1L || numDistinct <= 0L) continue;
            upperColDest -= numDistinct - 1L;
        }
        beginDims[1] = lowerColDest;
        endDims[1] = upperColDest;
    }

    @Override
    public void initMetaData(FrameBlock meta) {
        this._clPos = new int[this._colList.length];
        this._cuPos = new int[this._colList.length];
        int off = 0;
        for (int j = 0; j < this._colList.length; ++j) {
            int colID = this._colList[j];
            int ndist = (int)meta.getColumnMetadata()[colID - 1].getNumDistinct();
            this._clPos[j] = off + colID;
            this._cuPos[j] = this._clPos[j] + ndist;
            off += ndist - 1;
        }
    }
}

