/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.FloatBuffer;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.conf.DMLConfig;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.io.IOUtilFunctions;

public class NativeHelper {
    public static NativeBlasState CURRENT_NATIVE_BLAS_STATE = NativeBlasState.NOT_ATTEMPTED_LOADING_NATIVE_BLAS;
    private static String blasType;
    private static int maxNumThreads;
    private static boolean setMaxNumThreads;
    private static final Log LOG;

    public static String getCurrentBLAS() {
        return blasType != null ? blasType : "";
    }

    public static boolean isNativeLibraryLoaded() {
        if (!NativeHelper.isBLASLoaded()) {
            DMLConfig dmlConfig = ConfigurationManager.getDMLConfig();
            String userSpecifiedBLAS = dmlConfig == null ? "auto" : dmlConfig.getTextValue("sysds.native.blas").trim().toLowerCase();
            String customLibPath = dmlConfig == null ? "none" : dmlConfig.getTextValue("sysds.native.blas.directory").trim();
            NativeHelper.performLoading(customLibPath, userSpecifiedBLAS);
        }
        if (maxNumThreads == -1) {
            maxNumThreads = OptimizerUtils.getConstrainedNumThreads(-1);
        }
        if (CURRENT_NATIVE_BLAS_STATE == NativeBlasState.SUCCESSFULLY_LOADED_NATIVE_BLAS_AND_IN_USE && !setMaxNumThreads && maxNumThreads != -1) {
            NativeHelper.setMaxNumThreads(maxNumThreads);
            setMaxNumThreads = true;
        }
        return CURRENT_NATIVE_BLAS_STATE == NativeBlasState.SUCCESSFULLY_LOADED_NATIVE_BLAS_AND_IN_USE;
    }

    public static void initialize(String customLibPath, String userSpecifiedBLAS) {
        if (NativeHelper.isBLASLoaded() && NativeHelper.isSupportedBLAS(userSpecifiedBLAS) && !blasType.equalsIgnoreCase(userSpecifiedBLAS)) {
            throw new DMLRuntimeException("Cannot replace previously loaded blas \"" + blasType + "\" with \"" + userSpecifiedBLAS + "\".");
        }
        if (NativeHelper.isBLASLoaded() && userSpecifiedBLAS.equalsIgnoreCase("none")) {
            CURRENT_NATIVE_BLAS_STATE = NativeBlasState.SUCCESSFULLY_LOADED_NATIVE_BLAS_AND_NOT_IN_USE;
        } else if (NativeHelper.isBLASLoaded() && userSpecifiedBLAS.equalsIgnoreCase(blasType)) {
            CURRENT_NATIVE_BLAS_STATE = NativeBlasState.SUCCESSFULLY_LOADED_NATIVE_BLAS_AND_IN_USE;
        } else if (!NativeHelper.isBLASLoaded() && NativeHelper.isSupportedBLAS(userSpecifiedBLAS)) {
            NativeHelper.performLoading(customLibPath, userSpecifiedBLAS);
        }
    }

    private static boolean isSupportedBLAS(String userSpecifiedBLAS) {
        return userSpecifiedBLAS.equalsIgnoreCase("auto") || userSpecifiedBLAS.equalsIgnoreCase("mkl") || userSpecifiedBLAS.equalsIgnoreCase("openblas");
    }

    private static boolean isSupportedArchitecture() {
        if (SystemUtils.OS_ARCH.equals("x86_64") || SystemUtils.OS_ARCH.equals("amd64")) {
            return true;
        }
        LOG.info((Object)("Unsupported architecture for native BLAS:" + SystemUtils.OS_ARCH));
        return false;
    }

    private static boolean isSupportedOS() {
        if (SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_WINDOWS) {
            return true;
        }
        LOG.info((Object)("Unsupported architecture for native BLAS:" + SystemUtils.OS_ARCH));
        return false;
    }

    private static boolean isBLASLoaded() {
        return CURRENT_NATIVE_BLAS_STATE == NativeBlasState.SUCCESSFULLY_LOADED_NATIVE_BLAS_AND_IN_USE || CURRENT_NATIVE_BLAS_STATE == NativeBlasState.SUCCESSFULLY_LOADED_NATIVE_BLAS_AND_NOT_IN_USE;
    }

    private static boolean shouldReload(String customLibPath) {
        boolean isValidBLASDirectory = customLibPath != null && !customLibPath.equalsIgnoreCase("none");
        return CURRENT_NATIVE_BLAS_STATE == NativeBlasState.NOT_ATTEMPTED_LOADING_NATIVE_BLAS || isValidBLASDirectory && !NativeHelper.isBLASLoaded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performLoading(String customLibPath, String userSpecifiedBLAS) {
        if (customLibPath != null && customLibPath.equalsIgnoreCase("none")) {
            customLibPath = null;
        }
        if (NativeHelper.shouldReload(customLibPath) && NativeHelper.isSupportedBLAS(userSpecifiedBLAS) && NativeHelper.isSupportedArchitecture() && NativeHelper.isSupportedOS()) {
            long start = System.nanoTime();
            Class<NativeHelper> clazz = NativeHelper.class;
            synchronized (NativeHelper.class) {
                if (NativeHelper.shouldReload(customLibPath)) {
                    CURRENT_NATIVE_BLAS_STATE = NativeBlasState.ATTEMPTED_LOADING_NATIVE_BLAS_UNSUCCESSFULLY;
                    String[] blas = new String[]{userSpecifiedBLAS};
                    if (userSpecifiedBLAS.equalsIgnoreCase("auto")) {
                        blas = new String[]{"mkl", "openblas"};
                    }
                    if (NativeHelper.checkAndLoadBLAS(customLibPath, blas)) {
                        String platform_suffix = SystemUtils.IS_OS_WINDOWS ? "-Windows-AMD64.dll" : "-Linux-x86_64.so";
                        String library_name = "libsystemds_" + blasType + platform_suffix;
                        if (NativeHelper.loadLibraryHelperFromResource(library_name) || NativeHelper.loadBLAS(customLibPath, library_name, "Loading native helper with customLibPath.")) {
                            LOG.info((Object)("Using native blas: " + blasType + NativeHelper.getNativeBLASPath()));
                            CURRENT_NATIVE_BLAS_STATE = NativeBlasState.SUCCESSFULLY_LOADED_NATIVE_BLAS_AND_IN_USE;
                        }
                    }
                }
                // ** MonitorExit[var4_3] (shouldn't be in output)
                double timeToLoadInMilliseconds = (double)(System.nanoTime() - start) * 1.0E-6;
                if (timeToLoadInMilliseconds > 1000.0) {
                    LOG.warn((Object)("Time to load native blas: " + timeToLoadInMilliseconds + " milliseconds."));
                }
            }
        } else if (LOG.isDebugEnabled() && !NativeHelper.isSupportedBLAS(userSpecifiedBLAS)) {
            LOG.debug((Object)("Using internal Java BLAS as native BLAS support instead of the configuration 'sysds.native.blas'=" + userSpecifiedBLAS + "."));
        }
    }

    private static boolean checkAndLoadBLAS(String customLibPath, String[] listBLAS) {
        if (customLibPath != null && customLibPath.equalsIgnoreCase("none")) {
            customLibPath = null;
        }
        boolean isLoaded = false;
        for (String blas : listBLAS) {
            if (blas.equalsIgnoreCase("mkl")) {
                isLoaded = NativeHelper.loadBLAS(customLibPath, "mkl_rt", "");
            } else if (blas.equalsIgnoreCase("openblas")) {
                isLoaded = NativeHelper.loadBLAS(customLibPath, "libopenblas", "");
                if (!isLoaded) {
                    isLoaded = NativeHelper.loadBLAS(customLibPath, "openblas", "");
                }
            } else {
                LOG.warn((Object)("Not trying to load unknown blas type " + blas));
            }
            if (!isLoaded) continue;
            blasType = blas;
            break;
        }
        return isLoaded;
    }

    private static String getNativeBLASPath() {
        String blasPathAndHint = "";
        if (LOG.isDebugEnabled()) {
            try {
                Field loadedLibraryNamesField = ClassLoader.class.getDeclaredField("loadedLibraryNames");
                loadedLibraryNamesField.setAccessible(true);
                Vector libraries = (Vector)loadedLibraryNamesField.get(ClassLoader.getSystemClassLoader());
                LOG.debug((Object)("List of native libraries loaded:" + libraries));
                for (String library : libraries) {
                    if (!library.contains("mkl_rt") && !library.contains("libopenblas")) continue;
                    blasPathAndHint = " from the path " + library;
                    break;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                LOG.debug((Object)("Error while finding list of native libraries:" + e.getMessage()));
            }
        }
        return blasPathAndHint;
    }

    public static int getMaxNumThreads() {
        if (maxNumThreads == -1) {
            maxNumThreads = OptimizerUtils.getConstrainedNumThreads(-1);
        }
        return maxNumThreads;
    }

    private static boolean loadBLAS(String customLibPath, String blas, String optionalMsg) {
        if (customLibPath != null && !customLibPath.equalsIgnoreCase("none")) {
            String libPath = customLibPath + File.separator + System.mapLibraryName(blas);
            try {
                System.load(libPath);
                LOG.info((Object)("Loaded the library:" + libPath));
                return true;
            }
            catch (UnsatisfiedLinkError e) {
                LOG.warn((Object)("Unable to load " + blas + " from " + libPath + ". Trying once more with System.loadLibrary(" + blas + ") \n Message from exception was: " + e.getMessage()));
            }
        }
        try {
            System.loadLibrary(blas);
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            LOG.debug((Object)("java.library.path: " + System.getProperty("java.library.path")));
            LOG.debug((Object)("Unable to load " + blas + (optionalMsg == null ? "" : " (" + optionalMsg + ")") + " \n Message from exception was: " + e.getMessage()));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loadLibraryHelperFromResource(String libFileName) {
        FileOutputStream out = null;
        try {
            try (InputStream in = NativeHelper.class.getResourceAsStream("/lib/" + libFileName);){
                if (in != null) {
                    File temp = File.createTempFile(libFileName, "");
                    temp.deleteOnExit();
                    out = FileUtils.openOutputStream((File)temp);
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    System.load(temp.getAbsolutePath());
                    boolean bl = true;
                    IOUtilFunctions.closeSilently(out);
                    return bl;
                }
                LOG.warn((Object)("No lib available in the jar:" + libFileName));
            }
            IOUtilFunctions.closeSilently(out);
        }
        catch (IOException e) {
            LOG.warn((Object)("Unable to load library " + libFileName + " from resource:" + e.getMessage()));
        }
        finally {
            IOUtilFunctions.closeSilently(out);
        }
        return false;
    }

    public static native boolean dmmdd(double[] var0, double[] var1, double[] var2, int var3, int var4, int var5, int var6);

    public static native boolean smmdd(FloatBuffer var0, FloatBuffer var1, FloatBuffer var2, int var3, int var4, int var5, int var6);

    public static native boolean tsmm(double[] var0, double[] var1, int var2, int var3, boolean var4, int var5);

    public static native int conv2dDense(double[] var0, double[] var1, double[] var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16);

    public static native int dconv2dBiasAddDense(double[] var0, double[] var1, double[] var2, double[] var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16, int var17);

    public static native int sconv2dBiasAddDense(FloatBuffer var0, FloatBuffer var1, FloatBuffer var2, FloatBuffer var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16, int var17);

    public static native int conv2dBackwardFilterDense(double[] var0, double[] var1, double[] var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16);

    public static native int conv2dBackwardDataDense(double[] var0, double[] var1, double[] var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16);

    public static native boolean conv2dBackwardFilterSparseDense(int var0, int var1, int[] var2, double[] var3, double[] var4, double[] var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16, int var17, int var18, int var19);

    public static native boolean conv2dSparse(int var0, int var1, int[] var2, double[] var3, double[] var4, double[] var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16, int var17, int var18, int var19);

    private static native void setMaxNumThreads(int var0);

    static {
        maxNumThreads = -1;
        setMaxNumThreads = false;
        LOG = LogFactory.getLog((String)NativeHelper.class.getName());
    }

    public static enum NativeBlasState {
        NOT_ATTEMPTED_LOADING_NATIVE_BLAS,
        SUCCESSFULLY_LOADED_NATIVE_BLAS_AND_IN_USE,
        SUCCESSFULLY_LOADED_NATIVE_BLAS_AND_NOT_IN_USE,
        ATTEMPTED_LOADING_NATIVE_BLAS_UNSUCCESSFULLY;

    }
}

