/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.codegen;

import java.util.Arrays;
import org.apache.commons.math3.util.FastMath;
import org.apache.sysds.runtime.data.DenseBlockFP64;
import org.apache.sysds.runtime.functionobjects.BitwAnd;
import org.apache.sysds.runtime.functionobjects.IntegerDivide;
import org.apache.sysds.runtime.functionobjects.Modulus;
import org.apache.sysds.runtime.matrix.data.LibMatrixDNN;
import org.apache.sysds.runtime.matrix.data.LibMatrixDNNIm2Col;
import org.apache.sysds.runtime.matrix.data.LibMatrixDNNPooling;
import org.apache.sysds.runtime.matrix.data.LibMatrixMult;

public class LibSpoofPrimitives {
    private static IntegerDivide intDiv = IntegerDivide.getFnObject();
    private static Modulus mod = Modulus.getFnObject();
    private static BitwAnd bwAnd = BitwAnd.getBitwAndFnObject();
    private static ThreadLocal<VectorBuffer> memPool = new ThreadLocal<VectorBuffer>(){

        @Override
        protected VectorBuffer initialValue() {
            return new VectorBuffer(0, 0, 0);
        }
    };

    public static double dotProduct(double[] a, double[] b, int ai, int bi, int len) {
        if (a == null || b == null) {
            return 0.0;
        }
        return LibMatrixMult.dotProduct(a, b, ai, bi, len);
    }

    public static double dotProduct(double[] a, double[] b, int[] aix, int ai, int bi, int len) {
        if (a == null || b == null) {
            return 0.0;
        }
        return LibMatrixMult.dotProduct(a, b, aix, ai, bi, len);
    }

    public static double[] vectMatrixMult(double[] a, double[] b, int ai, int bi, int len) {
        int m2clen = b.length / len;
        double[] c = LibSpoofPrimitives.allocVector(m2clen, false);
        int j = 0;
        int bix = bi;
        while (j < m2clen) {
            c[j] = LibMatrixMult.dotProduct(a, b, ai, bix, len);
            ++j;
            bix += len;
        }
        return c;
    }

    public static double[] vectMatrixMult(double[] a, double[] b, int[] aix, int ai, int bi, int alen, int len) {
        int m2clen = b.length / len;
        double[] c = LibSpoofPrimitives.allocVector(m2clen, false);
        int j = 0;
        int bix = bi;
        while (j < m2clen) {
            c[j] = LibMatrixMult.dotProduct(a, b, aix, ai, bix, alen);
            ++j;
            bix += len;
        }
        return c;
    }

    public static void vectOuterMultAdd(double[] a, double[] b, double[] c, int ai, int bi, int ci, int len1, int len2) {
        if (LibSpoofPrimitives.isFlipOuter(len1, len2)) {
            int i = 0;
            int cix = ci;
            while (i < len2) {
                double val = b[bi + i];
                if (val != 0.0) {
                    LibMatrixMult.vectMultiplyAdd(val, a, c, ai, cix, len1);
                }
                ++i;
                cix += len1;
            }
        } else {
            int bn = len1 % 4;
            int i = 0;
            int cix = ci;
            while (i < bn) {
                if (a[ai + i] != 0.0) {
                    LibMatrixMult.vectMultiplyAdd(a[ai + i], b, c, bi, cix, len2);
                }
                ++i;
                cix += len2;
            }
            i = bn;
            cix = ci + bn * len2;
            while (i < len1) {
                int cix1 = cix;
                int cix2 = cix + len2;
                int cix3 = cix + 2 * len2;
                int cix4 = cix + 3 * len2;
                double aval1 = a[ai + i];
                double aval2 = a[ai + i + 1];
                double aval3 = a[ai + i + 2];
                double aval4 = a[ai + i + 3];
                for (int j = 0; j < len2; ++j) {
                    double bval = b[bi + j];
                    int n = cix1 + j;
                    c[n] = c[n] + aval1 * bval;
                    int n2 = cix2 + j;
                    c[n2] = c[n2] + aval2 * bval;
                    int n3 = cix3 + j;
                    c[n3] = c[n3] + aval3 * bval;
                    int n4 = cix4 + j;
                    c[n4] = c[n4] + aval4 * bval;
                }
                i += 4;
                cix += 4 * len2;
            }
        }
    }

    public static void vectOuterMultAdd(double[] a, double[] b, double[] c, int[] aix, int ai, int bi, int ci, int alen, int len1, int len2) {
        if (LibSpoofPrimitives.isFlipOuter(len1, len2)) {
            int i = 0;
            int cix = ci;
            while (i < len2) {
                double val = b[bi + i];
                if (val != 0.0) {
                    LibMatrixMult.vectMultiplyAdd(val, a, c, aix, ai, cix, alen);
                }
                ++i;
                cix += len1;
            }
        } else {
            for (int i = 0; i < alen; ++i) {
                LibMatrixMult.vectMultiplyAdd(a[ai + i], b, c, bi, ci + aix[ai + i] * len2, len2);
            }
        }
    }

    public static void vectOuterMultAdd(double[] a, double[] b, double[] c, int ai, int[] bix, int bi, int ci, int blen, int len1, int len2) {
        if (LibSpoofPrimitives.isFlipOuter(len1, len2)) {
            for (int i = bi; i < bi + blen; ++i) {
                int cix = ci + bix[i] * len1;
                LibMatrixMult.vectMultiplyAdd(b[i], a, c, ai, cix, len1);
            }
        } else {
            int i = 0;
            int cix = ci;
            while (i < len1) {
                LibMatrixMult.vectMultiplyAdd(a[ai + i], b, c, bix, bi, cix, blen);
                ++i;
                cix += len2;
            }
        }
    }

    public static void vectMultAdd(double[] a, double bval, double[] c, int bi, int ci, int len) {
        if (a == null || bval == 0.0) {
            return;
        }
        LibMatrixMult.vectMultiplyAdd(bval, a, c, bi, ci, len);
    }

    public static void vectMultAdd(double bval, double[] a, double[] c, int bi, int ci, int len) {
        if (a == null || bval == 0.0) {
            return;
        }
        LibMatrixMult.vectMultiplyAdd(bval, a, c, bi, ci, len);
    }

    public static void vectMultAdd(double[] a, double bval, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        if (a == null || bval == 0.0) {
            return;
        }
        LibMatrixMult.vectMultiplyAdd(bval, a, c, aix, ai, ci, alen);
    }

    public static void vectMultAdd(double bval, double[] a, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        if (a == null || bval == 0.0) {
            return;
        }
        LibMatrixMult.vectMultiplyAdd(bval, a, c, aix, ai, ci, alen);
    }

    public static void vectMultAdd(double[] a, double[] b, double[] c, int bi, int ci, int len) {
        if (a == null || b == null) {
            return;
        }
        double[] tmp = LibSpoofPrimitives.vectMultWrite(a, b, 0, bi, len);
        LibMatrixMult.vectAdd(tmp, c, 0, ci, len);
    }

    public static double[] vectMultWrite(double[] a, double bval, int bi, int len) {
        if (a == null || bval == 0.0) {
            return LibSpoofPrimitives.allocVector(len, true);
        }
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        LibMatrixMult.vectMultiplyWrite(bval, a, c, bi, 0, len);
        return c;
    }

    public static double[] vectMultWrite(double bval, double[] a, int bi, int len) {
        return LibSpoofPrimitives.vectMultWrite(a, bval, bi, len);
    }

    public static double[] vectMultWrite(double[] a, double[] b, int ai, int bi, int len) {
        if (a == null || b == null) {
            return LibSpoofPrimitives.allocVector(len, true);
        }
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        LibMatrixMult.vectMultiplyWrite(a, b, c, ai, bi, 0, len);
        return c;
    }

    public static double[] vectMultWrite(double[] a, double bval, int[] aix, int ai, int alen, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        if (a == null) {
            return c;
        }
        LibMatrixMult.vectMultiplyAdd(bval, a, c, aix, ai, 0, alen);
        return c;
    }

    public static double[] vectMultWrite(double bval, double[] a, int[] aix, int ai, int alen, int len) {
        return LibSpoofPrimitives.vectMultWrite(a, bval, aix, ai, alen, len);
    }

    public static double[] vectMultWrite(double[] a, double[] b, int[] aix, int ai, int bi, int alen, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        if (a == null || b == null) {
            return c;
        }
        for (int j = ai; j < ai + alen; ++j) {
            c[aix[j]] = a[j] * b[bi + aix[j]];
        }
        return c;
    }

    public static double[] vectMultWrite(double[] a, double[] b, int ai, int[] bix, int bi, int blen, int len) {
        return LibSpoofPrimitives.vectMultWrite(b, a, bix, ai, bi, blen, len);
    }

    public static void vectWrite(double[] a, double[] c, int ci, int len) {
        if (a == null) {
            return;
        }
        System.arraycopy(a, 0, c, ci, len);
    }

    public static void vectWrite(double[] a, double[] c, int ai, int ci, int len) {
        if (a == null) {
            return;
        }
        System.arraycopy(a, ai, c, ci, len);
    }

    public static void vectWrite(boolean[] a, boolean[] c, int[] aix) {
        if (a == null) {
            return;
        }
        for (int i = 0; i < aix.length; ++i) {
            c[aix[i]] = a[i];
        }
    }

    public static void vectWrite(boolean[] a, boolean[] c, int[] aix, int ai, int ci, int alen) {
        if (a == null) {
            return;
        }
        for (int i = ai; i < ai + alen; ++i) {
            c[ci + aix[i]] = a[i];
        }
    }

    public static double[] vectCbindAdd(double[] a, double b, double[] c, int ai, int ci, int len) {
        LibMatrixMult.vectAdd(a, c, ai, ci, len);
        int n = ci + len;
        c[n] = c[n] + b;
        return c;
    }

    public static double[] vectCbindAdd(double[] a, double b, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        LibMatrixMult.vectAdd(a, c, aix, ai, ci, alen);
        int n = ci + len;
        c[n] = c[n] + b;
        return c;
    }

    public static double[] vectCbindWrite(double a, double b) {
        double[] c = LibSpoofPrimitives.allocVector(2, false);
        c[0] = a;
        c[1] = b;
        return c;
    }

    public static double[] vectCbindWrite(double[] a, double b, int aix, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len + 1, false);
        System.arraycopy(a, aix, c, 0, len);
        c[len] = b;
        return c;
    }

    public static double[] vectCbindWrite(double[] a, double b, int[] aix, int ai, int alen, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len + 1, true);
        for (int j = ai; j < ai + alen; ++j) {
            c[aix[j]] = a[j];
        }
        c[len] = b;
        return c;
    }

    public static double[] vectCbindWrite(double[] a, double[] b, int ai, int bi, int alen, int blen) {
        double[] c = LibSpoofPrimitives.allocVector(alen + blen, false);
        System.arraycopy(a, ai, c, 0, alen);
        System.arraycopy(b, bi, c, alen, blen);
        return c;
    }

    public static double[] vectCbindWrite(double[] a, double[] b, int[] aix, int ai, int bi, int alen, int alen2, int blen) {
        double[] c = LibSpoofPrimitives.allocVector(alen2 + blen, true);
        for (int j = ai; j < ai + alen; ++j) {
            c[aix[j]] = a[j];
        }
        System.arraycopy(b, bi, c, alen2, blen);
        return c;
    }

    public static double vectSum(double[] a, int ai, int len) {
        int i;
        double val = 0.0;
        int bn = len % 8;
        for (i = ai; i < ai + bn; ++i) {
            val += a[i];
        }
        for (i = ai + bn; i < ai + len; i += 8) {
            val += a[i + 0] + a[i + 1] + a[i + 2] + a[i + 3] + a[i + 4] + a[i + 5] + a[i + 6] + a[i + 7];
        }
        return val;
    }

    public static double vectSum(double[] avals, int[] aix, int ai, int alen, int len) {
        return LibSpoofPrimitives.vectSum(avals, ai, alen);
    }

    public static double vectSumsq(double[] a, int ai, int len) {
        return LibMatrixMult.dotProduct(a, a, ai, ai, len);
    }

    public static double vectSumsq(double[] avals, int[] aix, int ai, int alen, int len) {
        return LibMatrixMult.dotProduct(avals, avals, ai, ai, alen);
    }

    public static double vectMin(double[] a, int ai, int len) {
        double val = Double.POSITIVE_INFINITY;
        for (int i = ai; i < ai + len; ++i) {
            val = Math.min(a[i], val);
        }
        return val;
    }

    public static double vectMin(double[] avals, int[] aix, int ai, int alen, int len) {
        double val = LibSpoofPrimitives.vectMin(avals, ai, alen);
        return alen < len ? Math.min(val, 0.0) : val;
    }

    public static double vectMax(double[] a, int ai, int len) {
        double val = Double.NEGATIVE_INFINITY;
        for (int i = ai; i < ai + len; ++i) {
            val = Math.max(a[i], val);
        }
        return val;
    }

    public static double vectMax(double[] avals, int[] aix, int ai, int alen, int len) {
        double val = LibSpoofPrimitives.vectMax(avals, ai, alen);
        return alen < len ? Math.max(val, 0.0) : val;
    }

    public static double vectCountnnz(double[] a, int ai, int len) {
        int count = 0;
        for (int i = ai; i < ai + len; ++i) {
            count += a[i] != 0.0 ? 1 : 0;
        }
        return count;
    }

    public static double vectCountnnz(double[] avals, int[] aix, int ai, int alen, int len) {
        return alen;
    }

    public static double vectMean(double[] a, int ai, int len) {
        return LibSpoofPrimitives.vectSum(a, ai, len) / (double)len;
    }

    public static double vectMean(double[] avals, int[] aix, int ai, int alen, int len) {
        return LibSpoofPrimitives.vectSum(avals, aix, ai, alen, len) / (double)len;
    }

    public static void vectDivAdd(double[] a, double bval, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + a[j] / bval;
        }
    }

    public static void vectDivAdd(double bval, double[] a, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + bval / a[j];
        }
    }

    public static void vectDivAdd(double[] a, double bval, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        for (int j = ai; j < ai + alen; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + a[j] / bval;
        }
    }

    public static void vectDivAdd(double bval, double[] a, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        for (int j = ai; j < ai + alen; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + bval / a[j];
        }
    }

    public static double[] vectDivWrite(double[] a, double bval, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        for (int j = 0; j < len; ++j) {
            c[j] = a[ai + j] / bval;
        }
        return c;
    }

    public static double[] vectDivWrite(double bval, double[] a, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        for (int j = 0; j < len; ++j) {
            c[j] = bval / a[ai + j];
        }
        return c;
    }

    public static double[] vectDivWrite(double[] a, double[] b, int ai, int bi, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        for (int j = 0; j < len; ++j) {
            c[j] = a[ai + j] / b[bi + j];
        }
        return c;
    }

    public static double[] vectDivWrite(double[] a, double bval, int[] aix, int ai, int alen, int len) {
        double init = bval != 0.0 ? 0.0 : Double.NaN;
        double[] c = LibSpoofPrimitives.allocVector(len, true, init);
        for (int j = ai; j < ai + alen; ++j) {
            c[aix[j]] = a[j] / bval;
        }
        return c;
    }

    public static double[] vectDivWrite(double bval, double[] a, int[] aix, int ai, int alen, int len) {
        double init = bval != 0.0 ? Double.POSITIVE_INFINITY : Double.NaN;
        double[] c = LibSpoofPrimitives.allocVector(len, true, init);
        for (int j = ai; j < ai + alen; ++j) {
            c[aix[j]] = bval / a[j];
        }
        return c;
    }

    public static double[] vectDivWrite(double[] a, double[] b, int[] aix, int ai, int bi, int alen, int len) {
        int j;
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        for (j = 0; j < len; ++j) {
            if (b[bi + j] != 0.0) continue;
            c[j] = Double.NaN;
        }
        for (j = ai; j < ai + alen; ++j) {
            c[aix[j]] = a[j] / b[bi + aix[j]];
        }
        return c;
    }

    public static double[] vectDivWrite(double[] a, double[] b, int ai, int[] bix, int bi, int blen, int len) {
        int j;
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        for (j = 0; j < len; ++j) {
            double aval = a[bi + j];
            c[j] = aval == 0.0 ? Double.NaN : (aval > 0.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY);
        }
        for (j = bi; j < bi + blen; ++j) {
            c[bix[j]] = a[ai + bix[j]] / b[j];
        }
        return c;
    }

    public static void vectMinusAdd(double[] a, double bval, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + (a[j] - bval);
        }
    }

    public static void vectMinusAdd(double bval, double[] a, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + (bval - a[j]);
        }
    }

    public static void vectMinusAdd(double[] a, double bval, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        int j;
        if (bval != 0.0) {
            j = ci;
            while (j < ci + len) {
                int n = j++;
                c[n] = c[n] - bval;
            }
        }
        for (j = ai; j < ai + alen; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + a[j];
        }
    }

    public static void vectMinusAdd(double bval, double[] a, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        int j;
        if (bval != 0.0) {
            j = ci;
            while (j < ci + len) {
                int n = j++;
                c[n] = c[n] + bval;
            }
        }
        for (j = ai; j < ai + alen; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] - a[j];
        }
    }

    public static double[] vectMinusWrite(double[] a, double bval, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        for (int j = 0; j < len; ++j) {
            c[j] = a[ai + j] - bval;
        }
        return c;
    }

    public static double[] vectMinusWrite(double bval, double[] a, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        for (int j = 0; j < len; ++j) {
            c[j] = bval - a[ai + j];
        }
        return c;
    }

    public static double[] vectMinusWrite(double[] a, double[] b, int ai, int bi, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        for (int j = 0; j < len; ++j) {
            c[j] = a[ai + j] - b[bi + j];
        }
        return c;
    }

    public static double[] vectMinusWrite(double[] a, double bval, int[] aix, int ai, int alen, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true, -bval);
        for (int j = ai; j < ai + alen; ++j) {
            int n = aix[j];
            c[n] = c[n] + a[j];
        }
        return c;
    }

    public static double[] vectMinusWrite(double bval, double[] a, int[] aix, int ai, int alen, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true, bval);
        for (int j = ai; j < ai + alen; ++j) {
            int n = aix[j];
            c[n] = c[n] - a[j];
        }
        return c;
    }

    public static double[] vectMinusWrite(double[] a, double[] b, int[] aix, int ai, int bi, int alen, int len) {
        int j;
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        for (j = 0; j < len; ++j) {
            c[j] = -b[bi + j];
        }
        for (j = ai; j < ai + alen; ++j) {
            int n = aix[j];
            c[n] = c[n] + a[j];
        }
        return c;
    }

    public static double[] vectMinusWrite(double[] a, double[] b, int ai, int[] bix, int bi, int blen, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        System.arraycopy(a, ai, c, 0, len);
        for (int j = bi; j < bi + blen; ++j) {
            int n = bix[j];
            c[n] = c[n] - b[j];
        }
        return c;
    }

    public static void vectPlusAdd(double[] a, double bval, double[] c, int ai, int ci, int len) {
        LibMatrixMult.vectAdd(a, bval, c, ai, ci, len);
    }

    public static void vectPlusAdd(double bval, double[] a, double[] c, int ai, int ci, int len) {
        LibMatrixMult.vectAdd(a, bval, c, ai, ci, len);
    }

    public static void vectPlusAdd(double[] a, double bval, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        int j = ci;
        while (j < ci + len) {
            int n = j++;
            c[n] = c[n] + bval;
        }
        for (j = ai; j < ai + alen; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + a[j];
        }
    }

    public static void vectPlusAdd(double bval, double[] a, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        LibSpoofPrimitives.vectPlusAdd(a, bval, c, aix, ai, ci, alen, len);
    }

    public static double[] vectPlusWrite(double[] a, double bval, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        for (int j = 0; j < len; ++j) {
            c[j] = a[ai + j] + bval;
        }
        return c;
    }

    public static double[] vectPlusWrite(double bval, double[] a, int ai, int len) {
        return LibSpoofPrimitives.vectPlusWrite(a, bval, ai, len);
    }

    public static double[] vectPlusWrite(double[] a, double[] b, int ai, int bi, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        for (int j = 0; j < len; ++j) {
            c[j] = a[ai + j] + b[bi + j];
        }
        return c;
    }

    public static double[] vectPlusWrite(double[] a, double bval, int[] aix, int ai, int alen, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true, bval);
        for (int j = ai; j < ai + alen; ++j) {
            int n = aix[j];
            c[n] = c[n] + a[j];
        }
        return c;
    }

    public static double[] vectPlusWrite(double bval, double[] a, int[] aix, int ai, int alen, int len) {
        return LibSpoofPrimitives.vectPlusWrite(a, bval, aix, ai, alen, len);
    }

    public static double[] vectPlusWrite(double[] a, double[] b, int[] aix, int ai, int bi, int alen, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        System.arraycopy(b, bi, c, 0, len);
        for (int j = ai; j < ai + alen; ++j) {
            int n = aix[j];
            c[n] = c[n] + a[j];
        }
        return c;
    }

    public static double[] vectPlusWrite(double[] a, double[] b, int ai, int[] bix, int bi, int blen, int len) {
        return LibSpoofPrimitives.vectPlusWrite(b, a, bix, bi, ai, blen, len);
    }

    public static void vectXorAdd(double[] a, double bval, double[] c, int ai, int ci, int len) {
        int j = ai;
        while (j < ai + len) {
            int n = ci;
            c[n] = c[n] + (a[j] != 0.0 != (bval != 0.0) ? 1.0 : 0.0);
            ++j;
            ++ci;
        }
    }

    public static void vectXorAdd(double bval, double[] a, double[] c, int ai, int ci, int len) {
        LibSpoofPrimitives.vectXorAdd(a, bval, c, ai, ci, len);
    }

    public static void vectXorAdd(double[] a, double bval, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        for (int j = ai; j < ai + alen; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + (a[j] != 0.0 != (bval != 0.0) ? 1.0 : 0.0);
        }
    }

    public static void vectXorAdd(double bval, double[] a, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        LibSpoofPrimitives.vectXorAdd(a, bval, c, aix, ai, ci, alen, len);
    }

    public static double[] vectXorWrite(double[] a, double bval, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        for (int j = 0; j < len; ++j) {
            c[j] = a[ai + j] != 0.0 != (bval != 0.0) ? 1.0 : 0.0;
        }
        return c;
    }

    public static double[] vectXorWrite(double bval, double[] a, int ai, int len) {
        return LibSpoofPrimitives.vectXorWrite(a, bval, ai, len);
    }

    public static double[] vectXorWrite(double[] a, double[] b, int ai, int bi, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        for (int j = 0; j < len; ++j) {
            c[j] = a[ai + j] != 0.0 != (b[bi + j] != 0.0) ? 1.0 : 0.0;
        }
        return c;
    }

    public static double[] vectXorWrite(double[] a, double bval, int[] aix, int ai, int alen, int len) {
        double init = bval != 0.0 ? 1.0 : 0.0;
        double[] c = LibSpoofPrimitives.allocVector(len, true, init);
        for (int j = ai; j < ai + alen; ++j) {
            c[aix[j]] = a[j] != 0.0 ? 0.0 : 1.0;
        }
        return c;
    }

    public static double[] vectXorWrite(double bval, double[] a, int[] aix, int ai, int alen, int len) {
        return LibSpoofPrimitives.vectXorWrite(a, bval, aix, ai, alen, len);
    }

    public static double[] vectXorWrite(double[] a, double[] b, int[] aix, int ai, int bi, int alen, int len) {
        int j;
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        for (j = 0; j < len; ++j) {
            c[j] = b[bi + j] != 0.0 ? 1.0 : 0.0;
        }
        for (j = ai; j < ai + alen; ++j) {
            c[aix[j]] = a[j] != 0.0 != (c[aix[j]] != 0.0) ? 1.0 : 0.0;
        }
        return c;
    }

    public static double[] vectXorWrite(double[] a, double[] b, int ai, int[] aix, int bi, int alen, int len) {
        return LibSpoofPrimitives.vectXorWrite(a, b, aix, ai, bi, alen, len);
    }

    public static void vectPowAdd(double[] a, double bval, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + Math.pow(a[j], bval);
        }
    }

    public static void vectPowAdd(double bval, double[] a, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + Math.pow(bval, a[j]);
        }
    }

    public static void vectPowAdd(double[] a, double bval, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        if (bval == 0.0) {
            for (int j = 0; j < len; ++j) {
                int n = ci + j;
                c[n] = c[n] + 1.0;
            }
        } else {
            for (int j = ai; j < ai + alen; ++j) {
                int n = ci + aix[j];
                c[n] = c[n] + Math.pow(a[j], bval);
            }
        }
    }

    public static void vectPowAdd(double bval, double[] a, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        int j;
        for (j = 0; j < len; ++j) {
            int n = ci + j;
            c[n] = c[n] + 1.0;
        }
        for (j = ai; j < ai + alen; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + (Math.pow(bval, a[j]) - 1.0);
        }
    }

    public static double[] vectPowWrite(double[] a, double bval, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = Math.pow(a[ai], bval);
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectPowWrite(double bval, double[] a, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = Math.pow(bval, a[ai]);
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectPowWrite(double[] a, double[] b, int ai, int bi, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = Math.pow(a[ai], b[bi]);
            ++j;
            ++ai;
            ++bi;
        }
        return c;
    }

    public static double[] vectPowWrite(double[] a, double bval, int[] aix, int ai, int alen, int len) {
        double init = bval == 0.0 ? 1.0 : 0.0;
        double[] c = LibSpoofPrimitives.allocVector(len, true, init);
        for (int j = ai; j < ai + alen; ++j) {
            c[aix[j]] = Math.pow(a[j], bval) - init;
        }
        return c;
    }

    public static double[] vectPowWrite(double bval, double[] a, int[] aix, int ai, int alen, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true, 1.0);
        for (int j = ai; j < ai + alen; ++j) {
            c[aix[j]] = Math.pow(bval, a[j]);
        }
        return c;
    }

    public static void vectMinAdd(double[] a, double bval, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + Math.min(a[j], bval);
        }
    }

    public static void vectMinAdd(double bval, double[] a, double[] c, int ai, int ci, int len) {
        LibSpoofPrimitives.vectMinAdd(a, bval, c, ai, ci, len);
    }

    public static void vectMinAdd(double[] a, double bval, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        int j;
        if (bval < 0.0) {
            for (j = 0; j < len; ++j) {
                int n = ci + j;
                c[n] = c[n] + bval;
            }
        }
        for (j = ai; j < ai + alen; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + (bval >= 0.0 ? Math.min(a[j], bval) : 0.0);
        }
    }

    public static void vectMinAdd(double bval, double[] a, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        LibSpoofPrimitives.vectMinAdd(a, bval, c, aix, ai, ci, alen, len);
    }

    public static double[] vectMinWrite(double[] a, double bval, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = Math.min(a[ai], bval);
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectMinWrite(double bval, double[] a, int ai, int len) {
        return LibSpoofPrimitives.vectMinWrite(a, bval, ai, len);
    }

    public static double[] vectMinWrite(double[] a, double[] b, int ai, int bi, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = Math.min(a[ai], b[bi]);
            ++j;
            ++ai;
            ++bi;
        }
        return c;
    }

    public static double[] vectMinWrite(double[] a, double bval, int[] aix, int ai, int alen, int len) {
        double init = bval < 0.0 ? bval : 0.0;
        double[] c = LibSpoofPrimitives.allocVector(len, true, init);
        for (int j = ai; j < ai + alen; ++j) {
            c[aix[j]] = Math.min(a[j], bval);
        }
        return c;
    }

    public static double[] vectMinWrite(double bval, double[] a, int[] aix, int ai, int alen, int len) {
        return LibSpoofPrimitives.vectMinWrite(a, bval, aix, ai, alen, len);
    }

    public static double[] vectMinWrite(double[] a, double[] b, int[] aix, int ai, int bi, int alen, int len) {
        int j;
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        for (j = 0; j < len; ++j) {
            c[j] = Math.min(b[bi + j], 0.0);
        }
        for (j = ai; j < ai + alen; ++j) {
            c[aix[j]] = Math.min(a[j], b[bi + aix[j]]);
        }
        return c;
    }

    public static double[] vectMinWrite(double[] a, double[] b, int ai, int[] bix, int bi, int blen, int len) {
        return LibSpoofPrimitives.vectMinWrite(b, a, bix, bi, ai, blen, len);
    }

    public static void vectMaxAdd(double[] a, double bval, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + Math.max(a[j], bval);
        }
    }

    public static void vectMaxAdd(double bval, double[] a, double[] c, int ai, int ci, int len) {
        LibSpoofPrimitives.vectMaxAdd(a, bval, c, ai, ci, len);
    }

    public static void vectMaxAdd(double[] a, double bval, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        int j;
        if (bval > 0.0) {
            for (j = 0; j < len; ++j) {
                int n = ci + j;
                c[n] = c[n] + bval;
            }
        }
        for (j = ai; j < ai + alen; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + (bval <= 0.0 ? Math.max(a[j], bval) : 0.0);
        }
    }

    public static void vectMaxAdd(double bval, double[] a, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        LibSpoofPrimitives.vectMaxAdd(a, bval, c, aix, ai, ci, alen, len);
    }

    public static double[] vectMaxWrite(double[] a, double bval, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = Math.max(a[ai], bval);
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectMaxWrite(double bval, double[] a, int ai, int len) {
        return LibSpoofPrimitives.vectMaxWrite(a, bval, ai, len);
    }

    public static double[] vectMaxWrite(double[] a, double[] b, int ai, int bi, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = Math.max(a[ai], b[bi]);
            ++j;
            ++ai;
            ++bi;
        }
        return c;
    }

    public static double[] vectMaxWrite(double[] a, double bval, int[] aix, int ai, int alen, int len) {
        double init = bval > 0.0 ? bval : 0.0;
        double[] c = LibSpoofPrimitives.allocVector(len, true, init);
        for (int j = ai; j < ai + alen; ++j) {
            c[aix[j]] = Math.max(a[j], bval);
        }
        return c;
    }

    public static double[] vectMaxWrite(double bval, double[] a, int[] aix, int ai, int alen, int len) {
        return LibSpoofPrimitives.vectMaxWrite(a, bval, aix, ai, alen, len);
    }

    public static double[] vectMaxWrite(double[] a, double[] b, int[] aix, int ai, int bi, int alen, int len) {
        int j;
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        for (j = 0; j < len; ++j) {
            c[j] = Math.max(b[bi + j], 0.0);
        }
        for (j = ai; j < ai + alen; ++j) {
            c[aix[j]] = Math.max(a[j], b[bi + aix[j]]);
        }
        return c;
    }

    public static double[] vectMaxWrite(double[] a, double[] b, int ai, int[] bix, int bi, int blen, int len) {
        return LibSpoofPrimitives.vectMaxWrite(b, a, bix, bi, ai, blen, len);
    }

    public static void vectExpAdd(double[] a, double[] c, int ai, int ci, int len) {
        for (int j = 0; j < len; ++j) {
            int n = ci + j;
            c[n] = c[n] + FastMath.exp((double)a[ai + j]);
        }
    }

    public static void vectExpAdd(double[] a, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        int j = ci;
        while (j < ci + len) {
            int n = j++;
            c[n] = c[n] + 1.0;
        }
        for (j = ai; j < ai + alen; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + (FastMath.exp((double)a[j]) - 1.0);
        }
    }

    public static double[] vectExpWrite(double[] a, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        for (int j = 0; j < len; ++j) {
            c[j] = FastMath.exp((double)a[ai + j]);
        }
        return c;
    }

    public static double[] vectExpWrite(double[] a, int[] aix, int ai, int alen, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true, 1.0);
        for (int j = ai; j < ai + alen; ++j) {
            c[aix[j]] = FastMath.exp((double)a[j]);
        }
        return c;
    }

    public static void vectCumsumAdd(double[] a, double[] c, int ai, int ci, int len) {
        double val = 0.0;
        for (int j = 0; j < len; ++j) {
            int n = ci + j;
            c[n] = c[n] + (val += a[ai * j]);
        }
    }

    public static void vectCumsumAdd(double[] a, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        double val = 0.0;
        int lastIx = -1;
        for (int j = ai; j < ai + alen; ++j) {
            int j2 = lastIx + 1;
            while (j2 < aix[j]) {
                int n = j2++;
                c[n] = c[n] + val;
            }
            c[aix[j]] = val += a[j];
            lastIx = aix[j];
        }
        int j2 = lastIx + 1;
        while (j2 < len) {
            int n = j2++;
            c[n] = c[n] + val;
        }
    }

    public static double[] vectCumsumWrite(double[] a, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        double val = 0.0;
        for (int j = 0; j < len; ++j) {
            c[j] = val += a[ai + j];
        }
        return c;
    }

    public static double[] vectCumsumWrite(double[] a, int[] aix, int ai, int alen, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        double val = 0.0;
        int lastIx = -1;
        for (int j = ai; j < ai + alen; ++j) {
            Arrays.fill(c, lastIx + 1, aix[j], val);
            c[aix[j]] = val += a[j];
            lastIx = aix[j];
        }
        Arrays.fill(c, lastIx + 1, len, val);
        return c;
    }

    public static void vectCumminAdd(double[] a, double[] c, int ai, int ci, int len) {
        double val = 0.0;
        for (int j = 0; j < len; ++j) {
            val = Math.min(val, a[ai * j]);
            int n = ci + j;
            c[n] = c[n] + val;
        }
    }

    public static void vectCumminAdd(double[] a, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        double val = 0.0;
        int lastIx = -1;
        for (int j = ai; j < ai + alen; ++j) {
            int j2 = lastIx + 1;
            while (j2 < aix[j]) {
                int n = j2++;
                c[n] = c[n] + val;
            }
            c[aix[j]] = val = Math.min(val, a[j]);
            lastIx = aix[j];
        }
        int j2 = lastIx + 1;
        while (j2 < len) {
            int n = j2++;
            c[n] = c[n] + val;
        }
    }

    public static double[] vectCumminWrite(double[] a, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        double val = 0.0;
        for (int j = 0; j < len; ++j) {
            c[j] = val = Math.min(val, a[ai + j]);
        }
        return c;
    }

    public static double[] vectCumminWrite(double[] a, int[] aix, int ai, int alen, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        double val = 0.0;
        int lastIx = -1;
        for (int j = ai; j < ai + alen; ++j) {
            Arrays.fill(c, lastIx + 1, aix[j], val);
            c[aix[j]] = val = Math.min(val, a[j]);
            lastIx = aix[j];
        }
        Arrays.fill(c, lastIx + 1, len, val);
        return c;
    }

    public static void vectCummaxAdd(double[] a, double[] c, int ai, int ci, int len) {
        double val = 0.0;
        for (int j = 0; j < len; ++j) {
            val = Math.max(val, a[ai * j]);
            int n = ci + j;
            c[n] = c[n] + val;
        }
    }

    public static void vectCummaxAdd(double[] a, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        double val = 0.0;
        int lastIx = -1;
        for (int j = ai; j < ai + alen; ++j) {
            int j2 = lastIx + 1;
            while (j2 < aix[j]) {
                int n = j2++;
                c[n] = c[n] + val;
            }
            c[aix[j]] = val = Math.max(val, a[j]);
            lastIx = aix[j];
        }
        int j2 = lastIx + 1;
        while (j2 < len) {
            int n = j2++;
            c[n] = c[n] + val;
        }
    }

    public static double[] vectCummaxWrite(double[] a, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        double val = 0.0;
        for (int j = 0; j < len; ++j) {
            c[j] = val = Math.max(val, a[ai + j]);
        }
        return c;
    }

    public static double[] vectCummaxWrite(double[] a, int[] aix, int ai, int alen, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        double val = 0.0;
        int lastIx = -1;
        for (int j = ai; j < ai + alen; ++j) {
            Arrays.fill(c, lastIx + 1, aix[j], val);
            c[aix[j]] = val = Math.max(val, a[j]);
            lastIx = aix[j];
        }
        Arrays.fill(c, lastIx + 1, len, val);
        return c;
    }

    public static void vectLogAdd(double[] a, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + Math.log(a[j]);
        }
    }

    public static void vectLogAdd(double[] a, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        for (int j = ai; j < ai + alen; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + Math.log(a[j]);
        }
    }

    public static double[] vectLogWrite(double[] a, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = Math.log(a[ai]);
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectLogWrite(double[] a, int[] aix, int ai, int alen, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true, Double.NEGATIVE_INFINITY);
        for (int j = ai; j < ai + alen; ++j) {
            c[aix[j]] = Math.log(a[j]);
        }
        return c;
    }

    public static void vectAbsAdd(double[] a, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + Math.abs(a[j]);
        }
    }

    public static void vectAbsAdd(double[] a, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        for (int j = ai; j < ai + alen; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + Math.abs(a[j]);
        }
    }

    public static double[] vectAbsWrite(double[] a, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = Math.abs(a[ai]);
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectAbsWrite(double[] a, int[] aix, int ai, int alen, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int j = ai; j < ai + alen; ++j) {
            c[aix[j]] = Math.abs(a[j]);
        }
        return c;
    }

    public static void vectRoundAdd(double[] a, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + (double)Math.round(a[j]);
        }
    }

    public static void vectRoundAdd(double[] a, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        for (int j = ai; j < ai + alen; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + (double)Math.round(a[j]);
        }
    }

    public static double[] vectRoundWrite(double[] a, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = Math.round(a[ai]);
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectRoundWrite(double[] a, int[] aix, int ai, int alen, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int j = ai; j < ai + alen; ++j) {
            c[aix[j]] = Math.round(a[j]);
        }
        return c;
    }

    public static void vectCeilAdd(double[] a, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + FastMath.ceil((double)a[j]);
        }
    }

    public static void vectCeilAdd(double[] a, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        for (int j = ai; j < ai + alen; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + FastMath.ceil((double)a[j]);
        }
    }

    public static double[] vectCeilWrite(double[] a, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = FastMath.ceil((double)a[ai]);
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectCeilWrite(double[] a, int[] aix, int ai, int alen, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int j = ai; j < ai + alen; ++j) {
            c[aix[j]] = FastMath.ceil((double)a[j]);
        }
        return c;
    }

    public static void vectFloorAdd(double[] a, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + FastMath.floor((double)a[j]);
        }
    }

    public static void vectFloorAdd(double[] a, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        for (int j = ai; j < ai + alen; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + FastMath.floor((double)a[j]);
        }
    }

    public static double[] vectFloorWrite(double[] a, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = FastMath.floor((double)a[ai]);
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectFloorWrite(double[] a, int[] aix, int ai, int alen, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int j = ai; j < ai + alen; ++j) {
            c[aix[j]] = FastMath.floor((double)a[j]);
        }
        return c;
    }

    public static void vectSinAdd(double[] a, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + FastMath.sin((double)a[j]);
        }
    }

    public static void vectSinAdd(double[] a, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        for (int j = ai; j < ai + alen; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + FastMath.sin((double)a[j]);
        }
    }

    public static double[] vectSinWrite(double[] a, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = FastMath.sin((double)a[ai]);
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectSinWrite(double[] a, int[] aix, int ai, int alen, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int j = ai; j < ai + alen; ++j) {
            c[aix[j]] = FastMath.sin((double)a[j]);
        }
        return c;
    }

    public static void vectCosAdd(double[] a, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + FastMath.cos((double)a[j]);
        }
    }

    public static void vectCosAdd(double[] a, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        for (int j = ai; j < ai + alen; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + FastMath.cos((double)a[j]);
        }
    }

    public static double[] vectCosWrite(double[] a, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = FastMath.cos((double)a[ai]);
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectCosWrite(double[] a, int[] aix, int ai, int alen, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true, 1.0);
        for (int j = ai; j < ai + alen; ++j) {
            c[aix[j]] = FastMath.cos((double)a[j]);
        }
        return c;
    }

    public static void vectTanAdd(double[] a, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + FastMath.tan((double)a[j]);
        }
    }

    public static void vectTanAdd(double[] a, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        for (int j = ai; j < ai + alen; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + FastMath.tan((double)a[j]);
        }
    }

    public static double[] vectTanWrite(double[] a, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = FastMath.tan((double)a[ai]);
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectTanWrite(double[] a, int[] aix, int ai, int alen, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int j = ai; j < ai + alen; ++j) {
            c[aix[j]] = FastMath.tan((double)a[j]);
        }
        return c;
    }

    public static void vectAsinAdd(double[] a, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + FastMath.asin((double)a[j]);
        }
    }

    public static void vectAsinAdd(double[] a, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        for (int j = ai; j < ai + alen; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + FastMath.asin((double)a[j]);
        }
    }

    public static double[] vectAsinWrite(double[] a, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = FastMath.asin((double)a[ai]);
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectAsinWrite(double[] a, int[] aix, int ai, int alen, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int j = ai; j < ai + alen; ++j) {
            c[aix[j]] = FastMath.asin((double)a[j]);
        }
        return c;
    }

    public static void vectAcosAdd(double[] a, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + FastMath.acos((double)a[j]);
        }
    }

    public static void vectAcosAdd(double[] a, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        for (int j = ai; j < ai + alen; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + FastMath.acos((double)a[j]);
        }
    }

    public static double[] vectAcosWrite(double[] a, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = FastMath.acos((double)a[ai]);
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectAcosWrite(double[] a, int[] aix, int ai, int alen, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true, 1.5707963267948966);
        for (int j = ai; j < ai + alen; ++j) {
            c[aix[j]] = FastMath.acos((double)a[j]);
        }
        return c;
    }

    public static void vectAtanAdd(double[] a, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + Math.atan(a[j]);
        }
    }

    public static void vectAtanAdd(double[] a, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        for (int j = ai; j < ai + alen; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + Math.atan(a[j]);
        }
    }

    public static double[] vectAtanWrite(double[] a, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = Math.atan(a[ai]);
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectAtanWrite(double[] a, int[] aix, int ai, int alen, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int j = ai; j < ai + alen; ++j) {
            c[aix[j]] = Math.atan(a[j]);
        }
        return c;
    }

    public static void vectSinhAdd(double[] a, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + FastMath.sinh((double)a[j]);
        }
    }

    public static void vectSinhAdd(double[] a, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        for (int j = ai; j < ai + alen; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + FastMath.sinh((double)a[j]);
        }
    }

    public static double[] vectSinhWrite(double[] a, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = FastMath.sinh((double)a[ai]);
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectSinhWrite(double[] a, int[] aix, int ai, int alen, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int j = ai; j < ai + alen; ++j) {
            c[aix[j]] = FastMath.sinh((double)a[j]);
        }
        return c;
    }

    public static void vectCoshAdd(double[] a, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + FastMath.cosh((double)a[j]);
        }
    }

    public static void vectCoshAdd(double[] a, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        for (int j = ai; j < ai + alen; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + FastMath.cosh((double)a[j]);
        }
    }

    public static double[] vectCoshWrite(double[] a, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = FastMath.cosh((double)a[ai]);
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectCoshWrite(double[] a, int[] aix, int ai, int alen, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true, 1.0);
        for (int j = ai; j < ai + alen; ++j) {
            c[aix[j]] = FastMath.cosh((double)a[j]);
        }
        return c;
    }

    public static void vectTanhAdd(double[] a, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + FastMath.tanh((double)a[j]);
        }
    }

    public static void vectTanhAdd(double[] a, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        for (int j = ai; j < ai + alen; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + FastMath.tanh((double)a[j]);
        }
    }

    public static double[] vectTanhWrite(double[] a, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = FastMath.tanh((double)a[ai]);
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectTanhWrite(double[] a, int[] aix, int ai, int alen, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int j = ai; j < ai + alen; ++j) {
            c[aix[j]] = FastMath.tanh((double)a[j]);
        }
        return c;
    }

    public static void vectSignAdd(double[] a, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + FastMath.signum((double)a[j]);
        }
    }

    public static void vectSignAdd(double[] a, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        for (int j = ai; j < ai + alen; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + FastMath.signum((double)a[j]);
        }
    }

    public static double[] vectSignWrite(double[] a, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = FastMath.signum((double)a[ai]);
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectSignWrite(double[] a, int[] aix, int ai, int alen, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int j = ai; j < ai + alen; ++j) {
            c[aix[j]] = FastMath.signum((double)a[j]);
        }
        return c;
    }

    public static void vectPow2Add(double[] a, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + a[j] * a[j];
        }
    }

    public static void vectPow2Add(double[] a, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        for (int j = ai; j < ai + alen; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + a[j] * a[j];
        }
    }

    public static double[] vectPow2Write(double[] a, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = a[ai] * a[ai];
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectPow2Write(double[] a, int[] aix, int ai, int alen, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int j = ai; j < ai + alen; ++j) {
            c[aix[j]] = a[j] * a[j];
        }
        return c;
    }

    public static void vectMult2Add(double[] a, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + (a[j] + a[j]);
        }
    }

    public static void vectMult2Add(double[] a, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        for (int j = ai; j < ai + alen; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + (a[j] + a[j]);
        }
    }

    public static double[] vectMult2Write(double[] a, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = a[ai] + a[ai];
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectMult2Write(double[] a, int[] aix, int ai, int alen, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int j = ai; j < ai + alen; ++j) {
            c[aix[j]] = a[j] + a[j];
        }
        return c;
    }

    public static void vectSqrtAdd(double[] a, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + Math.sqrt(a[j]);
        }
    }

    public static void vectSqrtAdd(double[] a, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        for (int j = ai; j < ai + alen; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + Math.sqrt(a[j]);
        }
    }

    public static double[] vectSqrtWrite(double[] a, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = Math.sqrt(a[ai]);
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectSqrtWrite(double[] a, int[] aix, int ai, int alen, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int j = ai; j < ai + alen; ++j) {
            c[aix[j]] = Math.sqrt(a[j]);
        }
        return c;
    }

    public static void vectSpropAdd(double[] a, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + a[j] * (1.0 - a[j]);
        }
    }

    public static void vectSpropAdd(double[] a, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        for (int j = ai; j < ai + alen; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + a[j] * (1.0 - a[j]);
        }
    }

    public static double[] vectSpropWrite(double[] a, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = a[j] * (1.0 - a[j]);
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectSpropWrite(double[] a, int[] aix, int ai, int alen, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int j = ai; j < ai + alen; ++j) {
            c[aix[j]] = a[j] * (1.0 - a[j]);
        }
        return c;
    }

    public static void vectSigmoidAdd(double[] a, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + 1.0 / (1.0 + FastMath.exp((double)(-a[j])));
        }
    }

    public static void vectSigmoidAdd(double[] a, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        for (int j = ai; j < ai + alen; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + 1.0 / (1.0 + FastMath.exp((double)(-a[j])));
        }
    }

    public static double[] vectSigmoidWrite(double[] a, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = 1.0 / (1.0 + FastMath.exp((double)(-a[j])));
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectSigmoidWrite(double[] a, int[] aix, int ai, int alen, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true, 0.5);
        for (int j = ai; j < ai + alen; ++j) {
            c[aix[j]] = 1.0 / (1.0 + FastMath.exp((double)(-a[j])));
        }
        return c;
    }

    public static void vectEqualAdd(double[] a, double bval, double[] c, int ai, int ci, int len) {
        int j = ai;
        while (j < ai + len) {
            int n = ci;
            c[n] = c[n] + (a[j] == bval ? 1.0 : 0.0);
            ++j;
            ++ci;
        }
    }

    public static void vectEqualAdd(double bval, double[] a, double[] c, int ai, int ci, int len) {
        LibSpoofPrimitives.vectEqualAdd(a, bval, c, ai, ci, len);
    }

    public static void vectEqualAdd(double[] a, double bval, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        if (bval == 0.0) {
            int j = 0;
            while (j < len) {
                int n = j++;
                c[n] = c[n] + 1.0;
            }
        } else {
            for (int j = ai; j < ai + alen; ++j) {
                int n = ci + aix[j];
                c[n] = c[n] + (a[j] == bval ? 1.0 : 0.0);
            }
        }
    }

    public static void vectEqualAdd(double bval, double[] a, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        LibSpoofPrimitives.vectEqualAdd(a, bval, c, aix, ai, ci, alen, len);
    }

    public static double[] vectEqualWrite(double[] a, double bval, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = a[ai] == bval ? 1.0 : 0.0;
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectEqualWrite(double bval, double[] a, int ai, int len) {
        return LibSpoofPrimitives.vectEqualWrite(a, bval, ai, len);
    }

    public static double[] vectEqualWrite(double[] a, double[] b, int ai, int bi, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = a[ai] == b[bi] ? 1.0 : 0.0;
            ++j;
            ++ai;
            ++bi;
        }
        return c;
    }

    public static double[] vectEqualWrite(double[] a, double bval, int[] aix, int ai, int alen, int len) {
        double init = bval == 0.0 ? 1.0 : 0.0;
        double[] c = LibSpoofPrimitives.allocVector(len, true, init);
        if (bval != 0.0) {
            for (int j = ai; j < ai + alen; ++j) {
                c[aix[j]] = a[j] == bval ? 1.0 : 0.0;
            }
        }
        return c;
    }

    public static double[] vectEqualWrite(double bval, double[] a, int[] aix, int ai, int alen, int len) {
        return LibSpoofPrimitives.vectEqualWrite(a, bval, aix, ai, alen, len);
    }

    public static double[] vectEqualWrite(double[] a, double[] b, int[] aix, int ai, int bi, int alen, int len) {
        int j;
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        for (j = 0; j < len; ++j) {
            c[j] = b[bi + j] == 0.0 ? 1.0 : 0.0;
        }
        for (j = ai; j < ai + alen; ++j) {
            c[aix[j]] = a[j] == b[bi + aix[j]] ? 1.0 : 0.0;
        }
        return c;
    }

    public static double[] vectEqualWrite(double[] a, double[] b, int ai, int[] bix, int bi, int blen, int len) {
        return LibSpoofPrimitives.vectEqualWrite(b, a, bix, bi, ai, blen, len);
    }

    public static void vectNotequalAdd(double[] a, double bval, double[] c, int ai, int ci, int len) {
        int j = ai;
        while (j < ai + len) {
            int n = ci;
            c[n] = c[n] + (a[j] != bval ? 1.0 : 0.0);
            ++j;
            ++ci;
        }
    }

    public static void vectNotequalAdd(double bval, double[] a, double[] c, int ai, int ci, int len) {
        LibSpoofPrimitives.vectNotequalAdd(a, bval, c, ai, ci, len);
    }

    public static void vectNotequalAdd(double[] a, double bval, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        if (bval != 0.0) {
            int j = 0;
            while (j < len) {
                int n = j++;
                c[n] = c[n] + 1.0;
            }
        }
        double init = bval != 0.0 ? 1.0 : 0.0;
        for (int j = ai; j < ai + alen; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + ((double)(a[j] != bval ? 1 : 0) - init);
        }
    }

    public static void vectNotequalAdd(double bval, double[] a, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        LibSpoofPrimitives.vectNotequalAdd(a, bval, c, aix, ai, ci, alen, len);
    }

    public static double[] vectNotequalWrite(double[] a, double bval, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = a[ai] != bval ? 1.0 : 0.0;
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectNotequalWrite(double bval, double[] a, int ai, int len) {
        return LibSpoofPrimitives.vectNotequalWrite(a, bval, ai, len);
    }

    public static double[] vectNotequalWrite(double[] a, double[] b, int ai, int bi, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = a[ai] != b[bi] ? 1.0 : 0.0;
            ++j;
            ++ai;
            ++bi;
        }
        return c;
    }

    public static double[] vectNotequalWrite(double[] a, double bval, int[] aix, int ai, int alen, int len) {
        double init = bval != 0.0 ? 1.0 : 0.0;
        double[] c = LibSpoofPrimitives.allocVector(len, true, init);
        for (int j = ai; j < ai + alen; ++j) {
            c[aix[j]] = a[j] != bval ? 1 : 0;
        }
        return c;
    }

    public static double[] vectNotequalWrite(double bval, double[] a, int[] aix, int ai, int alen, int len) {
        return LibSpoofPrimitives.vectNotequalWrite(a, bval, aix, ai, alen, len);
    }

    public static double[] vectNotequalWrite(double[] a, double[] b, int[] aix, int ai, int bi, int alen, int len) {
        int j;
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        for (j = 0; j < len; ++j) {
            c[j] = b[bi + j] != 0.0 ? 1.0 : 0.0;
        }
        for (j = ai; j < ai + alen; ++j) {
            c[aix[j]] = a[j] != b[bi + aix[j]] ? 1.0 : 0.0;
        }
        return c;
    }

    public static double[] vectNotequalWrite(double[] a, double[] b, int ai, int[] bix, int bi, int blen, int len) {
        return LibSpoofPrimitives.vectNotequalWrite(b, a, bix, bi, ai, blen, len);
    }

    public static void vectLessAdd(double[] a, double bval, double[] c, int ai, int ci, int len) {
        int j = ai;
        while (j < ai + len) {
            int n = ci;
            c[n] = c[n] + (a[j] < bval ? 1.0 : 0.0);
            ++j;
            ++ci;
        }
    }

    public static void vectLessAdd(double bval, double[] a, double[] c, int ai, int ci, int len) {
        LibSpoofPrimitives.vectGreaterequalAdd(a, bval, c, ai, ci, len);
    }

    public static void vectLessAdd(double[] a, double bval, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        if (bval > 0.0) {
            int j = 0;
            while (j < len) {
                int n = j++;
                c[n] = c[n] + 1.0;
            }
        }
        double init = bval > 0.0 ? 1.0 : 0.0;
        for (int j = ai; j < ai + alen; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + ((double)(a[j] < bval ? 1 : 0) - init);
        }
    }

    public static void vectLessAdd(double bval, double[] a, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        LibSpoofPrimitives.vectGreaterequalAdd(a, bval, c, aix, ai, ci, alen, len);
    }

    public static double[] vectLessWrite(double[] a, double bval, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = a[ai] < bval ? 1.0 : 0.0;
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectLessWrite(double bval, double[] a, int ai, int len) {
        return LibSpoofPrimitives.vectGreaterequalWrite(a, bval, ai, len);
    }

    public static double[] vectLessWrite(double[] a, double[] b, int ai, int bi, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = a[ai] < b[bi] ? 1.0 : 0.0;
            ++j;
            ++ai;
            ++bi;
        }
        return c;
    }

    public static double[] vectLessWrite(double[] a, double bval, int[] aix, int ai, int alen, int len) {
        double init = bval > 0.0 ? 1.0 : 0.0;
        double[] c = LibSpoofPrimitives.allocVector(len, true, init);
        for (int j = ai; j < ai + alen; ++j) {
            c[aix[j]] = a[j] < bval ? 1.0 : 0.0;
        }
        return c;
    }

    public static double[] vectLessWrite(double bval, double[] a, int[] aix, int ai, int alen, int len) {
        return LibSpoofPrimitives.vectGreaterequalWrite(a, bval, aix, ai, alen, len);
    }

    public static double[] vectLessWrite(double[] a, double[] b, int[] aix, int ai, int bi, int alen, int len) {
        int j;
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        for (j = 0; j < len; ++j) {
            c[j] = 0.0 < b[bi + j] ? 1.0 : 0.0;
        }
        for (j = ai; j < ai + alen; ++j) {
            c[aix[j]] = a[j] < b[bi + aix[j]] ? 1.0 : 0.0;
        }
        return c;
    }

    public static double[] vectLessWrite(double[] a, double[] b, int ai, int[] bix, int bi, int blen, int len) {
        return LibSpoofPrimitives.vectGreaterequalWrite(b, a, bix, bi, ai, blen, len);
    }

    public static void vectLessequalAdd(double[] a, double bval, double[] c, int ai, int ci, int len) {
        int j = ai;
        while (j < ai + len) {
            int n = ci;
            c[n] = c[n] + (a[j] <= bval ? 1.0 : 0.0);
            ++j;
            ++ci;
        }
    }

    public static void vectLessequalAdd(double bval, double[] a, double[] c, int ai, int ci, int len) {
        LibSpoofPrimitives.vectGreaterAdd(a, bval, c, ai, ci, len);
    }

    public static void vectLessequalAdd(double[] a, double bval, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        if (bval >= 0.0) {
            int j = 0;
            while (j < len) {
                int n = j++;
                c[n] = c[n] + 1.0;
            }
        }
        double init = bval >= 0.0 ? 1.0 : 0.0;
        for (int j = ai; j < ai + alen; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + ((double)(a[j] <= bval ? 1 : 0) - init);
        }
    }

    public static void vectLessequalAdd(double bval, double[] a, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        LibSpoofPrimitives.vectGreaterAdd(a, bval, c, aix, ai, ci, alen, len);
    }

    public static double[] vectLessequalWrite(double[] a, double bval, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = a[ai] <= bval ? 1.0 : 0.0;
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectLessequalWrite(double bval, double[] a, int ai, int len) {
        return LibSpoofPrimitives.vectGreaterWrite(a, bval, ai, len);
    }

    public static double[] vectLessequalWrite(double[] a, double[] b, int ai, int bi, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = a[ai] <= b[bi] ? 1.0 : 0.0;
            ++j;
            ++ai;
            ++bi;
        }
        return c;
    }

    public static double[] vectLessequalWrite(double[] a, double bval, int[] aix, int ai, int alen, int len) {
        double init = bval >= 0.0 ? 1.0 : 0.0;
        double[] c = LibSpoofPrimitives.allocVector(len, true, init);
        for (int j = ai; j < ai + alen; ++j) {
            c[aix[j]] = a[j] <= bval ? 1 : 0;
        }
        return c;
    }

    public static double[] vectLessequalWrite(double bval, double[] a, int[] aix, int ai, int alen, int len) {
        return LibSpoofPrimitives.vectGreaterWrite(a, bval, aix, ai, alen, len);
    }

    public static double[] vectLessequalWrite(double[] a, double[] b, int[] aix, int ai, int bi, int alen, int len) {
        int j;
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        for (j = 0; j < len; ++j) {
            c[j] = 0.0 <= b[bi + j] ? 1.0 : 0.0;
        }
        for (j = ai; j < ai + alen; ++j) {
            c[aix[j]] = a[j] <= b[bi + aix[j]] ? 1.0 : 0.0;
        }
        return c;
    }

    public static double[] vectLessequalWrite(double[] a, double[] b, int ai, int[] bix, int bi, int blen, int len) {
        return LibSpoofPrimitives.vectGreaterWrite(b, a, bix, bi, ai, blen, len);
    }

    public static void vectGreaterAdd(double[] a, double bval, double[] c, int ai, int ci, int len) {
        int j = ai;
        while (j < ai + len) {
            int n = ci;
            c[n] = c[n] + (a[j] > bval ? 1.0 : 0.0);
            ++j;
            ++ci;
        }
    }

    public static void vectGreaterAdd(double bval, double[] a, double[] c, int ai, int ci, int len) {
        LibSpoofPrimitives.vectLessequalAdd(a, bval, c, ai, ci, len);
    }

    public static void vectGreaterAdd(double[] a, double bval, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        if (bval < 0.0) {
            int j = 0;
            while (j < len) {
                int n = j++;
                c[n] = c[n] + 1.0;
            }
        }
        double init = bval < 0.0 ? 1.0 : 0.0;
        for (int j = ai; j < ai + alen; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + ((double)(a[j] > bval ? 1 : 0) - init);
        }
    }

    public static void vectGreaterAdd(double bval, double[] a, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        LibSpoofPrimitives.vectLessequalAdd(a, bval, c, aix, ai, ci, alen, len);
    }

    public static double[] vectGreaterWrite(double[] a, double bval, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = a[ai] > bval ? 1.0 : 0.0;
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectGreaterWrite(double bval, double[] a, int ai, int len) {
        return LibSpoofPrimitives.vectLessWrite(a, bval, ai, len);
    }

    public static double[] vectGreaterWrite(double[] a, double[] b, int ai, int bi, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = a[ai] > b[bi] ? 1.0 : 0.0;
            ++j;
            ++ai;
            ++bi;
        }
        return c;
    }

    public static double[] vectGreaterWrite(double[] a, double bval, int[] aix, int ai, int alen, int len) {
        double init = bval < 0.0 ? 1.0 : 0.0;
        double[] c = LibSpoofPrimitives.allocVector(len, true, init);
        for (int j = ai; j < ai + alen; ++j) {
            c[aix[j]] = a[j] > bval ? 1 : 0;
        }
        return c;
    }

    public static double[] vectGreaterWrite(double bval, double[] a, int[] aix, int ai, int alen, int len) {
        return LibSpoofPrimitives.vectLessequalWrite(a, bval, aix, ai, alen, len);
    }

    public static double[] vectGreaterWrite(double[] a, double[] b, int[] aix, int ai, int bi, int alen, int len) {
        int j;
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        for (j = 0; j < len; ++j) {
            c[j] = 0.0 > b[bi + j] ? 1.0 : 0.0;
        }
        for (j = ai; j < ai + alen; ++j) {
            c[aix[j]] = a[j] > b[bi + aix[j]] ? 1.0 : 0.0;
        }
        return c;
    }

    public static double[] vectGreaterWrite(double[] a, double[] b, int ai, int[] bix, int bi, int blen, int len) {
        return LibSpoofPrimitives.vectLessequalWrite(b, a, bix, bi, ai, blen, len);
    }

    public static void vectGreaterequalAdd(double[] a, double bval, double[] c, int ai, int ci, int len) {
        int j = ai;
        while (j < ai + len) {
            int n = ci;
            c[n] = c[n] + (a[j] >= bval ? 1.0 : 0.0);
            ++j;
            ++ci;
        }
    }

    public static void vectGreaterequalAdd(double bval, double[] a, double[] c, int ai, int ci, int len) {
        LibSpoofPrimitives.vectLessAdd(a, bval, c, ai, ci, len);
    }

    public static void vectGreaterequalAdd(double[] a, double bval, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        if (bval <= 0.0) {
            int j = 0;
            while (j < len) {
                int n = j++;
                c[n] = c[n] + 1.0;
            }
        }
        double init = bval <= 0.0 ? 1.0 : 0.0;
        for (int j = ai; j < ai + alen; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + ((double)(a[j] >= bval ? 1 : 0) - init);
        }
    }

    public static void vectGreaterequalAdd(double bval, double[] a, double[] c, int[] aix, int ai, int ci, int alen, int len) {
        LibSpoofPrimitives.vectLessAdd(a, bval, c, aix, ai, ci, alen, len);
    }

    public static double[] vectGreaterequalWrite(double[] a, double bval, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = a[ai] >= bval ? 1.0 : 0.0;
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectGreaterequalWrite(double bval, double[] a, int ai, int len) {
        return LibSpoofPrimitives.vectLessWrite(a, bval, ai, len);
    }

    public static double[] vectGreaterequalWrite(double[] a, double[] b, int ai, int bi, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = a[ai] >= b[bi] ? 1.0 : 0.0;
            ++j;
            ++ai;
            ++bi;
        }
        return c;
    }

    public static double[] vectGreaterequalWrite(double[] a, double bval, int[] aix, int ai, int alen, int len) {
        double init = bval < 0.0 ? 1.0 : 0.0;
        double[] c = LibSpoofPrimitives.allocVector(len, true, init);
        for (int j = ai; j < ai + alen; ++j) {
            c[aix[j]] = (double)(a[j] >= bval ? 1 : 0) - init;
        }
        return c;
    }

    public static double[] vectGreaterequalWrite(double bval, double[] a, int[] aix, int ai, int alen, int len) {
        return LibSpoofPrimitives.vectLessWrite(a, bval, aix, ai, alen, len);
    }

    public static double[] vectGreaterequalWrite(double[] a, double[] b, int[] aix, int ai, int bi, int alen, int len) {
        int j;
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        for (j = 0; j < len; ++j) {
            c[j] = 0.0 >= b[bi + j] ? 1.0 : 0.0;
        }
        for (j = ai; j < ai + alen; ++j) {
            c[aix[j]] = a[j] >= b[bi + aix[j]] ? 1.0 : 0.0;
        }
        return c;
    }

    public static double[] vectGreaterequalWrite(double[] a, double[] b, int ai, int[] bix, int bi, int blen, int len) {
        return LibSpoofPrimitives.vectLessWrite(b, a, bix, bi, ai, blen, len);
    }

    public static double[] vectBitwandWrite(double[] a, double bval, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        for (int j = 0; j < len; ++j) {
            c[j] = LibSpoofPrimitives.bwAnd(a[ai + j], bval);
        }
        return c;
    }

    public static double[] vectBitwandWrite(double bval, double[] a, int ai, int len) {
        return LibSpoofPrimitives.vectBitwandWrite(a, bval, ai, len);
    }

    public static double[] vectBitwandWrite(double[] a, double[] b, int ai, int bi, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        for (int j = 0; j < len; ++j) {
            c[j] = LibSpoofPrimitives.bwAnd(a[ai + j], b[bi + j]);
        }
        return c;
    }

    public static double[] vectBitwandWrite(double[] a, double bval, int[] aix, int ai, int alen, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        int bval1 = (int)bval;
        for (int j = ai; j < ai + alen; ++j) {
            c[aix[j]] = LibSpoofPrimitives.bwAnd(a[j], bval1);
        }
        return c;
    }

    public static double[] vectBitwandWrite(double bval, double[] a, int[] aix, int ai, int alen, int len) {
        return LibSpoofPrimitives.vectBitwandWrite(a, bval, aix, ai, alen, len);
    }

    public static double[] vectBitwandWrite(double[] a, double[] b, int[] aix, int ai, int bi, int alen, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int j = ai; j < ai + alen; ++j) {
            c[aix[j]] = LibSpoofPrimitives.bwAnd(a[j], b[bi + aix[j]]);
        }
        return c;
    }

    public static double[] vectBitwandWrite(double[] a, double[] b, int ai, int[] aix, int bi, int alen, int len) {
        return LibSpoofPrimitives.vectBitwandWrite(a, b, aix, ai, bi, alen, len);
    }

    public static double[] vectBiasaddWrite(double[] a, double[] b, int ai, int bi, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        System.arraycopy(a, ai, c, 0, len);
        LibMatrixDNN.addBias(c, b, 1.0, 1, b.length, len / b.length);
        return c;
    }

    public static double[] vectBiasaddWrite(double[] a, double[] b, int[] aix, int ai, int bi, int alen, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int k = ai; k < ai + alen; ++k) {
            c[aix[k]] = a[k];
        }
        LibMatrixDNN.addBias(c, b, 1.0, 1, b.length, len / b.length);
        return c;
    }

    public static double[] vectBiasmultWrite(double[] a, double[] b, int ai, int bi, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        System.arraycopy(a, ai, c, 0, len);
        LibMatrixDNN.multBias(c, b, 1, b.length, len / b.length);
        return c;
    }

    public static double[] vectBiasmultWrite(double[] a, double[] b, int[] aix, int ai, int bi, int alen, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int k = ai; k < ai + alen; ++k) {
            c[aix[k]] = a[k];
        }
        LibMatrixDNN.multBias(c, b, 1, b.length, len / b.length);
        return c;
    }

    public static double[] vectMaxpoolWrite(double[] a, int ai, int len, int rix, int C, int P, int Q, int K, int R, int S, int H, int W) {
        double[] c = LibSpoofPrimitives.allocVector(C * P * Q, true);
        LibMatrixDNNPooling.poolingDenseStride1Pad0(LibMatrixDNN.PoolingType.MAX, -1.7976931348623157E308, 1.0, a, c, rix, rix + 1, ai, 0, C, P, Q, R, S, H, W);
        return c;
    }

    public static double[] vectMaxpoolWrite(double[] avals, int[] aix, int ai, int alen, int len, int rix, int C, int P, int Q, int K, int R, int S, int H, int W) {
        double[] a = LibSpoofPrimitives.allocVector(len, true);
        double[] c = LibSpoofPrimitives.allocVector(C * P * Q, true);
        for (int k = ai; k < ai + alen; ++k) {
            a[aix[k]] = avals[k];
        }
        LibMatrixDNNPooling.poolingDenseStride1Pad0(LibMatrixDNN.PoolingType.MAX, -1.7976931348623157E308, 1.0, a, c, rix, rix + 1, 0, 0, C, P, Q, R, S, H, W);
        return c;
    }

    public static double[] vectAvgpoolWrite(double[] a, int ai, int len, int rix, int C, int P, int Q, int K, int R, int S, int H, int W) {
        double[] c = LibSpoofPrimitives.allocVector(C * P * Q, true);
        LibMatrixDNNPooling.poolingDenseStride1Pad0(LibMatrixDNN.PoolingType.AVG, 0.0, 1 / (R * S), a, c, rix, rix + 1, ai, 0, C, P, Q, R, S, H, W);
        return c;
    }

    public static double[] vectAvgpoolWrite(double[] avals, int[] aix, int ai, int alen, int len, int rix, int C, int P, int Q, int K, int R, int S, int H, int W) {
        double[] a = LibSpoofPrimitives.allocVector(len, true);
        double[] c = LibSpoofPrimitives.allocVector(C * P * Q, true);
        for (int k = ai; k < ai + alen; ++k) {
            a[aix[k]] = avals[k];
        }
        LibMatrixDNNPooling.poolingDenseStride1Pad0(LibMatrixDNN.PoolingType.AVG, 0.0, 1 / (R * S), a, c, rix, rix + 1, 0, 0, C, P, Q, R, S, H, W);
        return c;
    }

    public static double[] vectIm2colWrite(double[] a, int ai, int len, int rix, int C, int P, int Q, int K, int R, int S, int H, int W) {
        double[] c = LibSpoofPrimitives.allocVector(C * R * S * P * Q, true);
        LibMatrixDNNIm2Col.im2colDenseStride1Pad0(a, c, ai, C, R, S, H, W, P, Q);
        return c;
    }

    public static double[] vectIm2colWrite(double[] avals, int[] aix, int ai, int alen, int len, int rix, int C, int P, int Q, int K, int R, int S, int H, int W) {
        double[] a = LibSpoofPrimitives.allocVector(len, true);
        double[] c = LibSpoofPrimitives.allocVector(C * R * S * P * Q, true);
        for (int k = ai; k < ai + alen; ++k) {
            a[aix[k]] = avals[k];
        }
        LibMatrixDNNIm2Col.im2colDenseStride1Pad0(a, c, ai, C, R, S, H, W, P, Q);
        return c;
    }

    public static double[] vectConv2dmmWrite(double[] a, double[] b, int ai, int bi, int len, int rix, int C, int P, int Q, int K, int R, int S, int H, int W) {
        double[] c = LibSpoofPrimitives.allocVector(K * P * Q, true);
        int CRS = C * R * S;
        int PQ = P * Q;
        LibMatrixMult.matrixMultDenseDenseMM(new DenseBlockFP64(new int[]{K, CRS}, a), new DenseBlockFP64(new int[]{CRS, PQ}, b), new DenseBlockFP64(new int[]{K, PQ}, c), PQ, CRS, 0, K, 0, PQ);
        return c;
    }

    public static double intDiv(double in1, double in2) {
        return intDiv.execute(in1, in2);
    }

    public static double mod(double in1, double in2) {
        return mod.execute(in1, in2);
    }

    public static double bwAnd(double in1, double in2) {
        return bwAnd.execute(in1, in2);
    }

    public static boolean isFlipOuter(int len1, int len2) {
        return len1 > 64 * len2;
    }

    public static void setupThreadLocalMemory(int numVectors, int len) {
        if (numVectors > 0) {
            LibSpoofPrimitives.setupThreadLocalMemory(numVectors, len, -1);
        }
    }

    public static void setupThreadLocalMemory(int numVectors, int len, int len2) {
        if (numVectors > 0) {
            memPool.set(new VectorBuffer(numVectors, len, len2));
        }
    }

    public static void cleanupThreadLocalMemory() {
        memPool.remove();
    }

    public static double[] allocVector(int len, boolean reset) {
        return LibSpoofPrimitives.allocVector(len, reset, 0.0);
    }

    protected static double[] allocVector(int len, boolean reset, double resetVal) {
        VectorBuffer buff = memPool.get();
        double[] vect = buff.next(len);
        if (vect == null) {
            vect = new double[len];
        }
        if (reset) {
            Arrays.fill(vect, resetVal);
        }
        return vect;
    }

    private static class VectorBuffer {
        private static final int MAX_SIZE = 524288;
        private final double[][] _data;
        private int _pos;
        private int _len1;
        private int _len2;

        public VectorBuffer(int num, int len1, int len2) {
            len1 = Math.min(len1, 524288);
            len2 = Math.min(len2, 524288);
            int lnum = len2 > 0 && len1 != len2 ? 2 * num : num;
            this._data = new double[lnum][];
            for (int i = 0; i < num; ++i) {
                if (lnum > num) {
                    this._data[2 * i] = new double[len1];
                    this._data[2 * i + 1] = new double[len2];
                    continue;
                }
                this._data[i] = new double[len1];
            }
            this._pos = -1;
            this._len1 = len1;
            this._len2 = len2;
        }

        public double[] next(int len) {
            if (this._len1 != len && this._len2 != len) {
                return null;
            }
            do {
                int n = this._pos = this._pos + 1 >= this._data.length ? 0 : this._pos + 1;
            } while (this._data[this._pos].length != len);
            return this._data[this._pos];
        }

        public boolean isReusable(int num, int len1, int len2) {
            int lnum = len2 > 0 && len1 != len2 ? 2 * num : num;
            return this._len1 == len1 && this._len2 == len2 && this._data.length == lnum;
        }
    }
}

