/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.estim.AComEst;
import org.apache.sysds.runtime.compress.estim.ComEstExact;
import org.apache.sysds.runtime.compress.estim.ComEstSample;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public interface ComEstFactory {
    public static final Log LOG = LogFactory.getLog((String)ComEstFactory.class.getName());

    public static AComEst createEstimator(MatrixBlock data, CompressionSettings cs, int k) {
        int nRows = cs.transposed ? data.getNumColumns() : data.getNumRows();
        int nCols = cs.transposed ? data.getNumRows() : data.getNumColumns();
        double sparsity = data.getSparsity();
        int sampleSize = ComEstFactory.getSampleSize(cs, nRows, nCols, sparsity);
        if (data.isEmpty()) {
            return ComEstFactory.createExactEstimator(data, cs);
        }
        return ComEstFactory.createEstimator(data, cs, sampleSize, k, nRows);
    }

    public static AComEst createEstimator(MatrixBlock data, CompressionSettings cs, int sampleSize, int k) {
        int nRows = cs.transposed ? data.getNumColumns() : data.getNumRows();
        return ComEstFactory.createEstimator(data, cs, sampleSize, k, nRows);
    }

    private static AComEst createEstimator(MatrixBlock data, CompressionSettings cs, int sampleSize, int k, int nRows) {
        if ((double)sampleSize >= (double)nRows * 0.8) {
            return ComEstFactory.createExactEstimator(data, cs);
        }
        return ComEstFactory.createSampleEstimator(data, cs, sampleSize, k);
    }

    private static ComEstExact createExactEstimator(MatrixBlock data, CompressionSettings cs) {
        LOG.debug((Object)"Using full sample");
        return new ComEstExact(data, cs);
    }

    private static ComEstSample createSampleEstimator(MatrixBlock data, CompressionSettings cs, int sampleSize, int k) {
        LOG.debug((Object)("Using sample size: " + sampleSize));
        return new ComEstSample(data, cs, sampleSize, k);
    }

    private static int getSampleSize(CompressionSettings cs, int nRows, int nCols, double sparsity) {
        int maxSize = Math.min(cs.maxSampleSize, nRows);
        return ComEstFactory.getSampleSize(cs.samplePower, nRows, nCols, sparsity, cs.minimumSampleSize, maxSize);
    }

    private static int getSampleSize(double samplePower, int nRows, int nCols, double sparsity, int minSampleSize, int maxSampleSize) {
        int sampleSize = minSampleSize;
        samplePower = Math.max(0.0, Math.min(1.0, samplePower));
        sampleSize += (int)Math.ceil(Math.pow(nRows, samplePower));
        sampleSize = (int)((double)sampleSize * (1.0 / Math.min(sparsity + 0.2, 1.0)));
        sampleSize = Math.max(minSampleSize, Math.min(sampleSize, maxSampleSize));
        return sampleSize;
    }
}

