/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.iogen;

import java.io.Serializable;
import java.util.HashSet;

public class FastStringTokenizer
implements Serializable {
    private static final long serialVersionUID = -4698672725609750097L;
    private String _string = null;
    private String _del = "";
    private int _pos = -1;
    private int _index = 0;
    private HashSet<String> naStrings = null;

    public FastStringTokenizer(String delimiter) {
        this._del = delimiter;
        this.reset(null);
    }

    public void reset(String string) {
        this._string = string;
        this._pos = 0;
        this._index = 0;
    }

    public String nextToken() {
        int len = this._string.length();
        int start = this._pos;
        if (this._pos == -1) {
            this._index = -1;
            return "0";
        }
        while (start < len && this._del.equals(this._string.substring(start, Math.min(start + this._del.length(), this._string.length())))) {
            start += this._del.length();
            ++this._index;
        }
        if (start < len) {
            this._pos = this._string.indexOf(this._del, start);
            if (start < this._pos && this._pos < len) {
                return this._string.substring(start, this._pos);
            }
            return this._string.substring(start);
        }
        this._index = -1;
        return null;
    }

    public int nextInt() {
        return Integer.parseInt(this.nextToken());
    }

    public long nextLong() {
        return Long.parseLong(this.nextToken());
    }

    public double nextDouble() {
        String nt = this.nextToken();
        if (this.naStrings != null && this.naStrings.contains(nt) || nt == null) {
            return 0.0;
        }
        return Double.parseDouble(nt);
    }

    public int getIndex() {
        return this._index;
    }

    public void setNaStrings(HashSet<String> naStrings) {
        this.naStrings = naStrings;
    }
}

