/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import com.google.common.base.Charsets;
import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import org.apache.tez.runtime.api.events.CompositeDataMovementEvent;
import org.apache.tez.runtime.api.events.CompositeRoutedDataMovementEvent;
import org.apache.tez.runtime.api.events.CustomProcessorEvent;
import org.apache.tez.runtime.api.events.DataMovementEvent;
import org.apache.tez.runtime.api.events.EventProtos;
import org.apache.tez.runtime.api.events.InputDataInformationEvent;
import org.apache.tez.runtime.api.events.InputInitializerEvent;
import org.apache.tez.runtime.api.events.VertexManagerEvent;

public final class ProtoConverters {
    public static EventProtos.CustomProcessorEventProto convertCustomProcessorEventToProto(CustomProcessorEvent event) {
        EventProtos.CustomProcessorEventProto.Builder builder = EventProtos.CustomProcessorEventProto.newBuilder();
        if (event.getPayload() != null) {
            builder.setUserPayload(ByteString.copyFrom((ByteBuffer)event.getPayload()));
        }
        builder.setVersion(event.getVersion());
        return builder.build();
    }

    public static CustomProcessorEvent convertCustomProcessorEventFromProto(EventProtos.CustomProcessorEventProto proto) {
        return CustomProcessorEvent.create((ByteBuffer)(proto.getUserPayload() != null ? proto.getUserPayload().asReadOnlyByteBuffer() : null), (int)proto.getVersion());
    }

    public static EventProtos.DataMovementEventProto convertDataMovementEventToProto(DataMovementEvent event) {
        EventProtos.DataMovementEventProto.Builder builder = EventProtos.DataMovementEventProto.newBuilder();
        builder.setSourceIndex(event.getSourceIndex()).setTargetIndex(event.getTargetIndex()).setVersion(event.getVersion());
        if (event.getUserPayload() != null) {
            builder.setUserPayload(ByteString.copyFrom((ByteBuffer)event.getUserPayload()));
        }
        return builder.build();
    }

    public static DataMovementEvent convertDataMovementEventFromProto(EventProtos.DataMovementEventProto proto) {
        return DataMovementEvent.create((int)proto.getSourceIndex(), (int)proto.getTargetIndex(), (int)proto.getVersion(), proto.getUserPayload() != null ? proto.getUserPayload().asReadOnlyByteBuffer() : null);
    }

    public static EventProtos.CompositeRoutedDataMovementEventProto convertCompositeRoutedDataMovementEventToProto(CompositeRoutedDataMovementEvent event) {
        EventProtos.CompositeRoutedDataMovementEventProto.Builder builder = EventProtos.CompositeRoutedDataMovementEventProto.newBuilder();
        builder.setSourceIndex(event.getSourceIndex()).setTargetIndex(event.getTargetIndex()).setVersion(event.getVersion()).setCount(event.getCount());
        if (event.getUserPayload() != null) {
            builder.setUserPayload(ByteString.copyFrom((ByteBuffer)event.getUserPayload()));
        }
        return builder.build();
    }

    public static CompositeRoutedDataMovementEvent convertCompositeRoutedDataMovementEventFromProto(EventProtos.CompositeRoutedDataMovementEventProto proto) {
        return CompositeRoutedDataMovementEvent.create((int)proto.getSourceIndex(), (int)proto.getTargetIndex(), (int)proto.getCount(), (int)proto.getVersion(), proto.getUserPayload() != null ? proto.getUserPayload().asReadOnlyByteBuffer() : null);
    }

    public static EventProtos.CompositeEventProto convertCompositeDataMovementEventToProto(CompositeDataMovementEvent event) {
        EventProtos.CompositeEventProto.Builder builder = EventProtos.CompositeEventProto.newBuilder();
        builder.setStartIndex(event.getSourceIndexStart());
        builder.setCount(event.getCount());
        if (event.getUserPayload() != null) {
            builder.setUserPayload(ByteString.copyFrom((ByteBuffer)event.getUserPayload()));
        }
        return builder.build();
    }

    public static CompositeDataMovementEvent convertCompositeDataMovementEventFromProto(EventProtos.CompositeEventProto proto) {
        return CompositeDataMovementEvent.create((int)proto.getStartIndex(), (int)proto.getCount(), proto.hasUserPayload() ? proto.getUserPayload().asReadOnlyByteBuffer() : null);
    }

    public static EventProtos.VertexManagerEventProto convertVertexManagerEventToProto(VertexManagerEvent event) {
        EventProtos.VertexManagerEventProto.Builder vmBuilder = EventProtos.VertexManagerEventProto.newBuilder();
        vmBuilder.setTargetVertexName(event.getTargetVertexName());
        if (event.getUserPayload() != null) {
            vmBuilder.setUserPayload(ByteString.copyFrom((ByteBuffer)event.getUserPayload()));
        }
        return vmBuilder.build();
    }

    public static VertexManagerEvent convertVertexManagerEventFromProto(EventProtos.VertexManagerEventProto vmProto) {
        return VertexManagerEvent.create((String)vmProto.getTargetVertexName(), vmProto.hasUserPayload() ? vmProto.getUserPayload().asReadOnlyByteBuffer() : null);
    }

    public static EventProtos.RootInputDataInformationEventProto convertRootInputDataInformationEventToProto(InputDataInformationEvent event) {
        EventProtos.RootInputDataInformationEventProto.Builder builder = EventProtos.RootInputDataInformationEventProto.newBuilder();
        builder.setSourceIndex(event.getSourceIndex());
        builder.setTargetIndex(event.getTargetIndex());
        if (event.getUserPayload() != null) {
            builder.setUserPayload(ByteString.copyFrom((ByteBuffer)event.getUserPayload()));
        }
        if (event.getSerializedPath() != null) {
            builder.setSerializedPath(ByteString.copyFrom((byte[])event.getSerializedPath().getBytes(Charsets.UTF_8)));
        }
        return builder.build();
    }

    public static InputDataInformationEvent convertRootInputDataInformationEventFromProto(EventProtos.RootInputDataInformationEventProto proto) {
        ByteBuffer payload = proto.hasUserPayload() ? proto.getUserPayload().asReadOnlyByteBuffer() : null;
        InputDataInformationEvent diEvent = null;
        diEvent = proto.hasSerializedPath() ? InputDataInformationEvent.createWithSerializedPath((int)proto.getSourceIndex(), (String)proto.getSerializedPath().toStringUtf8()) : InputDataInformationEvent.createWithSerializedPayload((int)proto.getSourceIndex(), (ByteBuffer)payload);
        diEvent.setTargetIndex(proto.getTargetIndex());
        return diEvent;
    }

    public static EventProtos.RootInputInitializerEventProto convertRootInputInitializerEventToProto(InputInitializerEvent event) {
        EventProtos.RootInputInitializerEventProto.Builder builder = EventProtos.RootInputInitializerEventProto.newBuilder();
        builder.setTargetVertexName(event.getTargetVertexName());
        builder.setTargetInputName(event.getTargetInputName());
        if (event.getUserPayload() != null) {
            builder.setUserPayload(ByteString.copyFrom((ByteBuffer)event.getUserPayload()));
        }
        return builder.build();
    }

    public static InputInitializerEvent convertRootInputInitializerEventFromProto(EventProtos.RootInputInitializerEventProto proto) {
        InputInitializerEvent event = InputInitializerEvent.create((String)proto.getTargetVertexName(), (String)proto.getTargetInputName(), proto.hasUserPayload() ? proto.getUserPayload().asReadOnlyByteBuffer() : null);
        return event;
    }

    private ProtoConverters() {
    }
}

