/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Shape;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.DoubleUnaryOperator;
import org.apache.sis.coverage.Category;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.j2d.ColorModelFactory;
import org.apache.sis.coverage.grid.j2d.ImageUtilities;
import org.apache.sis.image.ImageAdapter;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.math.Statistics;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.internal.Numerics;
import org.apache.sis.util.resources.Errors;

final class RecoloredImage
extends ImageAdapter {
    private final ColorModel colors;
    final double minimum;
    final double maximum;

    private RecoloredImage(RenderedImage source, ColorModel colors, double minimum, double maximum) {
        super(source);
        this.colors = colors;
        this.minimum = minimum;
        this.maximum = maximum;
    }

    static RenderedImage applySameColors(RenderedImage source, RenderedImage colored) {
        ColorModel colors = colored.getColorModel();
        if (colors == null) {
            return source;
        }
        RecoloredImage expected = null;
        while (colored instanceof ImageAdapter) {
            if (colored instanceof RecoloredImage) {
                expected = (RecoloredImage)colored;
                break;
            }
            colored = ((ImageAdapter)colored).source;
        }
        while (true) {
            if (colors.equals(source.getColorModel())) {
                if (expected != null && source instanceof RecoloredImage) {
                    RecoloredImage actual = (RecoloredImage)source;
                    if (!Numerics.equals(expected.minimum, actual.minimum) || !Numerics.equals(expected.maximum, actual.maximum)) continue;
                }
                return source;
            }
            if (!(source instanceof RecoloredImage)) break;
            source = ((RecoloredImage)source).source;
        }
        RecoloredImage image = expected != null ? new RecoloredImage(source, colors, expected.minimum, expected.maximum) : new RecoloredImage(source, colors, Double.NaN, Double.NaN);
        return ImageProcessor.unique(image);
    }

    static RenderedImage stretchColorRamp(ImageProcessor processor, RenderedImage source, Map<String, ?> modifiers) {
        ColorModel cm;
        int visibleBand = ImageUtilities.getVisibleBand(source);
        if (visibleBand < 0) {
            return source;
        }
        RenderedImage statsSource = source;
        Statistics[] statsAllBands = null;
        Statistics statistics = null;
        Shape areaOfInterest = null;
        Number[] nodataValues = null;
        SampleDimension range = null;
        double minimum = Double.NaN;
        double maximum = Double.NaN;
        double deviations = Double.POSITIVE_INFINITY;
        if (modifiers != null) {
            Number minValue = Containers.property(modifiers, "minimum", Number.class);
            Number maxValue = Containers.property(modifiers, "maximum", Number.class);
            if (minValue != null) {
                minimum = minValue.doubleValue();
            }
            if (maxValue != null) {
                maximum = maxValue.doubleValue();
            }
            if (minimum >= maximum) {
                throw new IllegalArgumentException(Errors.format((short)60, minValue, maxValue));
            }
            Number value = Containers.property(modifiers, "multStdDev", Number.class);
            if (value != null) {
                deviations = value.doubleValue();
                ArgumentChecks.ensureStrictlyPositive("multStdDev", deviations);
            }
            areaOfInterest = Containers.property(modifiers, "areaOfInterest", Shape.class);
            value = modifiers.get("nodataValues");
            if (value != null) {
                if (value instanceof Number) {
                    nodataValues = new Number[]{value};
                } else if (value instanceof Number[]) {
                    nodataValues = (Number[])value;
                } else {
                    throw RecoloredImage.illegalPropertyType(modifiers, "nodataValues", value);
                }
            }
            if ((value = modifiers.get("statistics")) != null) {
                if (value instanceof RenderedImage) {
                    statsSource = (RenderedImage)((Object)value);
                } else if (value instanceof Statistics) {
                    statistics = (Statistics)((Object)value);
                } else if (value instanceof Statistics[]) {
                    statsAllBands = (Statistics[])value;
                } else {
                    throw RecoloredImage.illegalPropertyType(modifiers, "statistics", value);
                }
            }
            if ((value = modifiers.get("sampleDimensions")) != null && (range = RecoloredImage.getSampleDimension(value, visibleBand)) == null) {
                throw RecoloredImage.illegalPropertyType(modifiers, "sampleDimensions", value);
            }
        }
        if (Double.isNaN(minimum) || Double.isNaN(maximum)) {
            if (statistics == null) {
                if (statsAllBands == null) {
                    DoubleUnaryOperator[] sampleFilters = new DoubleUnaryOperator[visibleBand + 1];
                    sampleFilters[visibleBand] = ImageProcessor.filterNodataValues(nodataValues);
                    statsAllBands = processor.valueOfStatistics(statsSource, areaOfInterest, sampleFilters);
                }
                if (statsAllBands != null && visibleBand < statsAllBands.length) {
                    statistics = statsAllBands[visibleBand];
                }
            }
            if (statistics != null) {
                deviations *= statistics.standardDeviation(true);
                double mean = statistics.mean();
                if (Double.isNaN(minimum)) {
                    minimum = Math.max(statistics.minimum(), mean - deviations);
                }
                if (Double.isNaN(maximum)) {
                    maximum = Math.min(statistics.maximum(), mean + deviations);
                }
            }
        }
        if (!(minimum < maximum)) {
            return source;
        }
        if (source.getColorModel() instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)source.getColorModel();
            int size = icm.getMapSize();
            int validMin = 0;
            int validMax = size - 1;
            if (range == null) {
                range = RecoloredImage.getSampleDimension(source.getProperty("org.apache.sis.SampleDimensions"), visibleBand);
            }
            if (range != null) {
                double span = 0.0;
                for (Category category : range.getCategories()) {
                    if (!category.isQuantitative()) continue;
                    NumberRange<?> r = category.getSampleRange();
                    double min = Math.max(r.getMinDouble(true), 0.0);
                    double max = Math.min(r.getMaxDouble(true), (double)(size - 1));
                    double s = Math.min(max, maximum) - Math.max(min, minimum);
                    if (!(s > span)) continue;
                    validMin = (int)min;
                    validMax = (int)max;
                    span = s;
                }
            }
            int start = Math.max((int)minimum, validMin);
            int end = Math.min((int)maximum, validMax);
            int[] ARGB = new int[size];
            icm.getRGBs(ARGB);
            Arrays.fill(ARGB, validMin, start, icm.getRGB(validMin));
            Arrays.fill(ARGB, end + 1, validMax + 1, icm.getRGB(validMax));
            float scale = (float)((double)(validMax - validMin) / (maximum - minimum));
            for (int i = start; i <= end; ++i) {
                ARGB[i] = icm.getRGB(Math.round((float)(i - start) * scale) + validMin);
            }
            SampleModel sm = source.getSampleModel();
            cm = ColorModelFactory.createIndexColorModel(sm.getNumBands(), visibleBand, ARGB, icm.hasAlpha(), icm.getTransparentPixel());
        } else {
            SampleModel sm = source.getSampleModel();
            cm = ColorModelFactory.createGrayScale(sm.getDataType(), sm.getNumBands(), visibleBand, minimum, maximum);
        }
        while (true) {
            if (cm.equals(source.getColorModel())) {
                if (source instanceof RecoloredImage) {
                    RecoloredImage colored = (RecoloredImage)source;
                    if (colored.minimum != minimum || colored.maximum != maximum) continue;
                }
                return source;
            }
            if (!(source instanceof RecoloredImage)) break;
            source = ((RecoloredImage)source).source;
        }
        return ImageProcessor.unique(new RecoloredImage(source, cm, minimum, maximum));
    }

    private static SampleDimension getSampleDimension(Object value, int visibleBand) {
        List ranges;
        if (value instanceof SampleDimension[]) {
            SampleDimension[] ranges2 = (SampleDimension[])value;
            if (visibleBand < ranges2.length) {
                return ranges2[visibleBand];
            }
        } else if (value instanceof List && visibleBand < (ranges = (List)value).size()) {
            value = ranges.get(visibleBand);
        }
        return value instanceof SampleDimension ? (SampleDimension)value : null;
    }

    private static IllegalArgumentException illegalPropertyType(Map<String, ?> properties, String key, Object value) {
        return new IllegalArgumentException(Errors.getResources(properties).getString((short)58, key, value.getClass()));
    }

    @Override
    public ColorModel getColorModel() {
        return this.colors;
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            RecoloredImage other = (RecoloredImage)object;
            return Numerics.equals(this.minimum, other.minimum) && Numerics.equals(this.maximum, other.maximum) && this.colors.equals(other.colors);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 37 * this.colors.hashCode();
    }

    final Class<RecoloredImage> appendStringContent(StringBuilder buffer) {
        buffer.append(this.colors.getColorSpace());
        return RecoloredImage.class;
    }
}

