/*
 * Decompiled with CFR 0.152.
 */
package thredds.crawlabledataset.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFilter;

public class MultiSelectorFilter
implements CrawlableDatasetFilter {
    private final List<Selector> selectorGroup;
    private final boolean containsAtomicIncluders;
    private final boolean containsAtomicExcluders;
    private final boolean containsCollectionIncluders;
    private final boolean containsCollectionExcluders;

    public MultiSelectorFilter(List<Selector> selectorGroup) {
        if (selectorGroup == null || selectorGroup.isEmpty()) {
            this.selectorGroup = Collections.emptyList();
            this.containsAtomicIncluders = false;
            this.containsAtomicExcluders = false;
            this.containsCollectionIncluders = false;
            this.containsCollectionExcluders = false;
        } else {
            boolean anyAtomicIncluders = false;
            boolean anyAtomicExcluders = false;
            boolean anyCollectionIncluders = false;
            boolean anyCollectionExcluders = false;
            ArrayList<Selector> tmpSelectorGroup = new ArrayList<Selector>();
            for (Selector curSelector : selectorGroup) {
                if (curSelector.isIncluder()) {
                    if (curSelector.isApplyToAtomicDataset()) {
                        anyAtomicIncluders = true;
                    }
                    if (curSelector.isApplyToCollectionDataset()) {
                        anyCollectionIncluders = true;
                    }
                } else {
                    if (curSelector.isApplyToAtomicDataset()) {
                        anyAtomicExcluders = true;
                    }
                    if (curSelector.isApplyToCollectionDataset()) {
                        anyCollectionExcluders = true;
                    }
                }
                tmpSelectorGroup.add(curSelector);
            }
            this.selectorGroup = tmpSelectorGroup;
            this.containsAtomicIncluders = anyAtomicIncluders;
            this.containsAtomicExcluders = anyAtomicExcluders;
            this.containsCollectionIncluders = anyCollectionIncluders;
            this.containsCollectionExcluders = anyCollectionExcluders;
        }
    }

    public MultiSelectorFilter(Selector selector) {
        if (selector == null) {
            this.selectorGroup = Collections.emptyList();
            this.containsAtomicIncluders = false;
            this.containsAtomicExcluders = false;
            this.containsCollectionIncluders = false;
            this.containsCollectionExcluders = false;
        } else {
            boolean anyAtomicIncluders = false;
            boolean anyAtomicExcluders = false;
            boolean anyCollectionIncluders = false;
            boolean anyCollectionExcluders = false;
            if (selector.isIncluder()) {
                if (selector.isApplyToAtomicDataset()) {
                    anyAtomicIncluders = true;
                }
                if (selector.isApplyToCollectionDataset()) {
                    anyCollectionIncluders = true;
                }
            } else {
                if (selector.isApplyToAtomicDataset()) {
                    anyAtomicExcluders = true;
                }
                if (selector.isApplyToCollectionDataset()) {
                    anyCollectionExcluders = true;
                }
            }
            this.selectorGroup = Collections.singletonList(selector);
            this.containsAtomicIncluders = anyAtomicIncluders;
            this.containsAtomicExcluders = anyAtomicExcluders;
            this.containsCollectionIncluders = anyCollectionIncluders;
            this.containsCollectionExcluders = anyCollectionExcluders;
        }
    }

    @Override
    public Object getConfigObject() {
        return this.selectorGroup;
    }

    @Override
    public boolean accept(CrawlableDataset dataset) {
        if (dataset == null) {
            return false;
        }
        if (this.selectorGroup.isEmpty()) {
            return true;
        }
        if (dataset.isCollection() ? !this.containsCollectionIncluders && !this.containsCollectionExcluders : !this.containsAtomicIncluders && !this.containsAtomicExcluders) {
            return true;
        }
        boolean include = false;
        boolean exclude = false;
        for (Selector curSelector : this.selectorGroup) {
            if (!curSelector.isApplicable(dataset) || !curSelector.match(dataset)) continue;
            if (curSelector.isIncluder()) {
                include = true;
                continue;
            }
            exclude = true;
        }
        if (!dataset.isCollection()) {
            if (this.containsAtomicIncluders && !this.containsAtomicExcluders) {
                return include;
            }
            if (this.containsAtomicExcluders && !this.containsAtomicIncluders) {
                return !exclude;
            }
            if (this.containsAtomicIncluders && this.containsAtomicExcluders && include) {
                return !exclude;
            }
        } else {
            if (this.containsCollectionIncluders && !this.containsCollectionExcluders) {
                return include;
            }
            if (this.containsCollectionExcluders && !this.containsCollectionIncluders) {
                return !exclude;
            }
            if (this.containsCollectionIncluders && this.containsCollectionExcluders && include) {
                return !exclude;
            }
        }
        return false;
    }

    public static class Selector {
        private final boolean includer;
        private final boolean applyToAtomicDataset;
        private final boolean applyToCollectionDataset;
        private final CrawlableDatasetFilter filter;

        public Selector(CrawlableDatasetFilter filter, boolean includer, boolean applyToAtomicDataset, boolean applyToCollectionDataset) {
            this.filter = filter;
            this.includer = includer;
            this.applyToAtomicDataset = applyToAtomicDataset;
            this.applyToCollectionDataset = applyToCollectionDataset;
        }

        public CrawlableDatasetFilter getFilter() {
            return this.filter;
        }

        public boolean isApplyToAtomicDataset() {
            return this.applyToAtomicDataset;
        }

        public boolean isApplyToCollectionDataset() {
            return this.applyToCollectionDataset;
        }

        public boolean match(CrawlableDataset dataset) {
            return this.filter.accept(dataset);
        }

        public boolean isApplicable(CrawlableDataset dataset) {
            if (this.applyToAtomicDataset && !dataset.isCollection()) {
                return true;
            }
            return this.applyToCollectionDataset && dataset.isCollection();
        }

        public boolean isIncluder() {
            return this.includer;
        }

        public boolean isExcluder() {
            return !this.includer;
        }
    }
}

