/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard.plug;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import ucar.ma2.DataType;
import ucar.nc2.Dimension;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.point.standard.PointConfigXML;
import ucar.nc2.ft.point.standard.TableConfig;
import ucar.nc2.ft.point.standard.TableConfigurerImpl;

public class FslRaob
extends TableConfigurerImpl {
    @Override
    public boolean isMine(FeatureType wantFeatureType, NetcdfDataset ds) {
        String title = ds.findAttValueIgnoreCase(null, "version", null);
        return title != null && (title.startsWith("Forecast Systems Lab 1.3") || title.startsWith("Forecast Systems Lab 1.4"));
    }

    @Override
    public TableConfig getConfig(FeatureType wantFeatureType, NetcdfDataset ds, Formatter errlog) throws IOException {
        String title = ds.findAttValueIgnoreCase(null, "version", null);
        assert (title != null);
        boolean v4 = title.startsWith("Forecast Systems Lab 1.4");
        String xml = v4 ? "resources/nj22/pointConfig/FslRaob14.xml" : "resources/nj22/pointConfig/FslRaob13.xml";
        PointConfigXML reader = new PointConfigXML();
        TableConfig tc = reader.readConfigXMLfromResource(xml, wantFeatureType, ds, errlog);
        for (TableConfig inner : tc.children.get((int)0).children) {
            this.makeMultidimInner(ds, tc, inner, inner.outerName, inner.innerName);
        }
        return tc;
    }

    private void makeMultidimInner(NetcdfDataset ds, TableConfig parentTable, TableConfig childTable, String outerDin, String innerDim) {
        Dimension parentDim = ds.findDimension(outerDin);
        Dimension childDim = ds.findDimension(innerDim);
        List<Variable> vars = ds.getVariables();
        ArrayList<String> parentVars = new ArrayList<String>(vars.size());
        ArrayList<String> obsVars = new ArrayList<String>(vars.size());
        for (Variable orgV : vars) {
            Dimension dim0;
            if (orgV instanceof Structure || (dim0 = orgV.getDimension(0)) == null || !dim0.equals(parentDim)) continue;
            if (orgV.getRank() == 1 || orgV.getRank() == 2 && orgV.getDataType() == DataType.CHAR) {
                parentVars.add(orgV.getShortName());
                continue;
            }
            Dimension dim1 = orgV.getDimension(1);
            if (dim1 == null || !dim1.equals(childDim)) continue;
            obsVars.add(orgV.getShortName());
        }
        parentTable.vars = parentVars;
        childTable.vars = obsVars;
    }
}

